/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.services.SequenceGenerator;

public class EntityTypes {
    private static final Log log = LogFactory.getLog(EntityTypes.class);
    private static EntityTypes singleton;
    private Map entityTypesByID;
    private Map entityTypesByType;
    private Object updateLock = new Object();
    private static String ENTITY_TYPE_TABLE;
    private static String TYPE_ID_COLUMN;
    private static String TYPE_NAME_COLUMN;
    private static String DESCRIPTIVE_NAME_COLUMN;
    public static int NULL_TYPE_ID;
    public static Class GROUP_ENTITY_TYPE;
    public static Class LEAF_ENTITY_TYPE;

    private EntityTypes(DataSource ds) {
        this.initialize(ds);
    }

    public static void addIfNecessary(Class newType, String description) throws Exception {
        EntityTypes.singleton().addEntityTypeIfNecessary(newType, description);
    }

    private void addEntityType(Class newType, String description) throws Exception {
        if (this.getEntityTypesByType().get(newType) == null) {
            int nextKey = this.getNextKey();
            EntityType et = new EntityType(newType, new Integer(nextKey), description);
            this.insertEntityType(et);
            this.primAddEntityType(et);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityTypeIfNecessary(Class newType, String description) throws Exception {
        Object object = this.updateLock;
        synchronized (object) {
            block7: {
                if (this.getEntityTypesByType().get(newType) == null) {
                    EntityTypes.refresh();
                    if (this.getEntityTypesByType().get(newType) == null) {
                        try {
                            this.addEntityType(newType, description);
                        }
                        catch (Exception ex) {
                            EntityTypes.refresh();
                            if (this.getEntityTypesByType().get(newType) != null) break block7;
                            String errString = "Attempt to add entity type failed: " + ex.getMessage();
                            log.error((Object)errString, (Throwable)ex);
                            throw ex;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntityType(Class type) throws SQLException {
        Object object = this.updateLock;
        synchronized (object) {
            EntityTypes.refresh();
            EntityType et = (EntityType)this.getEntityTypesByType().get(type);
            if (et != null) {
                this.deleteEntityType(et);
                this.primRemoveEntityType(et);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntityType(EntityType et) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            try {
                int rc;
                ps = conn.prepareStatement(EntityTypes.getDeleteEntityTypeSql());
                ps.setInt(1, et.getTypeId());
                ps.setString(2, et.getType().getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EntityTypes.deleteEntityType(): " + ps + "(" + et.getTypeId() + ", " + et.getType() + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem deleting type " + et;
                    log.error((Object)errString);
                    throw new SQLException(errString);
                }
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                finally {
                    RDBMServices.releaseConnection(conn);
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Exception deleting entity type [" + et + "]"), (Throwable)sqle);
            throw sqle;
        }
    }

    private static String getAllColumnNames() {
        return TYPE_ID_COLUMN + ", " + TYPE_NAME_COLUMN + ", " + DESCRIPTIVE_NAME_COLUMN;
    }

    public Iterator getAllEntityTypeIDs() {
        return this.entityTypesByID.keySet().iterator();
    }

    public Iterator getAllEntityTypes() {
        ArrayList<Class> types = new ArrayList<Class>(this.getEntityTypesByType().size());
        for (EntityType et : this.entityTypesByID.values()) {
            types.add(et.getType());
        }
        return types.iterator();
    }

    private static String getDeleteEntityTypeSql() {
        return "DELETE FROM " + ENTITY_TYPE_TABLE + " WHERE " + TYPE_ID_COLUMN + " = ? AND " + TYPE_NAME_COLUMN + " = ?";
    }

    public static String getDescriptiveName(Class type) {
        return EntityTypes.singleton().getDescriptiveNameForType(type);
    }

    public String getDescriptiveNameForType(Class type) {
        EntityType et = (EntityType)this.getEntityTypesByType().get(type);
        return et.getDescriptiveName();
    }

    public Integer getEntityIDFromType(Class type) {
        EntityType et = (EntityType)this.getEntityTypesByType().get(type);
        return et == null ? null : et.getTypeId();
    }

    public static Class getEntityType(Integer typeID) {
        return EntityTypes.singleton().getEntityTypeFromID(typeID);
    }

    public Class getEntityTypeFromID(Integer id) {
        EntityType et = (EntityType)this.getEntityTypesByID().get(id);
        return et == null ? null : et.getType();
    }

    public static Integer getEntityTypeID(Class type) {
        return EntityTypes.singleton().getEntityIDFromType(type);
    }

    private synchronized Map getEntityTypesByID() {
        return this.entityTypesByID;
    }

    private Map cloneHashMap(Map m) {
        return (Map)((HashMap)m).clone();
    }

    private synchronized Map getEntityTypesByType() {
        return this.entityTypesByType;
    }

    private static String getInsertEntityTypeSql() {
        return "INSERT INTO " + ENTITY_TYPE_TABLE + " (" + EntityTypes.getAllColumnNames() + ") VALUES (?, ?, ?)";
    }

    private int getNextKey() throws Exception {
        return SequenceGenerator.instance().getNextInt(ENTITY_TYPE_TABLE);
    }

    private static String getSelectEntityTypesSql() {
        return "SELECT " + EntityTypes.getAllColumnNames() + " FROM " + ENTITY_TYPE_TABLE;
    }

    private static String getUpdateEntityTypeSql() {
        return "UPDATE " + ENTITY_TYPE_TABLE + " SET " + DESCRIPTIVE_NAME_COLUMN + " = ? WHERE " + TYPE_ID_COLUMN + " = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds) {
        Connection conn = null;
        try {
            conn = ds == null ? RDBMServices.getConnection() : ds.getConnection();
            this.initialize(conn);
        }
        catch (Exception ex) {
            log.error((Object)"Exception initializing cache of entity types.", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    if (ds == null) {
                        RDBMServices.releaseConnection(conn);
                    } else {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Connection conn) {
        this.initializeCaches();
        Integer typeID = null;
        Class<?> entityType = null;
        String description = null;
        EntityType et = null;
        try {
            Statement stmnt = conn.createStatement();
            try {
                ResultSet rs = stmnt.executeQuery(EntityTypes.getSelectEntityTypesSql());
                try {
                    while (rs.next()) {
                        typeID = new Integer(rs.getInt(1));
                        entityType = Class.forName(rs.getString(2));
                        description = rs.getString(3);
                        et = new EntityType(entityType, typeID, description);
                        this.primAddEntityType(et);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Exception initializing cache of entity types.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.initialize(conn);
        }
        catch (Exception ex) {
            log.error((Object)"Exception initializing cache of entity types.", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                RDBMServices.releaseConnection(conn);
            }
        }
    }

    private void initializeCaches() {
        this.entityTypesByID = new HashMap(10);
        this.entityTypesByType = new HashMap(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEntityType(EntityType et) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            try {
                int rc;
                ps = conn.prepareStatement(EntityTypes.getInsertEntityTypeSql());
                ps.setInt(1, et.getTypeId());
                ps.setString(2, et.getType().getName());
                ps.setString(3, et.getDescriptiveName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EntityTypes.insertEntityType(): " + ps + "(" + et.getTypeId() + ", " + et.getType() + ", " + et.getDescriptiveName() + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem adding entity type " + et;
                    log.error((Object)errString);
                    throw new SQLException(errString);
                }
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                finally {
                    RDBMServices.releaseConnection(conn);
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Error inserting entity type " + et), (Throwable)sqle);
            throw sqle;
        }
    }

    private void primAddEntityType(EntityType et) {
        Map typesByType = this.cloneHashMap(this.getEntityTypesByType());
        typesByType.put(et.getType(), et);
        Map typesByID = this.cloneHashMap(this.getEntityTypesByID());
        typesByID.put(et.getTypeId(), et);
        this.setEntityTypesByType(typesByType);
        this.setEntityTypesByID(typesByID);
    }

    private void primRemoveEntityType(EntityType et) {
        Map typesByType = this.cloneHashMap(this.getEntityTypesByType());
        typesByType.remove(et.getType());
        Map typesByID = this.cloneHashMap(this.getEntityTypesByID());
        typesByID.remove(et.getTypeId());
        this.setEntityTypesByType(typesByType);
        this.setEntityTypesByID(typesByID);
    }

    public static synchronized void refresh() {
        EntityTypes.singleton().initialize();
    }

    public synchronized void setEntityTypesByID(Map m) {
        this.entityTypesByID = m;
    }

    public synchronized void setEntityTypesByType(Map m) {
        this.entityTypesByType = m;
    }

    public static EntityTypes singleton() {
        return EntityTypes.singleton(null);
    }

    public static synchronized EntityTypes singleton(DataSource ds) {
        if (singleton == null) {
            singleton = new EntityTypes(ds);
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntityType(Class type, String newDescription) throws Exception {
        Object object = this.updateLock;
        synchronized (object) {
            EntityTypes.refresh();
            EntityType et = (EntityType)this.getEntityTypesByType().get(type);
            if (et == null) {
                this.addEntityType(type, newDescription);
            } else {
                et.descriptiveName = newDescription;
                this.updateEntityType(et);
                this.primAddEntityType(et);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntityType(EntityType et) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            try {
                int rc;
                ps = conn.prepareStatement(EntityTypes.getUpdateEntityTypeSql());
                ps.setString(1, et.getDescriptiveName());
                ps.setInt(2, et.getTypeId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EntityTypes.updateEntityType(): " + ps + "(" + et.getType() + ", " + et.getDescriptiveName() + ", " + et.getTypeId() + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem updating type " + et;
                    log.error((Object)errString);
                    throw new SQLException(errString);
                }
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                finally {
                    RDBMServices.releaseConnection(conn);
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Exception updating entity type [" + et + "]"), (Throwable)sqle);
            throw sqle;
        }
    }

    static {
        ENTITY_TYPE_TABLE = "UP_ENTITY_TYPE";
        TYPE_ID_COLUMN = "ENTITY_TYPE_ID";
        TYPE_NAME_COLUMN = "ENTITY_TYPE_NAME";
        DESCRIPTIVE_NAME_COLUMN = "DESCRIPTIVE_NAME";
        NULL_TYPE_ID = -1;
        GROUP_ENTITY_TYPE = IEntityGroup.class;
        LEAF_ENTITY_TYPE = IEntity.class;
    }

    private class EntityType {
        private Class type;
        private Integer typeId;
        private String descriptiveName;

        private EntityType(Class cl, Integer id, String description) {
            this.type = cl;
            this.typeId = id;
            this.descriptiveName = description;
        }

        private Class getType() {
            return this.type;
        }

        private Integer getTypeId() {
            return this.typeId;
        }

        private String getDescriptiveName() {
            return this.descriptiveName;
        }

        public String toString() {
            String desc = this.descriptiveName == null ? "" : this.descriptiveName;
            return desc + " (" + this.getTypeId() + ") " + this.getType().getName();
        }
    }
}

