/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.serialize.CachingHTMLSerializer;
import org.jasig.portal.serialize.CachingXHTMLSerializer;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XMLSerializer;

public class MediaManager {
    private static final Log log = LogFactory.getLog(MediaManager.class);
    protected OrderedProps mediaProps = null;
    protected OrderedProps mimeProps = null;
    protected OrderedProps serializerProps = null;
    private static boolean outputIndenting = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.MediaManager.output_indenting", false);
    private boolean omitDoctype = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.MediaManager.omit_doctype", false);
    private static final String mediaPropsUrl = MediaManager.class.getResource("/properties/media.properties").toString();
    private static final String mimePropsUrl = MediaManager.class.getResource("/properties/mime.properties").toString();
    private static final String serializerPropsUrl = MediaManager.class.getResource("/properties/serializer.properties").toString();
    private static final MediaManager MEDIAMANAGER = new MediaManager(mediaPropsUrl, mimePropsUrl, serializerPropsUrl);
    private static final MediaManager MEDIAMANAGER_OMIT_DOCTYPE = new MediaManager(mediaPropsUrl, mimePropsUrl, serializerPropsUrl, true);
    private static final MediaManager MEDIAMANAGER_INCLUDE_DOCTYPE = new MediaManager(mediaPropsUrl, mimePropsUrl, serializerPropsUrl, false);
    public static final String NULL_USER_AGENT = "null";
    public static final String UNKNOWN = "unknown";
    public static String HTMLPublicId = PropertiesManager.getProperty("org.jasig.portal.MediaManager.HTMLPublicId", "-//W3C//DTD HTML 4.01 Transitional//EN");
    public static String HTMLSystemId = PropertiesManager.getProperty("org.jasig.portal.MediaManager.HTMLSystemId", "http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd");
    public static String XHTMLPublicId = PropertiesManager.getProperty("org.jasig.portal.MediaManager.XHTMLPublicId", "-//W3C//DTD XHTML 1.0 Transitional//EN");
    public static String XHTMLSystemId = PropertiesManager.getProperty("org.jasig.portal.MediaManager.XHTMLSystemId", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
    public static String WMLPublicId = PropertiesManager.getProperty("org.jasig.portal.MediaManager.WMLPublicId", "-//WAPFORUM//DTD WML 1.1//EN");
    public static String WMLSystemId = PropertiesManager.getProperty("org.jasig.portal.MediaManager.WMLSystemId", "http://www.wapforum.org/DTD/wml_1.1.xml");

    private MediaManager() {
    }

    public static MediaManager getMediaManager() {
        return MEDIAMANAGER;
    }

    public static MediaManager getMediaManager(boolean omitDocType) {
        if (omitDocType) {
            return MEDIAMANAGER_OMIT_DOCTYPE;
        }
        return MEDIAMANAGER_INCLUDE_DOCTYPE;
    }

    private MediaManager(String mediaPropsFile, String mimePropsFile, String serializerPropsFile) {
        this.setMediaProps(mediaPropsFile);
        this.setMimeProps(mimePropsFile);
        this.setSerializerProps(serializerPropsFile);
    }

    private MediaManager(String mediaPropsFile, String mimePropsFile, String serializerPropsFile, boolean omitDocType) {
        this(mediaPropsFile, mimePropsFile, serializerPropsFile);
        this.omitDoctype = omitDocType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaProps(String uri) {
        block5: {
            URL url = null;
            try {
                url = uri == null ? this.getClass().getResource("/properties/media.properties") : new URL(uri);
                if (url == null) break block5;
                InputStream in = url.openStream();
                try {
                    this.mediaProps = new OrderedProps(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)("MediaManager::setMediaProps : Exception occurred while loading media properties file: " + uri + ". " + ioe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMimeProps(String uri) {
        block5: {
            URL url = null;
            try {
                url = uri == null ? this.getClass().getResource("/properties/mime.properties") : new URL(uri);
                if (url == null) break block5;
                InputStream in = url.openStream();
                try {
                    this.mimeProps = new OrderedProps(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)("MediaManager::setMimeProps : Exception occurred while loading mime properties file: " + uri + ". " + ioe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerializerProps(String uri) {
        block5: {
            URL url = null;
            try {
                url = uri == null ? this.getClass().getResource("/properties/serializer.properties") : new URL(uri);
                if (url == null) break block5;
                InputStream in = url.openStream();
                try {
                    this.serializerProps = new OrderedProps(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)("MediaManager::setSerializerProps : Exception occurred while loading serializer properties file: " + uri + ". " + ioe));
            }
        }
    }

    public String getMedia(HttpServletRequest req) {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            String ua = req.getHeader("User-Agent");
            if (ua == null || ua.equals("")) {
                ua = NULL_USER_AGENT;
            }
            return this.mediaProps.getValue(ua);
        }
        return null;
    }

    public String getMedia(BrowserInfo bi) {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            return this.mediaProps.getValue(bi.getUserAgent());
        }
        return null;
    }

    public String getDefaultMedia() {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            return this.mediaProps.getDefaultValue();
        }
        return null;
    }

    public String getReturnMimeType(HttpServletRequest req) {
        String accepts;
        String mimeType = this.getReturnMimeType(this.getMedia(req));
        if (UNKNOWN.equals(mimeType) && (accepts = req.getHeader("accept")) != null && accepts.indexOf("text/html") != -1) {
            mimeType = "text/html";
        }
        return mimeType;
    }

    public String getReturnMimeType(String mediaType) {
        if (this.mimeProps == null) {
            this.setMimeProps(null);
        }
        if (this.mimeProps != null) {
            return this.mimeProps.getValue(mediaType);
        }
        return null;
    }

    public BaseMarkupSerializer getSerializer(String mediaType, Writer out) {
        String serializerName = null;
        if (this.serializerProps == null) {
            this.setSerializerProps(null);
        }
        if (this.serializerProps != null) {
            serializerName = this.serializerProps.getValue(mediaType);
        }
        if (serializerName != null) {
            return this.getSerializerByName(serializerName, out);
        }
        log.error((Object)"MediaManager::getSerializer() : Unable to initialize serializerProperties. Returning a null serializer object");
        return null;
    }

    public BaseMarkupSerializer getSerializerByName(String serializerName, OutputStream out) throws UnsupportedEncodingException {
        return this.getSerializerByName(serializerName, new OutputStreamWriter(out, "UTF-8"));
    }

    public BaseMarkupSerializer getSerializerByName(String serializerName, Writer out) {
        if (serializerName != null && serializerName.equals("WML")) {
            OutputFormat frmt = new OutputFormat("wml", "UTF-8", true);
            frmt.setDoctype(WMLPublicId, WMLSystemId);
            return new XMLSerializer(out, frmt);
        }
        if (serializerName != null && serializerName.equals("XML")) {
            OutputFormat frmt = new OutputFormat("XML", "UTF-8", true);
            return new XMLSerializer(out, frmt);
        }
        if (serializerName != null && serializerName.equals("XHTML")) {
            OutputFormat frmt = new OutputFormat("XHTML", "UTF-8", true);
            frmt.setPreserveSpace(true);
            frmt.setIndenting(outputIndenting);
            frmt.setDoctype(XHTMLPublicId, XHTMLSystemId);
            frmt.setOmitDocumentType(this.omitDoctype);
            return new CachingXHTMLSerializer(out, frmt);
        }
        OutputFormat frmt = new OutputFormat("HTML", "UTF-8", true);
        frmt.setPreserveSpace(true);
        frmt.setIndenting(outputIndenting);
        frmt.setDoctype(HTMLPublicId, HTMLSystemId);
        frmt.setOmitDocumentType(this.omitDoctype);
        return new CachingHTMLSerializer(out, frmt);
    }

    public BaseMarkupSerializer getSerializer(String mediaType, OutputStream out) throws UnsupportedEncodingException {
        return this.getSerializer(mediaType, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }

    public BaseMarkupSerializer getSerializer(HttpServletRequest req, Writer out) {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            String ua = req.getHeader("User-Agent");
            if (ua == null || ua.equals("")) {
                ua = NULL_USER_AGENT;
            }
            return this.getSerializer(this.mediaProps.getValue(ua), out);
        }
        log.error((Object)"MediaManager::getSerializer() : Unable to initialize mediaProperties. Returning a null serializer object");
        return null;
    }

    public BaseMarkupSerializer getSerializer(HttpServletRequest req, OutputStream out) throws UnsupportedEncodingException {
        return this.getSerializer(req, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }

    class OrderedProps {
        private Vector attVec = new Vector(15);

        OrderedProps(InputStream inputStream) throws IOException {
            String currentLine;
            BufferedReader input = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String Key2 = null;
            while ((currentLine = input.readLine()) != null) {
                StringTokenizer currentTokens = new StringTokenizer(currentLine, "=\t\r\n");
                if (currentTokens.hasMoreTokens()) {
                    Key2 = currentTokens.nextToken().trim();
                }
                if (Key2 == null || Key2.startsWith("#") || !currentTokens.hasMoreTokens()) continue;
                String[] temp = new String[]{Key2, currentTokens.nextToken().trim()};
                this.attVec.addElement(temp);
            }
            input.close();
        }

        String getValue(String s) {
            int j = this.attVec.size();
            for (int i = 0; i < j; ++i) {
                String[] temp = (String[])this.attVec.elementAt(i);
                if (s.indexOf(temp[0]) <= -1) continue;
                return temp[1];
            }
            return MediaManager.UNKNOWN;
        }

        String getDefaultValue() {
            return ((String[])this.attVec.elementAt(0))[1];
        }
    }
}

