/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.car.CarClassLoader;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.spring.locator.CarResourcesLocator;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.springframework.web.context.ServletContextAware;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CarResources
implements ServletContextAware {
    private static final Log log = LogFactory.getLog(CarResources.class);
    private static CarClassLoader loader = null;
    public static final String RCS_ID = "@(#) $Header$";
    static final String DEPLOYMENT_DESCRIPTOR = "META-INF/comp.xml";
    private static final String WELL_KNOWN_DIR = "/WEB-INF/cars";
    private static final String CAR_DIR_PROP_NAME = "org.jasig.portal.car.CarResources.directory";
    public static final String CAR_WORKER_ID = "carRsrc";
    public static final String CAR_RESOURCE_PARM = "carRsrc";
    private ServletContext servletContext;
    private final Map<String, JarFile> resourceJars = new Hashtable<String, JarFile>();
    private final Map<JarFile, File> carsByJars = new Hashtable<JarFile, File>();
    private final Map<File, List<String>> carContents = new Hashtable<File, List<String>>();
    private final Map<String, File> carsByPath = new Hashtable<String, File>();
    private final SAX2BufferImpl services = new SAX2BufferImpl();
    private final Properties workers = new Properties();
    private boolean carsLoaded = false;
    private final List<JarFile> jarsWithDescriptors = new Vector<JarFile>();
    private String carDirPath = null;
    private final FileFilter carFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.getName().endsWith(".car");
        }
    };
    private final FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        loader = new CarClassLoader(this);
        try {
            this.loadCars();
        }
        catch (Exception e) {
            log.error((Object)"An Exception occurred while loading channel archives. Any channels deployed via CARs will not be available.", (Throwable)e);
        }
        this.processDescriptors();
        Class<CarResources> clazz = CarResources.class;
        synchronized (CarResources.class) {
            CarResources.class.notifyAll();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void processDescriptors() {
        if (this.carsLoaded) {
            for (JarFile jarFile : this.jarsWithDescriptors) {
                try {
                    DescriptorHandler handler = new DescriptorHandler(jarFile);
                    handler.getWorkers(this.workers);
                    handler.getServices(this.services);
                }
                catch (Exception e) {
                    log.error((Object)("An Exception occurred while processing deployment descriptor META-INF/comp.xml in " + jarFile.getName() + ". "), (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    public static CarResources getInstance() {
        return CarResourcesLocator.getCarResources();
    }

    public ClassLoader getClassLoader() {
        return loader;
    }

    private File getWellKnownDir() {
        if (this.servletContext == null) {
            log.warn((Object)"Channel Archives will not be  loaded. Unable to aquire the real path to '/WEB-INF/cars' due to no ServletCotnext being available. Alternatively, you can specify a fully qualified path as the value of a 'org.jasig.portal.car.CarResources.directory' property in portal.properties.");
            return null;
        }
        String carDirRealPath = this.servletContext.getRealPath(WELL_KNOWN_DIR);
        if (carDirRealPath == null) {
            log.warn((Object)"Channel Archives will not be  loaded. Unable to aquire the real path to '/WEB-INF/cars'. This can occur if the portal is deployed as a WAR and directories can not be created within its directory structure. Alternatively, you can specify a fully qualified path as the value of a 'org.jasig.portal.car.CarResources.directory' property in portal.properties.");
            return null;
        }
        File carDir = new File(carDirRealPath);
        if (!carDir.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Channel Archives can not be  loaded. CAR directory '" + carDirRealPath + "' does not exist."));
            }
            return null;
        }
        this.carDirPath = carDirRealPath;
        return carDir;
    }

    private File getPropertySpecifiedDir() {
        String carDirPath = null;
        File carDir = null;
        try {
            carDirPath = PropertiesManager.getProperty(CAR_DIR_PROP_NAME);
            carDir = new File(carDirPath);
        }
        catch (RuntimeException re) {
            if (log.isInfoEnabled()) {
                log.info((Object)"CAR directory property 'org.jasig.portal.car.CarResources.directory' not specified. Defaulting to well-known directory '/WEB-INF/cars'.");
            }
            return null;
        }
        if (!carDir.exists()) {
            log.error((Object)("CAR directory '" + carDirPath + "' specified by property '" + CAR_DIR_PROP_NAME + "' does not exist. Channel Archives can not be loaded from this directory."));
            return null;
        }
        this.carDirPath = carDirPath;
        return carDir;
    }

    private void loadCars() {
        File carDir = this.getPropertySpecifiedDir();
        if (carDir == null) {
            carDir = this.getWellKnownDir();
        }
        if (carDir != null) {
            this.scanDir(carDir);
            if (log.isInfoEnabled()) {
                log.info((Object)("Channel Archives Loaded: " + this.carsByPath.size() + " from '" + this.carDirPath + "'"));
            }
        }
        this.carsLoaded = true;
    }

    private void scanDir(File dir) {
        File[] dirs;
        File[] cars = dir.listFiles(this.carFilter);
        if (cars != null && cars.length != 0) {
            for (File car : cars) {
                this.loadCarEntries(car);
            }
        }
        if ((dirs = dir.listFiles(this.dirFilter)) != null && dirs.length != 0) {
            for (File dir2 : dirs) {
                this.scanDir(dir2);
            }
        }
    }

    private void loadCarEntries(File car) {
        JarFile jar = null;
        try {
            jar = new JarFile(car);
        }
        catch (IOException ioe) {
            log.error((Object)("CAR " + this.getCarPath(car) + " could not be loaded. Details: " + (ioe.getMessage() != null ? ioe.getMessage() : ioe.getClass().getName())), (Throwable)ioe);
            return;
        }
        Vector<String> entryList = new Vector<String>();
        this.carsByJars.put(jar, car);
        this.carsByPath.put(this.getCarPath(car), car);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (name.equals(DEPLOYMENT_DESCRIPTOR)) {
                this.jarsWithDescriptors.add(jar);
            } else {
                this.resourceJars.put(name, jar);
            }
            entryList.add(name);
        }
        this.carContents.put(car, entryList);
    }

    public void getWorkers(Properties workers) {
        for (Map.Entry<Object, Object> element : this.workers.entrySet()) {
            Map.Entry<Object, Object> entry = element;
            if (workers.containsKey(entry.getKey())) continue;
            workers.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean hasDescriptors() {
        return this.jarsWithDescriptors.size() > 0;
    }

    public void getServices(ContentHandler contentHandler) throws SAXException {
        this.services.outputBuffer(contentHandler);
    }

    public InputStream getResourceAsStream(String resource) throws PortalException {
        JarFile jar = this.resourceJars.get(resource);
        if (jar == null) {
            return null;
        }
        ZipEntry entry = jar.getEntry(resource);
        if (entry == null) {
            return null;
        }
        try {
            return jar.getInputStream(entry);
        }
        catch (IOException ioe) {
            throw new PortalException("Unable to get input stream for " + resource);
        }
    }

    public long getResourceSize(String resource) {
        JarFile jar = this.resourceJars.get(resource);
        if (jar == null) {
            return -1L;
        }
        ZipEntry entry = jar.getEntry(resource);
        if (entry == null) {
            return -1L;
        }
        return entry.getSize();
    }

    public URL findResource(String entry) {
        if (entry == null) {
            return null;
        }
        JarFile jar = this.resourceJars.get(entry = this.resolveRegExpr(entry));
        if (jar == null) {
            return null;
        }
        File carFile = this.carsByJars.get(jar);
        if (carFile == null) {
            return null;
        }
        String url = "jar:file:" + carFile.getAbsolutePath() + "!/" + entry;
        try {
            return new URL(url);
        }
        catch (MalformedURLException me) {
            return null;
        }
    }

    public String getContainingCarPath(String entry) {
        if (entry == null) {
            return null;
        }
        JarFile jar = this.resourceJars.get(entry);
        if (jar == null) {
            return null;
        }
        File carFile = this.carsByJars.get(jar);
        if (carFile == null) {
            return null;
        }
        return this.getCarPath(carFile);
    }

    public boolean containsResource(String resource) {
        return this.resourceJars.containsKey(resource);
    }

    public String[] listCars() {
        File[] carFiles = this.carsByJars.values().toArray(new File[this.carsByJars.size()]);
        String[] carNames = new String[carFiles.length];
        for (int i = 0; i < carFiles.length; ++i) {
            carNames[i] = this.getCarPath(carFiles[i]);
        }
        return carNames;
    }

    public String[] listCarResources(String carPath) {
        File car = this.carsByPath.get(carPath);
        if (car == null) {
            return null;
        }
        List<String> contents = this.carContents.get(car);
        if (contents == null) {
            return null;
        }
        return contents.toArray(new String[contents.size()]);
    }

    private String getCarPath(File car) {
        String carPath = car.getAbsolutePath();
        return carPath.substring(this.carDirPath.length() + 1);
    }

    public String[] listAllResources() {
        return this.resourceJars.keySet().toArray(new String[this.resourceJars.size()]);
    }

    private String replace(String entry, String regExpr, String replacement) {
        String copy = entry;
        boolean beginIdx = false;
        int endIdx = copy.indexOf(regExpr);
        StringBuffer buff = new StringBuffer();
        while (endIdx != -1) {
            String newStr = copy.substring(0, endIdx);
            copy = copy.substring(endIdx + 3, copy.length());
            buff.append(newStr).append(replacement);
            endIdx = copy.indexOf(regExpr);
            if (endIdx != -1) continue;
            buff.append(copy);
        }
        if (buff.toString().length() > 0) {
            entry = buff.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CarResources replace() - returned entry is: " + entry));
        }
        return entry;
    }

    private String resolveRegExpr(String entry) {
        String replacement = "~";
        if ((entry = this.replace(entry, "../", "~")).indexOf("~") != -1) {
            String delim = "/";
            StringBuffer sb = new StringBuffer();
            if (log.isDebugEnabled()) {
                log.debug((Object)("CarResources resolveRegExpr() -  Parsing resource name: " + entry));
            }
            StringTokenizer st = new StringTokenizer(entry, "~");
            int tokens = st.countTokens();
            int count = 1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CarResources resolveRegExpr() - Token is now: " + token));
                }
                StringTokenizer st1 = new StringTokenizer(token, "/");
                int childTokens = st1.countTokens();
                int childCount = 1;
                while (st1.hasMoreTokens()) {
                    String childToken = st1.nextToken();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("CarResources resolveRegExpr() - Child token is: " + childToken));
                    }
                    if (childCount < childTokens) {
                        sb.append(childToken);
                        sb.append("/");
                    } else {
                        if (count != tokens) break;
                        sb.append(childToken);
                    }
                    ++childCount;
                }
                ++count;
            }
            entry = sb.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CarResources resolveRegExpr() - resolved entry is: " + entry));
        }
        return entry;
    }
}

