/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.tools.RegisterChannelType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChannelTypeTagHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ChannelTypeTagHandler.class);
    private String clazz = null;
    private String name = null;
    private String description = null;
    private String uri = null;
    private ParsingContext ctx = null;
    private StringBuffer charBufr = new StringBuffer();

    public ChannelTypeTagHandler(ParsingContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("channel-type") && this.ctx.getPath().equals(DescriptorHandler.CHANTYPES)) {
            this.clazz = null;
            this.name = null;
            this.description = null;
            this.uri = null;
        }
        this.charBufr.delete(0, this.charBufr.length());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charBufr.append(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("name")) {
            this.name = this.charBufr.toString();
        } else if (qName.equals("class")) {
            this.clazz = this.charBufr.toString();
        } else if (qName.equals("description")) {
            this.description = this.charBufr.toString();
        } else if (qName.equals("uri")) {
            this.uri = this.charBufr.toString();
        } else if (qName.equals("channel-type") && this.ctx.getPath().equals(DescriptorHandler.CHANTYPES)) {
            try {
                RegisterChannelType.register(this.clazz, this.name, this.description, this.uri);
            }
            catch (Exception e) {
                log.error((Object)("A problem occurred while registering a channel type. " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

