/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;

public class Path {
    public static final String RCS_ID = "@(#) $Header$";
    private LinkedList list = new LinkedList();
    private static final int OUT_OF_TAG = 0;
    private static final int IN_TAG = 1;

    public static Path fromTag(String tagName) {
        return Path.fromXML("<" + tagName + ">");
    }

    public static Path fromXML(String xmlPath) {
        Path path = new Path();
        if (xmlPath == null) {
            return path;
        }
        boolean state = false;
        StringBuffer label = new StringBuffer();
        for (int i = 0; i < xmlPath.length(); ++i) {
            char c = xmlPath.charAt(i);
            if (!state) {
                if (c != '<') continue;
                state = true;
                continue;
            }
            if (c == '>') {
                state = false;
                path.append(label.toString());
                label.delete(0, label.length());
                continue;
            }
            label.append(c);
        }
        return path;
    }

    public Path append(String item) {
        if (item != null) {
            this.list.add(item);
        }
        return this;
    }

    public String removeLast() {
        if (this.list.size() > 0) {
            return (String)this.list.removeLast();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        return this.list.equals(((Path)o).list);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            pw.print("<" + i.next() + ">");
        }
        pw.flush();
        return sw.toString();
    }
}

