/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channel.dao.jpa;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.channel.ChannelLifecycleState;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channel.XmlGeneratingBaseChannelDefinition;
import org.jasig.portal.channel.dao.jpa.ChannelLocalizationData;
import org.jasig.portal.channel.dao.jpa.ChannelParameterImpl;
import org.jasig.portal.channel.dao.jpa.ChannelTypeImpl;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;

@Entity
@Table(name="UP_CHANNEL")
@GenericGenerator(name="UP_CHANNEL_DEF_GEN", strategy="native", parameters={@Parameter(name="sequence", value="UP_CHANNEL_DEF_SEQ"), @Parameter(name="table", value="UP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_UP_CHANNEL_DEF_HI")})
public class ChannelDefinitionImpl
extends XmlGeneratingBaseChannelDefinition
implements IChannelDefinition,
IBasicEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_CHANNEL_DEF_GEN")
    @Column(name="CHAN_ID")
    private final int internalId;
    @Column(name="CHAN_NAME", length=128, nullable=false, unique=true)
    private String name;
    @Column(name="CHAN_FNAME", length=255, nullable=false, unique=true)
    @Type(type="fname")
    @Index(name="IDX_CHAN_DEF__FNAME")
    private String fname;
    @Column(name="CHAN_TITLE", length=128, nullable=false)
    private String title;
    @Column(name="CHAN_CLASS", length=100, nullable=false)
    private String clazz;
    @ManyToOne(targetEntity=ChannelTypeImpl.class, optional=false)
    @JoinColumn(name="CHAN_TYPE_ID", nullable=false)
    private IChannelType channelType;
    @Column(name="CHAN_DESC", length=255)
    private String description;
    @Column(name="CHAN_TIMEOUT", nullable=false)
    private int timeout = 20000;
    @Column(name="CHAN_PUBL_ID")
    private int publisherId = -1;
    @Column(name="CHAN_APVL_ID")
    private int approverId = -1;
    @Column(name="CHAN_EXP_ID")
    private int expirerId = -1;
    @Column(name="CHAN_PUBL_DT")
    private Date publishDate = null;
    @Column(name="CHAN_APVL_DT")
    private Date approvalDate = null;
    @Column(name="CHAN_EXP_DT")
    private Date expirationDate = null;
    @Column(name="CHAN_EDITABLE", nullable=false)
    private boolean editable = false;
    @Column(name="CHAN_HAS_HELP", nullable=false)
    private boolean hasHelp = false;
    @Column(name="CHAN_HAS_ABOUT", nullable=false)
    private boolean hasAbout = false;
    @Column(name="CHAN_SECURE", nullable=false)
    private boolean secure = false;
    @CollectionOfElements(fetch=FetchType.EAGER, targetElement=ChannelParameterImpl.class)
    @JoinTable(name="UP_CHANNEL_PARAM", joinColumns={@JoinColumn(name="CHAN_ID")})
    private Set<IChannelParameter> parameters = new HashSet<IChannelParameter>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="UP_CHANNEL_MDATA", joinColumns={@JoinColumn(name="CHAN_ID")})
    @MapKey(columns={@Column(name="LOCALE", length=64, nullable=false)})
    private Map<String, ChannelLocalizationData> localizations = new HashMap<String, ChannelLocalizationData>();
    @OneToMany(mappedBy="channelDefinition", targetEntity=PortletDefinitionImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<IPortletDefinition> portletDefinitions = null;
    @Transient
    private String locale;
    @Transient
    private boolean isPortlet = false;

    @PostLoad
    @PostPersist
    @PostUpdate
    @PostRemove
    private void initClass() {
        if (!StringUtils.isBlank((String)this.clazz)) {
            try {
                Class<?> channelClazz = Class.forName(this.clazz);
                this.isPortlet = IPortletAdaptor.class.isAssignableFrom(channelClazz);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.isPortlet = false;
    }

    private ChannelDefinitionImpl() {
        this.internalId = -1;
        this.channelType = null;
        this.portletDefinitions = null;
        this.name = null;
        this.fname = null;
        this.title = null;
        this.clazz = null;
    }

    ChannelDefinitionImpl(IChannelType channelType, String fname, String clazz, String name, String title) {
        Validate.notNull((Object)channelType);
        Validate.notNull((Object)name);
        Validate.notNull((Object)fname);
        Validate.notNull((Object)title);
        Validate.notNull((Object)clazz);
        this.internalId = -1;
        this.channelType = channelType;
        this.portletDefinitions = new LinkedHashSet<IPortletDefinition>();
        this.portletDefinitions.add(new PortletDefinitionImpl(this));
        this.name = name;
        this.fname = fname;
        this.title = title;
        this.clazz = clazz;
        this.initClass();
    }

    @Override
    public ChannelLifecycleState getLifecycleState() {
        Date now = new Date();
        if (this.getExpirationDate() != null && this.getExpirationDate().before(now)) {
            return ChannelLifecycleState.EXPIRED;
        }
        if (this.getPublishDate() != null && this.getPublishDate().before(now)) {
            return ChannelLifecycleState.PUBLISHED;
        }
        if (this.getApprovalDate() != null && this.getApprovalDate().before(now)) {
            return ChannelLifecycleState.APPROVED;
        }
        return ChannelLifecycleState.CREATED;
    }

    @Override
    public void setFName(String fname) {
        Validate.notNull((Object)fname);
        this.fname = fname;
    }

    @Override
    public void setJavaClass(String javaClass) {
        Validate.notNull((Object)javaClass);
        this.clazz = javaClass;
        this.initClass();
    }

    @Override
    public void setName(String name) {
        Validate.notNull((Object)name);
        this.name = name;
    }

    @Override
    public void setTitle(String title) {
        Validate.notNull((Object)title);
        this.title = title;
    }

    @Override
    public void setType(IChannelType channelType) {
        Validate.notNull((Object)channelType);
        this.channelType = channelType;
    }

    @Override
    public void addParameter(IChannelParameter parameter) {
        this.addParameter(parameter);
    }

    @Override
    public void addParameter(String name, String value, String override) {
        this.addParameter(new ChannelParameterImpl(name, value, Boolean.valueOf(override)));
    }

    @Override
    public void addParameter(String name, String value, boolean override) {
        this.addParameter(new ChannelParameterImpl(name, value, override));
    }

    public void addParameter(ChannelParameterImpl newParameter) {
        String newName = newParameter.getName();
        Iterator<IChannelParameter> paramIter = this.parameters.iterator();
        while (paramIter.hasNext()) {
            IChannelParameter param = paramIter.next();
            if (!newName.equals(param.getName())) continue;
            paramIter.remove();
            break;
        }
        this.parameters.add(newParameter);
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate;
    }

    @Override
    public int getApproverId() {
        return this.approverId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescription(String locale) {
        ChannelLocalizationData localeData = this.localizations.get(locale);
        if (localeData != null && localeData.getDescription() != null) {
            return localeData.getDescription();
        }
        return this.description;
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public int getExpirerId() {
        return this.expirerId;
    }

    @Override
    public EntityIdentifier getEntityIdentifier() {
        return new EntityIdentifier(String.valueOf(this.getId()), ChannelDefinitionImpl.class);
    }

    @Override
    public String getFName() {
        return this.fname;
    }

    @Override
    public int getId() {
        return this.internalId;
    }

    @Override
    public String getJavaClass() {
        return this.clazz;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(String locale) {
        ChannelLocalizationData localeData = this.localizations.get(locale);
        if (localeData != null && localeData.getName() != null) {
            return localeData.getName();
        }
        return this.name;
    }

    @Override
    public IChannelParameter getParameter(String key) {
        for (IChannelParameter param : this.parameters) {
            if (!param.getName().equals(key)) continue;
            return param;
        }
        return null;
    }

    @Override
    public Set<IChannelParameter> getParameters() {
        return new LinkedHashSet<IChannelParameter>(this.parameters);
    }

    @Override
    public Map<String, IChannelParameter> getParametersAsUnmodifiableMap() {
        LinkedHashMap<String, IChannelParameter> parameterMap = new LinkedHashMap<String, IChannelParameter>();
        for (IChannelParameter param : this.parameters) {
            parameterMap.put(param.getName(), param);
        }
        return Collections.unmodifiableMap(parameterMap);
    }

    @Override
    public Date getPublishDate() {
        return this.publishDate;
    }

    @Override
    public int getPublisherId() {
        return this.publisherId;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getTitle(String locale) {
        ChannelLocalizationData localeData = this.localizations.get(locale);
        if (localeData != null && localeData.getTitle() != null) {
            return localeData.getTitle();
        }
        return this.title;
    }

    @Override
    @Deprecated
    public int getTypeId() {
        return this.channelType.getId();
    }

    @Override
    public IChannelType getType() {
        return this.channelType;
    }

    @Override
    public boolean hasAbout() {
        return this.hasAbout;
    }

    @Override
    public boolean hasHelp() {
        return this.hasHelp;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isPortlet() {
        return this.isPortlet;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void addLocalizedDescription(String locale, String chanDesc) {
        ChannelLocalizationData localeData = this.localizations.get(locale);
        if (localeData == null) {
            localeData = new ChannelLocalizationData();
        }
        localeData.setDescription(chanDesc);
        this.localizations.put(locale, localeData);
    }

    @Override
    public void addLocalizedName(String locale, String chanName) {
        ChannelLocalizationData localeData = this.localizations.get(locale);
        if (localeData == null) {
            localeData = new ChannelLocalizationData();
        }
        localeData.setName(chanName);
        this.localizations.put(locale, localeData);
    }

    @Override
    public void addLocalizedTitle(String locale, String chanTitle) {
        ChannelLocalizationData localeData = this.localizations.get(locale);
        if (localeData == null) {
            localeData = new ChannelLocalizationData();
        }
        localeData.setTitle(chanTitle);
        this.localizations.put(locale, localeData);
    }

    @Override
    public void removeParameter(IChannelParameter parameter) {
        this.parameters.remove(parameter.getName());
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    @Override
    public void replaceParameters(Set<IChannelParameter> parameters) {
        this.parameters.clear();
        for (IChannelParameter param : parameters) {
            this.parameters.add(new ChannelParameterImpl(param));
        }
    }

    @Override
    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    @Override
    public void setApproverId(int approvalId) {
        this.approverId = approvalId;
    }

    @Override
    public void setDescription(String descr) {
        this.description = descr;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public void setExpirerId(int expirerId) {
        this.expirerId = expirerId;
    }

    @Override
    public void setHasAbout(boolean hasAbout) {
        this.hasAbout = hasAbout;
    }

    @Override
    public void setHasHelp(boolean hasHelp) {
        this.hasHelp = hasHelp;
    }

    @Override
    public void setIsSecure(boolean isSecure) {
        this.secure = isSecure;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public void setParameters(Set<IChannelParameter> parameters) {
        for (IChannelParameter param : parameters) {
            this.parameters.add(new ChannelParameterImpl(param));
        }
    }

    @Override
    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    @Override
    public void setPublisherId(int publisherId) {
        this.publisherId = publisherId;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IChannelDefinition)) {
            return false;
        }
        IChannelDefinition rhs = (IChannelDefinition)object;
        return new EqualsBuilder().append((Object)this.fname, (Object)rhs.getFName()).append((Object)this.name, (Object)rhs.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(464270933, -1074792143).append((Object)this.fname).append((Object)this.name).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.internalId).append("publisherId", this.publisherId).append("expirationDate", (Object)this.expirationDate).append("approverId", this.approverId).append("expirerId", this.expirerId).append("locale", (Object)this.locale).append("secure", this.secure).append("hasHelp", this.hasHelp).append("localizations", this.localizations).append("hasAbout", this.hasAbout).append("editable", this.editable).append("title", (Object)this.title).append("description", (Object)this.description).append("name", (Object)this.name).append("approvalDate", (Object)this.approvalDate).append("parameters", this.parameters).append("clazz", (Object)this.clazz).append("type", (Object)this.channelType).append("isPortlet", this.isPortlet).append("fname", (Object)this.fname).append("timeout", this.timeout).append("publishDate", (Object)this.publishDate).toString();
    }
}

