/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.UserPreferences;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channels.UserPreferences.BaseState;
import org.jasig.portal.channels.UserPreferences.CUserPreferences;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

@Deprecated
class ManageProfilesState
extends BaseState {
    private static final Log log = LogFactory.getLog(ManageProfilesState.class);
    private static final boolean DEFAULT_ALLOW_USER_PROFILES = true;
    private static final boolean DEFAULT_ALLOW_SYSTEM_BROWSER_MAPPING = true;
    private static final boolean DEFAULT_ALLOW_NEW_PROFILE_BUTTON = true;
    protected Hashtable userProfileList;
    protected Hashtable systemProfileList;
    protected Hashtable userExpandStates = new Hashtable();
    protected Hashtable systemExpandStates = new Hashtable();
    protected ChannelRuntimeData runtimeData;
    IUserLayoutStore ulsdb;
    static final boolean ALLOW_USER_PROFILES = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.channels.UserPreferences.ManageProfilesState.allowUserProfiles", true);
    static final boolean ALLOW_SYSTEM_BROWSER_MAPPING = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.channels.UserPreferences.ManageProfilesState.allowSystemProfileBrowserMapping", true);
    static final boolean ALLOW_NEW_PROFILE_BUTTON = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.channels.UserPreferences.ManageProfilesState.allowNewProfileCreation", true);

    public ManageProfilesState(CUserPreferences context) {
        super(context);
    }

    protected Hashtable getUserProfileList() throws PortalException {
        if (this.userProfileList == null) {
            try {
                this.userProfileList = this.getUserLayoutStore().getUserProfileList(this.context.getUserPreferencesManager().getPerson());
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
        }
        return this.userProfileList;
    }

    protected Hashtable getSystemProfileList() throws PortalException {
        if (this.systemProfileList == null) {
            try {
                this.systemProfileList = this.getUserLayoutStore().getSystemProfileList();
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
        }
        return this.systemProfileList;
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
        String action = this.runtimeData.getParameter("action");
        if (action != null) {
            UserProfile p;
            String profileType;
            String profileId = this.runtimeData.getParameter("profileId");
            boolean systemProfile = false;
            if (profileId != null) {
                profileType = this.runtimeData.getParameter("profileType");
                if (profileType != null && profileType.equals("system")) {
                    systemProfile = true;
                }
                if (action.equals("edit")) {
                    CEditProfile epstate = new CEditProfile(this);
                    this.systemProfileList = null;
                    this.userProfileList = null;
                    epstate.setRuntimeData(rd);
                    this.internalState = epstate;
                } else if (action.equals("copy")) {
                    p = null;
                    p = systemProfile ? (UserProfile)this.systemProfileList.get(new Integer(profileId)) : (UserProfile)this.userProfileList.get(new Integer(profileId));
                    if (p != null) {
                        try {
                            p = this.getUserLayoutStore().addUserProfile(this.context.getUserPreferencesManager().getPerson(), p);
                        }
                        catch (Exception e) {
                            throw new PortalException(e);
                        }
                        this.userProfileList = null;
                    }
                } else if (action.equals("delete")) {
                    if (!systemProfile) {
                        try {
                            this.getUserLayoutStore().deleteUserProfile(this.context.getUserPreferencesManager().getPerson(), Integer.parseInt(profileId));
                        }
                        catch (Exception e) {
                            throw new PortalException(e);
                        }
                        this.userProfileList = null;
                    }
                } else if (action.equals("map")) {
                    try {
                        this.getUserLayoutStore().setUserBrowserMapping(this.context.getUserPreferencesManager().getPerson(), this.runtimeData.getBrowserInfo().getUserAgent(), Integer.parseInt(profileId));
                    }
                    catch (Exception e) {
                        throw new PortalException(e);
                    }
                } else if (action.equals("changeView")) {
                    String view = this.runtimeData.getParameter("view");
                    boolean expand = false;
                    if (view.equals("expanded")) {
                        expand = true;
                    }
                    if (systemProfile) {
                        this.systemExpandStates.put(profileId, new Boolean(expand));
                    } else {
                        this.userExpandStates.put(profileId, new Boolean(expand));
                    }
                }
            }
            if (action.equals("newProfile")) {
                UserProfile cp = this.context.getCurrentUserPreferences().getProfile();
                if (cp != null) {
                    p = new UserProfile(0, "newProfile", "new profile", "please edit the profile", cp.getLayoutId(), cp.getStructureStylesheetId(), cp.getThemeStylesheetId());
                    try {
                        p = this.getUserLayoutStore().addUserProfile(this.context.getUserPreferencesManager().getPerson(), p);
                    }
                    catch (Exception e) {
                        throw new PortalException(e);
                    }
                    this.userProfileList = null;
                }
            } else if (action.equals("condenseAll")) {
                profileType = this.runtimeData.getParameter("profileType");
                if (profileType != null && profileType.equals("system")) {
                    this.systemExpandStates.clear();
                } else {
                    this.userExpandStates.clear();
                }
            } else if (action.equals("expandAll")) {
                Boolean expState;
                profileType = this.runtimeData.getParameter("profileType");
                if (profileType != null && profileType.equals("system")) {
                    this.systemExpandStates.clear();
                    expState = new Boolean(true);
                    Enumeration upe = this.getSystemProfileList().elements();
                    while (upe.hasMoreElements()) {
                        UserProfile p2 = (UserProfile)upe.nextElement();
                        this.systemExpandStates.put(Integer.toString(p2.getProfileId()), expState);
                    }
                } else {
                    this.userExpandStates.clear();
                    expState = new Boolean(true);
                    Enumeration upe = this.getUserProfileList().elements();
                    while (upe.hasMoreElements()) {
                        UserProfile p3 = (UserProfile)upe.nextElement();
                        this.userExpandStates.put(Integer.toString(p3.getProfileId()), expState);
                    }
                }
            }
        }
        if (this.internalState != null) {
            this.internalState.setRuntimeData(rd);
        }
    }

    private IPerson getPerson() {
        return this.context.getUserPreferencesManager().getPerson();
    }

    private StylesheetSet getStylesheetSet() {
        return this.context.getStylesheetSet();
    }

    private IUserLayoutStore getUserLayoutStore() throws PortalException {
        if (this.ulsdb == null) {
            this.ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
        }
        if (this.ulsdb == null) {
            throw new ResourceMissingException("", "User Layout database", "Unable to obtain the list of user profiles, since the user preference database is currently down");
        }
        return this.ulsdb;
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        if (this.internalState != null) {
            this.internalState.renderXML(out);
        } else {
            Document doc = DocumentFactory.getNewDocument();
            Element edEl = doc.createElement("profiles");
            doc.appendChild(edEl);
            if (ALLOW_USER_PROFILES) {
                Element uEl = doc.createElement("user");
                Hashtable upList = this.getUserProfileList();
                Enumeration upe = this.getUserProfileList().elements();
                while (upe.hasMoreElements()) {
                    UserProfile p = (UserProfile)upe.nextElement();
                    Element pEl = doc.createElement("profile");
                    Boolean expState = (Boolean)this.userExpandStates.get(Integer.toString(p.getProfileId()));
                    if (expState != null && expState.booleanValue()) {
                        pEl.setAttribute("view", "expanded");
                    } else {
                        pEl.setAttribute("view", "condensed");
                    }
                    pEl.setAttribute("id", Integer.toString(p.getProfileId()));
                    pEl.setAttribute("name", p.getProfileName());
                    Element dEl = doc.createElement("description");
                    dEl.appendChild(doc.createTextNode(p.getProfileDescription()));
                    pEl.appendChild(dEl);
                    uEl.appendChild(pEl);
                }
                edEl.appendChild(uEl);
            }
            Element sEl = doc.createElement("system");
            Enumeration spe = this.getSystemProfileList().elements();
            while (spe.hasMoreElements()) {
                UserProfile p = (UserProfile)spe.nextElement();
                Element pEl = doc.createElement("profile");
                Boolean expState = (Boolean)this.systemExpandStates.get(Integer.toString(p.getProfileId()));
                if (expState != null && expState.booleanValue()) {
                    pEl.setAttribute("view", "expanded");
                } else {
                    pEl.setAttribute("view", "condensed");
                }
                pEl.setAttribute("id", Integer.toString(p.getProfileId()));
                pEl.setAttribute("name", p.getProfileName());
                Element dEl = doc.createElement("description");
                dEl.appendChild(doc.createTextNode(p.getProfileDescription()));
                pEl.appendChild(dEl);
                sEl.appendChild(pEl);
            }
            edEl.appendChild(sEl);
            StylesheetSet set = this.context.getStylesheetSet();
            if (set == null) {
                throw new GeneralRenderingException("Unable to determine the stylesheet list");
            }
            String xslURI = set.getStylesheetURI("profileList", this.runtimeData.getBrowserInfo());
            UserProfile currentProfile = this.context.getCurrentUserPreferences().getProfile();
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("allowNewProfile", new Boolean(ALLOW_NEW_PROFILE_BUTTON));
            params.put("allowSystemProfileMapping", new Boolean(ALLOW_SYSTEM_BROWSER_MAPPING));
            params.put("baseActionURL", this.runtimeData.getBaseActionURL());
            params.put("profileId", Integer.toString(currentProfile.getProfileId()));
            if (currentProfile.isSystemProfile()) {
                params.put("profileType", "system");
            } else {
                params.put("profileType", "user");
            }
            if (xslURI != null) {
                XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
                xslt.setXML(doc);
                xslt.setXSL(this.getClass().getResource(xslURI).toString());
                xslt.setTarget(out);
                xslt.setStylesheetParameters(params);
                xslt.transform();
            } else {
                throw new ResourceMissingException("", "stylesheet", "Unable to find stylesheet to display content for this media");
            }
        }
    }

    @Deprecated
    protected class CEditProfile
    extends BaseState {
        ChannelRuntimeData runtimeData;
        protected ManageProfilesState context;
        protected String currentMimeType;
        protected UserProfile profile;
        protected boolean modified = false;
        protected static final String mimeImagesPropsFile = "media/org/jasig/portal/channels/CUserPreferences/mimeImages.properties";
        protected Properties mimeImagesProps = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CEditProfile(ManageProfilesState context) {
            InputStream in = null;
            try {
                in = PortalSessionManager.getResourceAsStream(mimeImagesPropsFile);
                this.mimeImagesProps.load(in);
            }
            catch (Exception e) {
                log.error((Object)"UserPreferences:ManagerProfileState:CEditProfile::CEditProfile() : unable to load mime type images properties file located at media/org/jasig/portal/channels/CUserPreferences/mimeImages.properties");
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    log.error((Object)("ManageProfilesState:CEditProfile::unable to close InputStream " + ioe));
                }
            }
            this.context = context;
        }

        @Override
        public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
            this.runtimeData = rd;
            String action = this.runtimeData.getParameter("action");
            if (action != null) {
                if (action.equals("edit")) {
                    Integer profileId = null;
                    try {
                        profileId = new Integer(this.runtimeData.getParameter("profileId"));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    boolean systemProfile = false;
                    if (profileId == null) {
                        this.context.setState(null);
                    } else {
                        String profileType = this.runtimeData.getParameter("profileType");
                        if (profileType == null) {
                            this.context.setState(null);
                        } else {
                            if (profileType.equals("system")) {
                                systemProfile = true;
                            }
                            try {
                                this.profile = systemProfile ? this.context.getUserLayoutStore().getSystemProfileById(profileId) : this.context.getUserLayoutStore().getUserProfileById(this.context.getPerson(), profileId);
                            }
                            catch (Exception e) {
                                throw new PortalException(e);
                            }
                            if (this.profile == null) {
                                this.context.setState(null);
                            }
                        }
                    }
                } else if (action.equals("completeEdit")) {
                    if (this.runtimeData.getParameter("submitCancel") != null) {
                        this.context.setState(null);
                    } else if (this.runtimeData.getParameter("submitSave") != null) {
                        this.profile.setProfileName(this.runtimeData.getParameter("profileName"));
                        this.profile.setProfileDescription(this.runtimeData.getParameter("profileDescription"));
                        int newId = Integer.parseInt(this.runtimeData.getParameter("stylesheetID"));
                        if (newId != this.profile.getThemeStylesheetId()) {
                            this.profile.setThemeStylesheetId(newId);
                        }
                        try {
                            if (this.profile.isSystemProfile()) {
                                this.context.getUserLayoutStore().updateSystemProfile(this.profile);
                            } else {
                                this.context.getUserLayoutStore().updateUserProfile(this.context.getPerson(), this.profile);
                            }
                        }
                        catch (Exception e) {
                            throw new PortalException(e);
                        }
                        this.context.setState(null);
                    }
                }
            }
        }

        @Override
        public void renderXML(ContentHandler out) throws PortalException {
            StylesheetSet set;
            Hashtable tsList;
            Document doc = DocumentFactory.getNewDocument();
            Element profileEl = doc.createElement("profile");
            if (this.modified) {
                profileEl.setAttribute("modified", "true");
            } else {
                profileEl.setAttribute("modified", "false");
            }
            Element pnameEl = doc.createElement("name");
            pnameEl.appendChild(doc.createTextNode(this.profile.getProfileName()));
            profileEl.appendChild(pnameEl);
            Element pdescrEl = doc.createElement("description");
            pdescrEl.appendChild(doc.createTextNode(this.profile.getProfileDescription()));
            profileEl.appendChild(pdescrEl);
            Element themeEl = doc.createElement("themestylesheets");
            try {
                tsList = this.context.getUserLayoutStore().getThemeStylesheetList(this.profile.getStructureStylesheetId());
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            if (tsList == null) {
                throw new ResourceMissingException("", "List of theme stylesheets for the structure stylesheet \"" + this.profile.getStructureStylesheetId() + "\"", "Unable to obtain a list of theme stylesheets for the specified structure stylesheet");
            }
            if (tsList.get(new Integer(this.profile.getThemeStylesheetId())) == null && !tsList.isEmpty()) {
                Enumeration e = tsList.keys();
                this.profile.setThemeStylesheetId((Integer)e.nextElement());
            }
            Enumeration me = tsList.keys();
            while (me.hasMoreElements()) {
                Integer ssId = (Integer)me.nextElement();
                boolean current = ssId.intValue() == this.profile.getThemeStylesheetId();
                Element altEl = current ? doc.createElement("current") : doc.createElement("alternate");
                ThemeStylesheetDescription tsd = (ThemeStylesheetDescription)tsList.get(ssId);
                Element altnEl = doc.createElement("name");
                altnEl.appendChild(doc.createTextNode(tsd.getStylesheetName()));
                Element altidEl = doc.createElement("id");
                altidEl.appendChild(doc.createTextNode(Integer.toString(tsd.getId())));
                Element altdEl = doc.createElement("description");
                altdEl.appendChild(doc.createTextNode(tsd.getStylesheetWordDescription()));
                Element altmEl = doc.createElement("mimetype");
                altmEl.appendChild(doc.createTextNode(tsd.getMimeType()));
                String deviceIconURI = this.mimeImagesProps.getProperty(tsd.getDeviceType());
                if (deviceIconURI == null) {
                    deviceIconURI = this.mimeImagesProps.getProperty("unknown");
                }
                Element altdiuEl = doc.createElement("deviceiconuri");
                altdiuEl.appendChild(doc.createTextNode(deviceIconURI));
                Element altsuEl = doc.createElement("sampleuri");
                if (tsd.getSamplePictureURI() == null || tsd.getSamplePictureURI().equals("")) {
                    altsuEl.appendChild(doc.createTextNode(""));
                } else {
                    altsuEl.appendChild(doc.createTextNode(tsd.getSamplePictureURI()));
                }
                Element altsiuEl = doc.createElement("sampleiconuri");
                if (tsd.getSampleIconURI() == null || tsd.getSampleIconURI().equals("")) {
                    altsiuEl.appendChild(doc.createTextNode(""));
                } else {
                    altsiuEl.appendChild(doc.createTextNode(tsd.getSampleIconURI()));
                }
                altEl.appendChild(altnEl);
                altEl.appendChild(altidEl);
                altEl.appendChild(altdEl);
                altEl.appendChild(altmEl);
                altEl.appendChild(altdiuEl);
                altEl.appendChild(altsuEl);
                altEl.appendChild(altsiuEl);
                themeEl.appendChild(altEl);
            }
            profileEl.appendChild(themeEl);
            doc.appendChild(profileEl);
            if (log.isDebugEnabled()) {
                try {
                    StringWriter outString = new StringWriter();
                    OutputFormat format = new OutputFormat();
                    format.setOmitXMLDeclaration(true);
                    format.setIndenting(true);
                    XMLSerializer serializer = new XMLSerializer((Writer)outString, format);
                    serializer.serialize(doc);
                    log.debug((Object)outString.toString());
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                }
            }
            if ((set = this.context.getStylesheetSet()) == null) {
                throw new GeneralRenderingException("Unable to determine the stylesheet list");
            }
            String xslURI = set.getStylesheetURI("editProfile", this.runtimeData.getBrowserInfo());
            if (xslURI == null) {
                throw new ResourceMissingException("", "stylesheet", "Unable to find stylesheet to display content for this media");
            }
            XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
            xslt.setXML(doc);
            xslt.setXSL(this.getClass().getResource(xslURI).toString());
            xslt.setTarget(out);
            xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
            xslt.transform();
        }
    }
}

