/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.adminnav.provider;

import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.adminnav.ILabelResolver;
import org.jasig.portal.channels.adminnav.INavigationModel;
import org.jasig.portal.channels.adminnav.ResourceBundleResolver;
import org.jasig.portal.channels.adminnav.XMLLinksFileLoader;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

@Deprecated
public class ListModel
extends BaseChannel
implements INavigationModel {
    private static final String XSL_LOCATION = "navigation.xsl";
    private static LinkedList cLinks = new LinkedList();
    private Document mDoc = null;
    private static final String HEADER_PROPERTY = "admin.nav.header";
    private static final String CONFIG_FILE = "/properties/adminNav.xml";
    private static final String BUNDLE_BASE = "properties.adminNav";
    private static final ILabelResolver resolver = new ResourceBundleResolver("properties.adminNav");
    private static Log LOG = LogFactory.getLog(ListModel.class);
    private ChannelCacheKey cacheKey = new ChannelCacheKey();

    public ListModel() {
        XMLLinksFileLoader loader = new XMLLinksFileLoader(CONFIG_FILE, this, resolver);
    }

    @Override
    public boolean canAccess(IAuthorizationPrincipal ap) {
        for (Link link : cLinks) {
            try {
                if (!ap.canSubscribe(link.publishIdOfTargetChannel)) continue;
                return true;
            }
            catch (AuthorizationException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to determine if principal " + ap.getPrincipalString() + " can subscribe to channel with publish ID " + link.publishIdOfTargetChannel + ", and url " + link.url), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void addLink(String fname, String labelId, ILabelResolver resolver, Map parameters) {
        try {
            if (fname == null || fname.equals("")) {
                throw new Exception("'Functional Name' must be specified.");
            }
            if (labelId == null || labelId.equals("")) {
                labelId = "unspecified";
                throw new Exception("'Label' must be specified.");
            }
            IChannelRegistryStore crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
            IChannelDefinition chanDef = crs.getChannelDefinition(fname);
            int pubId = chanDef.getId();
            String url = UPFileSpec.buildUPFile(0, "userLayoutRootNode", null, null);
            url = url + "?" + "uP_fname" + "=" + fname;
            if (parameters != null) {
                for (String name : parameters.keySet()) {
                    String value = (String)parameters.get(name);
                    url = url + "&" + name + "=" + value;
                }
            }
            cLinks.add(new Link(labelId, resolver, url, pubId));
            this.cacheKey.setKeyValidity(new Locale("", ""));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to add link '" + labelId + "' to administration navigation list."), (Throwable)e);
        }
    }

    @Override
    public ChannelCacheKey generateKey() {
        return this.cacheKey;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        return validity == this.cacheKey.getKeyValidity();
    }

    @Override
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        super.setStaticData(sd);
        this.cacheKey.setKeyScope(0);
        this.cacheKey.setKey(this.getClass().getName() + sd.getChannelSubscribeId());
        this.cacheKey.setKeyValidity(new Locale("", ""));
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        super.setRuntimeData(rd);
        Locale[] locales = rd.getLocales();
        Locale currentLocale = null;
        currentLocale = locales == null ? Locale.US : (locales.length == 0 ? Locale.US : (locales[0] == null ? Locale.US : locales[0]));
        Locale lastLocale = (Locale)this.cacheKey.getKeyValidity();
        if (this.mDoc == null || !lastLocale.toString().equals(currentLocale.toString())) {
            this.generateXML(currentLocale);
            this.cacheKey.setKeyValidity(currentLocale);
        }
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        XSLT xslt = new XSLT(this);
        xslt.setXML(this.mDoc);
        xslt.setXSL(XSL_LOCATION);
        xslt.setTarget(out);
        xslt.transform();
    }

    private void generateXML(Locale locale) {
        Document doc = DocumentFactory.getNewDocument();
        Element root = doc.createElement("adminurls");
        doc.appendChild(root);
        Element heading = doc.createElement("heading");
        root.appendChild(heading);
        heading.appendChild(doc.createTextNode(this.resolveLabel(resolver, HEADER_PROPERTY, locale)));
        IAuthorizationPrincipal ap = this.staticData.getAuthorizationPrincipal();
        for (Link link : cLinks) {
            try {
                if (!ap.canSubscribe(link.publishIdOfTargetChannel)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User can render channel '" + link.publishIdOfTargetChannel + "' with url '" + link.url + "'"));
                }
                Element adminURLEl = doc.createElement("adminurl");
                adminURLEl.setAttribute("desc", this.resolveLabel(link.resolver, link.labelId, locale));
                adminURLEl.appendChild(doc.createTextNode(link.url));
                root.appendChild(adminURLEl);
            }
            catch (AuthorizationException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to add link for channel '" + link.publishIdOfTargetChannel + "' with url '" + link.url + "'"));
            }
        }
        this.mDoc = doc;
    }

    private String resolveLabel(ILabelResolver resolver, String labelId, Locale locale) {
        String label = null;
        try {
            label = resolver.getLabel(labelId, locale);
        }
        catch (MissingResourceException mre) {
            LOG.warn((Object)("Could not resolve labelId '" + labelId + "' for locale '" + locale + "' using resolver '" + resolver.getExternalForm() + "'"), (Throwable)mre);
        }
        if (label == null) {
            StringBuffer sb = new StringBuffer().append("???").append(resolver.getClass().getName());
            String resExtForm = resolver.getExternalForm();
            if (resExtForm != null && !resExtForm.equals("")) {
                sb.append('{').append(resExtForm).append('}');
            }
            sb.append("[").append(labelId).append("]???");
            label = sb.toString();
        }
        return label;
    }

    private static class Link {
        String labelId = null;
        String url = null;
        ILabelResolver resolver = null;
        int publishIdOfTargetChannel = -1;

        public Link(String labelId, ILabelResolver resolver, String url, int pubIdOfTargetChannel) {
            this.labelId = labelId;
            this.resolver = resolver;
            this.url = url;
            this.publishIdOfTargetChannel = pubIdOfTargetChannel;
        }
    }
}

