/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.error;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.ICharacterChannel;
import org.jasig.portal.IPrivileged;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.IResetableChannel;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.error.ErrorCode;
import org.jasig.portal.channels.error.ErrorDocument;
import org.jasig.portal.channels.error.error2xml.IThrowableToElement;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XMLSerializer;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.spring.locator.ThrowableToElementLocator;
import org.jasig.portal.utils.XML;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

@Deprecated
public final class CError
extends BaseChannel
implements IPrivilegedChannel,
ICacheable,
ICharacterChannel {
    private static final Log log = LogFactory.getLog(CError.class);
    private ErrorDocument errorDocument = new ErrorDocument();
    private IChannel targetChannel = null;
    private boolean placeHolder = false;
    private boolean showStackTrace = false;
    private String ssTitle = null;
    private PortalControlStructures portcs;
    private static final String sslLocation = "CError/CError.ssl";
    private static final MediaManager MEDIAMANAGER = MediaManager.getMediaManager(true);

    public CError() {
        try {
            IThrowableToElement throwableToElement = ThrowableToElementLocator.getThrowableToElement();
            this.errorDocument.setThrowableToElement(throwableToElement);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to retrieve mapping from throwables to Elements for CError rendering from the WebApplicationContext, the default mapping will be used.", (Throwable)e);
        }
    }

    public CError(ErrorCode errorCode, Throwable throwable, String channelSubscribeId, IChannel channelInstance) {
        this();
        if (log.isTraceEnabled()) {
            log.trace((Object)("CError(" + errorCode + ", throwable=[" + throwable + "], chanSubId=" + channelSubscribeId + ", channelInstance=[" + channelInstance + "]"));
        }
        this.errorDocument.setChannelSubscribeId(channelSubscribeId);
        this.errorDocument.setThrowable(throwable);
        this.targetChannel = channelInstance;
        this.errorDocument.setCode(errorCode);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Instantiated CError: " + this));
        }
    }

    public CError(ErrorCode errorCode, String message, String channelSubscribeId, IChannel channelInstance) {
        this();
        if (log.isTraceEnabled()) {
            log.trace((Object)("CError(" + errorCode + ", message=[" + message + "], chanSubId=" + channelSubscribeId + ", channelInstance=[" + channelInstance + "]"));
        }
        this.errorDocument.setChannelSubscribeId(channelSubscribeId);
        this.targetChannel = channelInstance;
        this.errorDocument.setCode(errorCode);
        this.errorDocument.setMessage(message);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Instantiated CError: " + this));
        }
    }

    public CError(ErrorCode errorCode, Throwable exception, String channelSubscribeId, IChannel channelInstance, String message) {
        this(errorCode, exception, channelSubscribeId, channelInstance);
        this.errorDocument.setMessage(message);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Instantiated CError: " + this));
        }
    }

    private void resetCError(ErrorCode errorCode, Throwable throwable, String channelSubscribeId, IChannel channelInstance, String message) {
        this.errorDocument.setCode(errorCode);
        this.errorDocument.setThrowable(throwable);
        this.errorDocument.setChannelSubscribeId(channelSubscribeId);
        this.targetChannel = channelInstance;
        this.errorDocument.setMessage(message);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Reset CError to: " + this));
        }
    }

    @Override
    public void setPortalControlStructures(PortalControlStructures pcs) {
        this.portcs = pcs;
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
        if (this.targetChannel != null) {
            if (this.targetChannel instanceof IPrivileged) {
                ((IPrivileged)((Object)this.targetChannel)).setPortalControlStructures(this.portcs);
            }
            this.targetChannel.receiveEvent(ev);
        }
        super.receiveEvent(ev);
    }

    @Override
    public void setStaticData(ChannelStaticData sd) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setStaticData(" + sd + ")"));
        }
        if (sd == null) {
            log.error((Object)"ChannelStaticData argument to setStaticData() illegally null.");
            return;
        }
        try {
            this.errorDocument.setMessage(sd.getParameter("CErrorMessage"));
            this.errorDocument.setChannelSubscribeId(sd.getParameter("CErrorChanId"));
            String value = sd.getParameter("CErrorErrorId");
            if (value != null) {
                this.errorDocument.setCode(ErrorCode.codeForInt(Integer.parseInt(value)));
            }
            this.placeHolder = true;
        }
        catch (Throwable t) {
            log.error((Object)"Error setting static data of CError instance", t);
        }
    }

    protected void renderChannel(IChannel channel, ContentHandler contentHandler, PrintWriter printWriter) throws Exception {
        if (contentHandler != null) {
            channel.renderXML(contentHandler);
        } else if (channel instanceof ICharacterChannel) {
            ((ICharacterChannel)channel).renderCharacters(printWriter);
        } else {
            IUserPreferencesManager userPreferencesManager = this.portcs.getUserPreferencesManager();
            ThemeStylesheetDescription tsd = userPreferencesManager.getThemeStylesheetDescription();
            String serializerName = tsd.getSerializerName();
            BaseMarkupSerializer serOut = MEDIAMANAGER.getSerializerByName(serializerName, printWriter);
            channel.renderXML(serOut);
        }
    }

    protected void doCommonErrorHandling(ContentHandler contentHandler, PrintWriter printWriter) {
        block26: {
            log.trace((Object)"Entering doCommonErrorHandling()");
            String channelSubscribeId = this.errorDocument.getChannelSubscribeId();
            if (channelSubscribeId != null) {
                String chFate = this.runtimeData.getParameter("action");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Channel fate is [" + chFate + "] for chanSubscribeId=" + channelSubscribeId));
                }
                if (chFate != null) {
                    if (chFate.equals("retry")) {
                        try {
                            if (this.targetChannel instanceof IResetableChannel) {
                                if (this.targetChannel instanceof IPrivileged) {
                                    ((IPrivileged)((Object)this.targetChannel)).setPortalControlStructures(this.portcs);
                                }
                                this.targetChannel.setRuntimeData(this.runtimeData);
                                ((IResetableChannel)this.targetChannel).prepareForRefresh();
                            }
                            ChannelRuntimeData crd = (ChannelRuntimeData)this.runtimeData.clone();
                            crd.clear();
                            if (this.targetChannel instanceof IPrivileged) {
                                ((IPrivileged)((Object)this.targetChannel)).setPortalControlStructures(this.portcs);
                            }
                            this.targetChannel.setRuntimeData(crd);
                            ChannelManager cm = this.portcs.getChannelManager();
                            cm.setChannelInstance(channelSubscribeId, this.targetChannel);
                            this.renderChannel(this.targetChannel, contentHandler, printWriter);
                            return;
                        }
                        catch (Exception e) {
                            this.resetCError(ErrorCode.SET_RUNTIME_DATA_EXCEPTION, e, channelSubscribeId, this.targetChannel, "Channel failed a refresh attempt.");
                        }
                    } else if (chFate.equals("restart")) {
                        ChannelManager cm = this.portcs.getChannelManager();
                        try {
                            if (this.targetChannel instanceof IResetableChannel) {
                                if (this.targetChannel instanceof IPrivileged) {
                                    ((IPrivileged)((Object)this.targetChannel)).setPortalControlStructures(this.portcs);
                                }
                                this.targetChannel.setRuntimeData(this.runtimeData);
                                ((IResetableChannel)this.targetChannel).prepareForReset();
                            }
                            ChannelRuntimeData crd = (ChannelRuntimeData)this.runtimeData.clone();
                            crd.clear();
                            this.targetChannel = cm.instantiateChannel(this.portcs.getHttpServletRequest(), this.portcs.getHttpServletResponse(), channelSubscribeId);
                            if (this.targetChannel == null) {
                                this.resetCError(ErrorCode.GENERAL_ERROR, null, channelSubscribeId, null, "Channel failed to reinstantiate!");
                                break block26;
                            }
                            try {
                                if (this.targetChannel instanceof IPrivileged) {
                                    ((IPrivileged)((Object)this.targetChannel)).setPortalControlStructures(this.portcs);
                                }
                                this.targetChannel.setRuntimeData(crd);
                                this.renderChannel(this.targetChannel, contentHandler, printWriter);
                                return;
                            }
                            catch (Exception e) {
                                this.resetCError(ErrorCode.SET_RUNTIME_DATA_EXCEPTION, e, channelSubscribeId, this.targetChannel, "Channel failed a reload attempt.");
                                cm.setChannelInstance(channelSubscribeId, this);
                                log.error((Object)"an error occurred during channel reinitialization.", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            this.resetCError(ErrorCode.GENERAL_ERROR, e, channelSubscribeId, null, "Channel failed to reinstantiate!");
                            log.error((Object)"an error occurred during channel reinstantiation.", (Throwable)e);
                        }
                    } else if (chFate.equals("toggle_stack_trace")) {
                        boolean bl = this.showStackTrace = !this.showStackTrace;
                    }
                }
            }
        }
        if (contentHandler != null) {
            this.localRenderXML(contentHandler);
        } else {
            BaseMarkupSerializer serOut = null;
            try {
                IUserPreferencesManager userPreferencesManager = this.portcs.getUserPreferencesManager();
                ThemeStylesheetDescription tsd = userPreferencesManager.getThemeStylesheetDescription();
                serOut = MEDIAMANAGER.getSerializerByName(tsd.getSerializerName(), printWriter);
            }
            catch (Exception e) {
                log.error((Object)"unable to obtain proper markup serializer : ", (Throwable)e);
            }
            if (serOut == null) {
                OutputFormat frmt = new OutputFormat("XML", "UTF-8", true);
                serOut = new XMLSerializer(printWriter, frmt);
            }
            this.localRenderXML(serOut);
        }
    }

    @Override
    public void renderXML(ContentHandler out) {
        this.doCommonErrorHandling(out, null);
    }

    private void localRenderXML(ContentHandler out) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Entering localRenderXML() for CError " + this));
        }
        String channelSubscribeId = this.errorDocument.getChannelSubscribeId();
        IUserPreferencesManager userPreferencesManager = this.portcs.getUserPreferencesManager();
        if (channelSubscribeId != null) {
            try {
                IUserLayoutManager userLayoutManager = userPreferencesManager.getUserLayoutManager();
                IUserLayoutNodeDescription channelNode = userLayoutManager.getNode(channelSubscribeId);
                this.errorDocument.setChannelName(channelNode.getName());
            }
            catch (Throwable t) {
                log.error((Object)("Error determining name of channel with subscribe id [" + channelSubscribeId + "]"), t);
            }
        }
        RefreshPolicy policy = channelSubscribeId != null ? this.computeRefreshPolicy() : new RefreshPolicy();
        this.ssTitle = "friendly";
        try {
            AuthorizationService authService = AuthorizationService.instance();
            IPerson person = userPreferencesManager.getPerson();
            EntityIdentifier ei = person.getEntityIdentifier();
            IAuthorizationPrincipal ap = authService.newPrincipal(ei.getKey(), ei.getType());
            if (ap.hasPermission("UP_ERROR_CHAN", "VIEW", "DETAILS")) {
                this.ssTitle = "detailed";
            }
        }
        catch (Throwable t) {
            log.error((Object)"Exception checking whether user authorized to view detailed CError view.  Defaulting to friendly view.", t);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("SSL title is " + this.ssTitle));
        }
        Document doc = this.errorDocument.getDocument();
        if (log.isWarnEnabled()) {
            try {
                log.warn((Object)("ErrorDocument XML is \n" + XML.serializeNode(doc)));
            }
            catch (Exception e) {
                log.error((Object)"Failed to write error document XML to logger.", (Throwable)e);
            }
        }
        try {
            XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
            xslt.setXML(doc);
            xslt.setXSL(sslLocation, this.ssTitle, this.runtimeData.getBrowserInfo());
            xslt.setTarget(out);
            xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
            xslt.setStylesheetParameter("showStackTrace", String.valueOf(this.showStackTrace));
            xslt.setStylesheetParameter("allowRefresh", Boolean.toString(policy.allowRefresh));
            xslt.setStylesheetParameter("allowReinstantiation", Boolean.toString(policy.allowReinstantiation));
            xslt.transform();
        }
        catch (Exception e) {
            log.error((Object)"Things are bad. Error channel threw Exception rendering its stylesheet.", (Throwable)e);
        }
    }

    @Override
    public ChannelCacheKey generateKey() {
        if (this.runtimeData != null && this.runtimeData.getParameter("action") != null) {
            return null;
        }
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuilder sbKey = new StringBuilder(1024);
        k.setKeyScope(1);
        sbKey.append(this.getClass().getName()).append(": errorDocument=").append(this.errorDocument);
        sbKey.append(" strace=").append(Boolean.toString(this.showStackTrace));
        sbKey.append(", mode=").append(this.ssTitle);
        sbKey.append(", locales=").append(LocaleManager.stringValueOf(this.runtimeData.getLocales()));
        k.setKey(sbKey.toString());
        return k;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        return true;
    }

    @Override
    public void renderCharacters(PrintWriter out) throws PortalException {
        this.doCommonErrorHandling(null, out);
    }

    private RefreshPolicy computeRefreshPolicy() {
        ErrorCode code;
        log.trace((Object)"entering computeRefreshPolicy()");
        RefreshPolicy policy = new RefreshPolicy();
        if (this.placeHolder) {
            policy.allowRefresh = false;
            policy.allowReinstantiation = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)("policy is [" + policy + "] because we are a placeholder."));
            }
        } else {
            Throwable errorThrowable = this.errorDocument.getThrowable();
            if (errorThrowable != null && errorThrowable instanceof PortalException) {
                PortalException portalException = (PortalException)errorThrowable;
                policy.allowRefresh = portalException.isRefreshable();
                policy.allowReinstantiation = portalException.isReinstantiable();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("PortalException [" + portalException + "] implied refresh policy [" + policy + "]"));
                }
            }
        }
        if (policy.allowRefresh && !(code = this.errorDocument.getCode()).isRefreshAllowed()) {
            policy.allowRefresh = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ErrorCode " + code + " vetoed allowing refresh."));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("computed refresh plolicy: " + policy));
        }
        return policy;
    }

    public ErrorDocument getErrorDocument() {
        return this.errorDocument;
    }

    public void setErrorDocument(ErrorDocument errorDocument) {
        this.errorDocument = errorDocument;
    }

    boolean isPlaceHolder() {
        return this.placeHolder;
    }

    void setPlaceHolder(boolean placeHolder) {
        this.placeHolder = placeHolder;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" errorDocument:[").append(this.errorDocument).append("]");
        sb.append(" placeholder:").append(this.placeHolder);
        sb.append(" showStackTrace:").append(this.showStackTrace);
        sb.append(" sslTitle:[").append(this.ssTitle).append("]");
        return sb.toString();
    }

    private class RefreshPolicy {
        boolean allowRefresh = true;
        boolean allowReinstantiation = true;

        private RefreshPolicy() {
        }

        public String toString() {
            return "refresh=" + this.allowRefresh + " reinstantiate=" + this.allowReinstantiation;
        }
    }
}

