/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.iccdemo;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICCRegistry;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.iccdemo.ViewerURL;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

@Deprecated
public class CURLSelector
extends BaseChannel {
    private static final Log log = LogFactory.getLog(CURLSelector.class);
    private static final String sslLocation = "urlselector.ssl";
    private static final String viewerFname = "/portal_iccdemo_viewer";
    private static final String historyFname = "/portal_iccdemo_history";
    private boolean usingRenderingGroups = false;

    @Override
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        super.setStaticData(sd);
        if (this.usingRenderingGroups) {
            this.registerListeners();
        }
    }

    private void registerListeners() {
        ICCRegistry r = this.staticData.getICCRegistry();
        String viewerId = this.getChannelId(viewerFname);
        if (viewerId != null) {
            r.addListenerChannel(viewerId);
        }
    }

    private void deRegisterListeners() {
        ICCRegistry r = this.staticData.getICCRegistry();
        String viewerId = this.getChannelId(viewerFname);
        if (viewerId != null) {
            r.removeListenerChannel(viewerId);
        }
    }

    private Document getUserXML() {
        Element warningEl;
        Document doc = DocumentFactory.getNewDocument();
        Element urlselectorEl = doc.createElement("urlselector");
        if (this.usingRenderingGroups) {
            urlselectorEl.setAttribute("grouped", "true");
        } else {
            urlselectorEl.setAttribute("grouped", "false");
        }
        String viewerId = this.getChannelId(viewerFname);
        if (viewerId == null) {
            Element warningEl2 = doc.createElement("warning");
            warningEl2.appendChild(doc.createTextNode("Unable to find viewer channel (fname=/portal_iccdemo_viewer). Please subscribe to a viewer channel"));
            urlselectorEl.appendChild(warningEl2);
        } else {
            Object bo = this.getBoundObject(viewerId);
            if (bo == null) {
                warningEl = doc.createElement("warning");
                warningEl.appendChild(doc.createTextNode("Viewer channel found, but no object was found bound in viewer's jndi context. Perhaps viewer should be moved to the same tab."));
                urlselectorEl.appendChild(warningEl);
            }
        }
        String historyId = this.getChannelId(historyFname);
        if (historyId == null) {
            warningEl = doc.createElement("warning");
            warningEl.appendChild(doc.createTextNode("Unable to find history channel (fname=/portal_iccdemo_history). Please subscribe to a history channel"));
            urlselectorEl.appendChild(warningEl);
        } else {
            Object bo = this.getBoundObject(historyId);
            if (bo == null) {
                Element warningEl3 = doc.createElement("warning");
                warningEl3.appendChild(doc.createTextNode("History channel found, but no object was found bound in history's jndi context. Perhaps history should be moved to the same tab."));
                urlselectorEl.appendChild(warningEl3);
            }
        }
        String[] urls = new String[]{"http://www.google.com", "http://www.cnn.com", "http://slashdot.org", "http://www.yahoo.com"};
        for (int i = 0; i < urls.length; ++i) {
            Element urlEl = doc.createElement("url");
            urlEl.appendChild(doc.createTextNode(urls[i]));
            urlselectorEl.appendChild(urlEl);
        }
        doc.appendChild(urlselectorEl);
        return doc;
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        String url;
        super.setRuntimeData(rd);
        String gr = rd.getParameter("groupedRendering");
        if (gr != null) {
            if (this.usingRenderingGroups) {
                this.usingRenderingGroups = false;
                this.deRegisterListeners();
            } else {
                this.usingRenderingGroups = true;
                this.registerListeners();
            }
        }
        if ((url = rd.getParameter("url")) != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.setViewerURL(url);
        }
    }

    private void setViewerURL(String url) {
        ViewerURL v;
        String viewerId = this.getChannelId(viewerFname);
        if (viewerId != null && (v = (ViewerURL)this.getBoundObject(viewerId)) != null) {
            v.setNewURL(url);
        }
    }

    private String getChannelId(String fname) {
        String id = null;
        Context globalIDContext = null;
        try {
            globalIDContext = (Context)this.staticData.getJNDIContext().lookup("/channel-ids");
        }
        catch (NotContextException nce) {
            log.error((Object)"CURLSelector.getUserXML(): Could not find subcontext /channel-ids in JNDI");
        }
        catch (NamingException e) {
            log.error((Object)"Lookup /channel-ids failed", (Throwable)e);
        }
        try {
            id = (String)globalIDContext.lookup(fname);
        }
        catch (NotContextException nce) {
            log.error((Object)("CURLSelector.getUserXML(): Could not find channel ID for fname=" + fname));
        }
        catch (NamingException e) {
            log.error((Object)("Lookup " + fname + " failed"), (Throwable)e);
        }
        return id;
    }

    private Object getBoundObject(String channelSubscribeId) {
        Object o = null;
        Context globalObjContext = null;
        try {
            globalObjContext = (Context)this.staticData.getJNDIContext().lookup("/channel-obj");
        }
        catch (NotContextException nce) {
            log.error((Object)"CURLSelector.getUserXML(): Could not find subcontext /channel-obj in JNDI");
        }
        catch (NamingException e) {
            log.error((Object)"Lookup /channel-obj failed", (Throwable)e);
        }
        try {
            o = globalObjContext.lookup(channelSubscribeId);
        }
        catch (NotContextException nce) {
            log.error((Object)("CURLSelector.getUserXML(): Could not find channel bound object for channel id=" + channelSubscribeId));
        }
        catch (NamingException e) {
            log.error((Object)("Lookup " + channelSubscribeId + " failed"), (Throwable)e);
        }
        return o;
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(this.getUserXML());
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        xslt.transform();
    }
}

