/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.io.Serializable;
import java.util.Map;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCache;

public class MapBackedEntityCache
implements IEntityCache {
    private final Map<Serializable, IBasicEntity> cache;
    private final Class<? extends IBasicEntity> entityType;

    public MapBackedEntityCache(Map<Serializable, IBasicEntity> cache, Class<? extends IBasicEntity> entityType) {
        this.cache = cache;
        this.entityType = entityType;
    }

    @Override
    public void add(IBasicEntity entity) throws CachingException {
        EntityIdentifier entityIdentifier = entity.getEntityIdentifier();
        Class<? extends IBasicEntity> addType = entityIdentifier.getType();
        if (!this.entityType.isAssignableFrom(addType)) {
            throw new CachingException("Problem adding " + entity + ": entity type '" + addType + "' is incompatible with cache type '" + this.entityType + "'.");
        }
        this.cache.put((Serializable)((Object)entityIdentifier.getKey()), entity);
    }

    @Override
    public void clearCache() throws CachingException {
        this.cache.clear();
    }

    @Override
    public IBasicEntity get(String key) {
        return this.cache.get(key);
    }

    @Override
    public Class<? extends IBasicEntity> getEntityType() {
        return this.entityType;
    }

    @Override
    public void remove(String entityKey) throws CachingException {
        this.cache.remove(entityKey);
    }

    @Override
    public void update(IBasicEntity entity) throws CachingException {
        this.add(entity);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    @Deprecated
    public void cleanupCache() throws CachingException {
    }
}

