/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.dao.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.type.NullableType;
import org.hibernate.usertype.UserType;

public class FunctionalNameType
implements UserType {
    public static final Pattern INVALID_CHARS_PATTERN = Pattern.compile("[^\\w-]");
    public static final Pattern VALID_CHARS_PATTERN = Pattern.compile("[\\w-]");
    public static final Pattern VALID_FNAME_PATTERN = Pattern.compile("^[\\w-]+$");
    private final NullableType type = Hibernate.STRING;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return new String((String)value);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x == null) {
            return 0;
        }
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String dbValue = (String)this.type.nullSafeGet(rs, names[0]);
        if (dbValue == null) {
            return null;
        }
        if (!VALID_FNAME_PATTERN.matcher(dbValue).matches()) {
            throw new IllegalArgumentException("Value from database '" + dbValue + "' does not validate against pattern: " + VALID_FNAME_PATTERN.pattern());
        }
        return dbValue;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null && !VALID_FNAME_PATTERN.matcher((String)value).matches()) {
            throw new IllegalArgumentException("Value being stored '" + value + "' does not validate against pattern: " + VALID_FNAME_PATTERN.pattern());
        }
        this.type.nullSafeSet(st, value, index);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class<?> returnedClass() {
        return String.class;
    }

    public int[] sqlTypes() {
        return new int[]{this.type.sqlType()};
    }
}

