/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;

public class EventType {
    private static final EventTypeCreator EVENT_TYPES = new EventTypeCreator();
    private long id;
    private String type;
    private String description;

    public static EventType getEventType(String type) {
        return EventType.getEventType(type, null);
    }

    public static EventType getEventType(String type, String description) {
        return (EventType)EVENT_TYPES.get(type, description);
    }

    private EventType() {
    }

    private EventType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    @PostLoad
    @PostPersist
    @PostUpdate
    @PostRemove
    private void init() {
        EventType eventType = this.intern();
        eventType.id = this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public EventType intern() {
        EventType eventType = EventType.getEventType(this.type, this.description);
        return eventType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EventType)) {
            return false;
        }
        EventType rhs = (EventType)object;
        return new EqualsBuilder().append(this.id, rhs.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(464270933, -1074792143).append(this.id).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.id).append("type", (Object)this.type).append("description", (Object)this.description).toString();
    }

    private static final class EventTypeCreator
    extends MapCachingDoubleCheckedCreator<String, EventType> {
        public EventTypeCreator() {
            super(new HashMap(), new ReentrantReadWriteLock());
        }

        @Override
        protected String getKey(Object ... args) {
            String type = (String)args[0];
            return type;
        }

        @Override
        protected EventType createInternal(String type, Object ... args) {
            String description = (String)args[1];
            return new EventType(type, description);
        }
    }
}

