/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.jasig.portal.events.EventHandler;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.handlers.AbstractLimitedSupportEventHandler;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class PortalEventMulticaster
extends AbstractLimitedSupportEventHandler {
    private final Collection<EventHandler> handlers = new LinkedHashSet<EventHandler>();
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public final void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor != null ? taskExecutor : new SyncTaskExecutor();
    }

    public final TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public final void setHandlers(Collection<EventHandler> listeners) {
        this.handlers.clear();
        this.handlers.addAll(listeners);
    }

    public final void addListener(EventHandler listener) {
        this.handlers.add(listener);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.handlers.size() == 0) {
            this.logger.warn((Object)"No PortalEventListeners are configured");
        }
    }

    @Override
    public void handleEvent(PortalEvent event) {
        for (EventHandler current : this.handlers) {
            if (!current.supports(event)) continue;
            this.handleEventInternal(event, current);
        }
    }

    protected void handleEventInternal(PortalEvent event, EventHandler handler) {
        this.taskExecutor.execute((Runnable)new PortalEventTask(event, handler));
    }

    protected static class PortalEventTask
    implements Runnable {
        private final PortalEvent event;
        private final EventHandler handler;

        public PortalEventTask(PortalEvent event, EventHandler handler) {
            this.event = event;
            this.handler = handler;
        }

        @Override
        public void run() {
            if (this.handler.supports(this.event)) {
                this.handler.handleEvent(this.event);
            }
        }
    }
}

