/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers;

import org.jasig.portal.events.EventHandler;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.support.ChannelAddedToLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelInstanciatedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelMovedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelPortalEvent;
import org.jasig.portal.events.support.ChannelRemovedFromLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelRenderedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelTargetedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelUpdatedInLayoutPortalEvent;
import org.jasig.portal.events.support.LayoutPortalEvent;
import org.jasig.portal.events.support.ModifiedChannelDefinitionPortalEvent;
import org.jasig.portal.events.support.PublishedChannelDefinitionPortalEvent;
import org.jasig.portal.events.support.RemovedChannelDefinitionPortalEvent;
import org.jasig.portal.events.support.UserAddedFolderToLayoutPortalEvent;
import org.jasig.portal.events.support.UserLoggedInPortalEvent;
import org.jasig.portal.events.support.UserLoggedOutPortalEvent;
import org.jasig.portal.events.support.UserMovedFolderInLayoutPortalEvent;
import org.jasig.portal.events.support.UserRemovedFolderFromLayoutPortalEvent;
import org.jasig.portal.events.support.UserSessionCreatedPortalEvent;
import org.jasig.portal.events.support.UserSessionDestroyedPortalEvent;
import org.jasig.portal.events.support.UserUpdatedFolderInLayoutPortalEvent;
import org.jasig.portal.services.stats.IStatsRecorder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class StatsRecorderEventHandlerAdapter
implements EventHandler,
InitializingBean {
    private IStatsRecorder recorder;

    @Override
    public void handleEvent(PortalEvent event) {
        Class<?> eventClass = ((Object)((Object)event)).getClass();
        if (eventClass.equals(ChannelAddedToLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelAddedToLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ChannelInstanciatedInLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelInstantiated(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ChannelMovedInLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelMovedInLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ChannelRemovedFromLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelRemovedFromLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ChannelRenderedInLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelRendered(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ChannelTargetedInLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelTargeted(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ChannelUpdatedInLayoutPortalEvent.class)) {
            ChannelLayoutPortalEvent portalEvent = (ChannelLayoutPortalEvent)event;
            this.recorder.recordChannelUpdatedInLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getChannelDescription());
        } else if (eventClass.equals(ModifiedChannelDefinitionPortalEvent.class)) {
            ChannelPortalEvent portalEvent = (ChannelPortalEvent)event;
            this.recorder.recordChannelDefinitionModified(portalEvent.getPerson(), portalEvent.getChannelDefinition());
        } else if (eventClass.equals(PublishedChannelDefinitionPortalEvent.class)) {
            ChannelPortalEvent portalEvent = (ChannelPortalEvent)event;
            this.recorder.recordChannelDefinitionPublished(portalEvent.getPerson(), portalEvent.getChannelDefinition());
        } else if (eventClass.equals(RemovedChannelDefinitionPortalEvent.class)) {
            ChannelPortalEvent portalEvent = (ChannelPortalEvent)event;
            this.recorder.recordChannelDefinitionRemoved(portalEvent.getPerson(), portalEvent.getChannelDefinition());
        } else if (eventClass.equals(UserLoggedOutPortalEvent.class)) {
            this.recorder.recordLogout(event.getPerson());
        } else if (eventClass.equals(UserAddedFolderToLayoutPortalEvent.class)) {
            LayoutPortalEvent portalEvent = (LayoutPortalEvent)event;
            this.recorder.recordFolderAddedToLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getFolder());
        } else if (eventClass.equals(UserLoggedInPortalEvent.class)) {
            this.recorder.recordLogin(event.getPerson());
        } else if (eventClass.equals(UserMovedFolderInLayoutPortalEvent.class)) {
            LayoutPortalEvent portalEvent = (LayoutPortalEvent)event;
            this.recorder.recordFolderMovedInLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getFolder());
        } else if (eventClass.equals(UserRemovedFolderFromLayoutPortalEvent.class)) {
            LayoutPortalEvent portalEvent = (LayoutPortalEvent)event;
            this.recorder.recordFolderRemovedFromLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getFolder());
        } else if (eventClass.equals(UserSessionCreatedPortalEvent.class)) {
            this.recorder.recordSessionCreated(event.getPerson());
        } else if (eventClass.equals(UserSessionDestroyedPortalEvent.class)) {
            this.recorder.recordSessionDestroyed(event.getPerson());
        } else if (eventClass.equals(UserUpdatedFolderInLayoutPortalEvent.class)) {
            LayoutPortalEvent portalEvent = (LayoutPortalEvent)event;
            this.recorder.recordFolderUpdatedInLayout(portalEvent.getPerson(), portalEvent.getProfile(), portalEvent.getFolder());
        }
    }

    @Override
    public boolean supports(PortalEvent event) {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.recorder, (String)"recorder cannot be null.");
    }

    public void setRecorder(IStatsRecorder recorder) {
        this.recorder = recorder;
    }
}

