/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers.db;

import java.util.HashSet;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.ejb.HibernateEntityManager;
import org.jasig.portal.events.BatchingEventHandler;
import org.jasig.portal.events.EventType;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.handlers.AbstractLimitedSupportEventHandler;
import org.jasig.portal.events.handlers.db.IPortalEventStore;
import org.jasig.portal.events.handlers.db.StatsSession;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortalEventStore
extends AbstractLimitedSupportEventHandler
implements BatchingEventHandler,
IPortalEventStore {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final String STATS_SESSION_ID_PERSON_ATTR = JpaPortalEventStore.class.getName() + ".StatsSessionId";
    private EntityManager entityManager;
    private boolean logSessionGroups = true;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext(unitName="uPortalStatsPersistence")
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public boolean isLogSessionGroups() {
        return this.logSessionGroups;
    }

    public void setLogSessionGroups(boolean logSessionGroups) {
        this.logSessionGroups = logSessionGroups;
    }

    @Override
    public void handleEvent(PortalEvent event) {
        this.storePortalEvents(event);
    }

    @Override
    public void handleEvents(PortalEvent ... events) {
        this.storePortalEvents(events);
    }

    @Override
    public void storePortalEvents(PortalEvent ... portalEvents) {
        for (PortalEvent portalEvent : portalEvents) {
            EventType foundEventType;
            EventType eventType;
            if (portalEvent.getStatsSession() == null) {
                IPerson person = portalEvent.getPerson();
                StatsSession statsSession = this.getStatsSession(person);
                portalEvent.setStatsSession(statsSession);
            }
            if (!((eventType = portalEvent.getEventType().intern()).getId() != 0L && this.entityManager.contains((Object)eventType) || (foundEventType = this.findExistingEventType(eventType)) != null)) {
                this.entityManager.persist((Object)eventType);
            }
            try {
                this.entityManager.persist((Object)portalEvent);
            }
            catch (IllegalArgumentException iae) {
                this.logger.warn((Object)(((Object)((Object)portalEvent)).getClass().getName() + " is not mapped as a persistent entity and will not be stored. event=[" + (Object)((Object)portalEvent) + "], message=" + iae.getMessage()));
            }
        }
    }

    protected StatsSession getStatsSession(IPerson person) {
        Long statsSessionId = (Long)person.getAttribute(STATS_SESSION_ID_PERSON_ATTR);
        StatsSession statsSession = null;
        if (statsSessionId != null && statsSessionId > 0L) {
            statsSession = (StatsSession)this.entityManager.find(StatsSession.class, (Object)statsSessionId);
        }
        if (statsSession == null) {
            statsSession = new StatsSession();
            String userName = (String)person.getAttribute("username");
            statsSession.setUserName(userName);
            if (this.logSessionGroups) {
                try {
                    this.updateStatsSessionGroups(statsSession, person);
                }
                catch (GroupsException ge) {
                    this.logger.warn((Object)("Exception while loading groups for person='" + person + "' and session='" + statsSession + "'"), (Throwable)ge);
                }
            }
            this.entityManager.persist((Object)statsSession);
            person.setAttribute(STATS_SESSION_ID_PERSON_ATTR, statsSession.getSessionId());
        }
        return statsSession;
    }

    protected void updateStatsSessionGroups(StatsSession session, IPerson person) throws GroupsException {
        IGroupMember member = GroupService.getGroupMember(person.getEntityIdentifier());
        HashSet<String> groupKeys = new HashSet<String>();
        Iterator groupItr = member.getAllContainingGroups();
        while (groupItr.hasNext()) {
            IGroupMember group = (IGroupMember)groupItr.next();
            groupKeys.add(group.getKey());
        }
        session.setGroups(groupKeys);
    }

    protected EventType findExistingEventType(EventType eventType) {
        if (eventType.getId() != 0L) {
            EventType foundEventType = (EventType)this.entityManager.find(EventType.class, (Object)eventType.getId());
            if (foundEventType != null) {
                return foundEventType;
            }
            eventType.setId(0L);
        }
        HibernateEntityManager hibernateEntityManager = (HibernateEntityManager)this.entityManager;
        Session session = hibernateEntityManager.getSession();
        Criteria eventTypeCriteria = session.createCriteria(EventType.class);
        eventTypeCriteria.add((Criterion)Restrictions.naturalId().set("type", (Object)eventType.getType()));
        eventTypeCriteria.setCacheable(true);
        eventTypeCriteria.setMaxResults(1);
        EventType foundEventType = (EventType)eventTypeCriteria.uniqueResult();
        return foundEventType;
    }
}

