/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.security.IPerson;

public class ReferencePersonNameFinder
implements IEntityNameFinder {
    private static final Log log = LogFactory.getLog(ReferencePersonNameFinder.class);
    private static IEntityNameFinder singleton;
    private static String USER_TABLE;
    private static String USER_ID_COLUMN;
    private static String USER_NAME_COLUMN;
    private static String DIRECTORY_TABLE;
    private static String DIRECTORY_FIRST_NAME_COLUMN;
    private static String DIRECTORY_LAST_NAME_COLUMN;
    private static String DIRECTORY_USER_NAME_COLUMN;
    private Map names;

    private ReferencePersonNameFinder() throws SQLException {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDirectoryNames() throws SQLException {
        Connection conn = null;
        Statement stmnt = null;
        HashMap<String, String> directoryNames = new HashMap<String, String>();
        try {
            conn = RDBMServices.getConnection();
            try {
                stmnt = conn.createStatement();
                String sql = this.getSelectDirectoryNamesSql();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReferencePersonNameFinder.getDirectoryNames(): " + sql));
                }
                ResultSet rs = stmnt.executeQuery(sql);
                while (rs.next()) {
                    String key = "" + rs.getString(DIRECTORY_USER_NAME_COLUMN);
                    String fname = rs.getString(DIRECTORY_FIRST_NAME_COLUMN);
                    String lname = rs.getString(DIRECTORY_LAST_NAME_COLUMN);
                    if (fname == null) {
                        fname = "";
                    }
                    if (lname == null) {
                        lname = "";
                    }
                    String fullname = fname + " " + lname;
                    directoryNames.put(key, fullname);
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"Error getting names by userid from UP_PERSON_DIR", (Throwable)sqle);
            throw sqle;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return directoryNames;
    }

    @Override
    public String getName(String key) throws Exception {
        return (String)this.primGetNames().get(key);
    }

    @Override
    public Map getNames(String[] keys) throws Exception {
        HashMap<String, String> selectedNames = new HashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            String name = (String)this.primGetNames().get(keys[i]);
            selectedNames.put(keys[i], name);
        }
        return selectedNames;
    }

    private String getSelectDirectoryNamesSql() {
        return "SELECT " + DIRECTORY_USER_NAME_COLUMN + ", " + DIRECTORY_FIRST_NAME_COLUMN + ", " + DIRECTORY_LAST_NAME_COLUMN + " FROM " + DIRECTORY_TABLE;
    }

    private String getSelectUserNamesSql() {
        return "SELECT " + USER_NAME_COLUMN + " FROM " + USER_TABLE;
    }

    @Override
    public Class getType() {
        return IPerson.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getUserNames() throws SQLException {
        Connection conn = null;
        Statement stmnt = null;
        HashMap<String, String> userNames = new HashMap<String, String>();
        try {
            conn = RDBMServices.getConnection();
            try {
                stmnt = conn.createStatement();
                String sql = this.getSelectUserNamesSql();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReferencePersonNameFinder.getUserNames(): " + sql));
                }
                ResultSet rs = stmnt.executeQuery(sql);
                while (rs.next()) {
                    String key = rs.getString(USER_NAME_COLUMN);
                    userNames.put(key, key);
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"Error getting names by user ID from UP_USER", (Throwable)sqle);
            throw sqle;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return userNames;
    }

    private void initialize() throws SQLException {
        Map userNames = this.getUserNames();
        Map directoryNames = this.getDirectoryNames();
        for (Map.Entry entry : userNames.entrySet()) {
            String directoryName = (String)directoryNames.get((String)entry.getValue());
            if (directoryName == null) continue;
            entry.setValue(directoryName);
        }
        this.names = userNames;
    }

    private Map primGetNames() {
        return this.names;
    }

    public static synchronized IEntityNameFinder singleton() throws SQLException {
        if (singleton == null) {
            singleton = new ReferencePersonNameFinder();
        }
        return singleton;
    }

    public String toString() {
        return "IEntityNameFinder for " + this.getType().getName();
    }

    static {
        USER_TABLE = "UP_USER";
        USER_ID_COLUMN = "USER_ID";
        USER_NAME_COLUMN = "USER_NAME";
        DIRECTORY_TABLE = "UP_PERSON_DIR";
        DIRECTORY_FIRST_NAME_COLUMN = "FIRST_NAME";
        DIRECTORY_LAST_NAME_COLUMN = "LAST_NAME";
        DIRECTORY_USER_NAME_COLUMN = "USER_NAME";
    }
}

