/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.layout.StructureParameter;

public final class LayoutStructure {
    private static final Log LOG = LogFactory.getLog(LayoutStructure.class);
    private final int structId;
    private final int nextId;
    private final int childId;
    private final int chanId;
    private String name;
    private String type;
    private boolean hidden;
    private boolean unremovable;
    private boolean immutable;
    private final List parameters = new ArrayList();
    private String locale;

    public LayoutStructure(int structId, int nextId, int childId, int chanId, String hidden, String unremovable, String immutable) {
        this.nextId = nextId;
        this.childId = childId;
        this.chanId = chanId;
        this.structId = structId;
        this.hidden = RDBMServices.dbFlag(hidden);
        this.immutable = RDBMServices.dbFlag(immutable);
        this.unremovable = RDBMServices.dbFlag(unremovable);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Instantiated new " + this));
        }
    }

    public LayoutStructure(int structId, int nextId, int childId, int chanId, String hidden, String unremovable, String immutable, String locale) {
        this.nextId = nextId;
        this.childId = childId;
        this.chanId = chanId;
        this.structId = structId;
        this.hidden = RDBMServices.dbFlag(hidden);
        this.immutable = RDBMServices.dbFlag(immutable);
        this.unremovable = RDBMServices.dbFlag(unremovable);
        this.locale = locale;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Instantiated new " + this));
        }
    }

    public void addFolderData(String folderName, String folderType) {
        this.name = folderName;
        this.type = folderType;
    }

    public boolean isChannel() {
        return this.chanId != 0;
    }

    public void addParameter(String paramName, String paramValue) {
        this.parameters.add(new StructureParameter(paramName, paramValue));
    }

    public int getNextId() {
        return this.nextId;
    }

    public int getChildId() {
        return this.childId;
    }

    public int getChanId() {
        return this.chanId;
    }

    public int getStructId() {
        return this.structId;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public boolean isUnremovable() {
        return this.unremovable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LayoutStructure:");
        sb.append(" structId = ").append(this.structId);
        sb.append(" nextId = ").append(this.nextId);
        sb.append(" childId = ").append(this.childId);
        sb.append(" chanId = ").append(this.chanId);
        sb.append(" name = [").append(this.name).append("]");
        sb.append(" hidden = ").append(this.hidden);
        sb.append(" unremovable = ").append(this.unremovable);
        sb.append(" immutable = ").append(this.immutable);
        sb.append(" parameters = [").append(this.parameters);
        sb.append(" locale = [").append(this.locale).append("]");
        return sb.toString();
    }
}

