/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.PositionManager;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HandlerUtils {
    public static final String RCS_ID = "@(#) $Header$";

    public static Element getPLFNode(Element compViewNode, IPerson person, boolean create, boolean includeChildNodes) throws PortalException {
        String ID;
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        Element plfNode = plf.getElementById(ID = compViewNode.getAttribute("ID"));
        if (plfNode != null) {
            return plfNode;
        }
        if (compViewNode.getNodeName().equals("layout")) {
            return plf.getDocumentElement();
        }
        if (create) {
            return HandlerUtils.createPlfNodeAndPath(compViewNode, includeChildNodes, person);
        }
        return null;
    }

    public static Element createPlfNodeAndPath(Element compViewNode, boolean includeChildNodes, IPerson person) throws PortalException {
        Element compViewParent = (Element)compViewNode.getParentNode();
        Element plfParent = HandlerUtils.getPLFNode(compViewParent, person, true, false);
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        if (compViewNode.getAttribute("ID").startsWith("u")) {
            return HandlerUtils.createILFCopy(compViewNode, compViewParent, includeChildNodes, plf, plfParent, person);
        }
        return HandlerUtils.createOrMovePLFOwnedNode(compViewNode, compViewParent, true, includeChildNodes, plf, plfParent, person);
    }

    private static Element createILFCopy(Element compViewNode, Element compViewParent, boolean includeChildNodes, Document plf, Element plfParent, IPerson person) throws PortalException {
        Element plfNode = (Element)plf.importNode(compViewNode, includeChildNodes);
        plfNode.removeAttributeNS("http://www.uportal.org/layout/dlm", "addChildAllowed");
        plfNode.removeAttributeNS("http://www.uportal.org/layout/dlm", "deleteAllowed");
        plfNode.removeAttributeNS("http://www.uportal.org/layout/dlm", "editAllowed");
        plfNode.removeAttributeNS("http://www.uportal.org/layout/dlm", "moveAllowed");
        String ID = plfNode.getAttribute("ID");
        plfNode.setIdAttribute("ID", true);
        IUserLayoutStore uls = null;
        uls = UserLayoutStoreFactory.getUserLayoutStoreImpl();
        if (plfNode.getAttribute("dlm:plfID").equals("")) {
            String plfID = null;
            try {
                plfID = !plfNode.getAttribute("chanID").equals("") ? uls.generateNewChannelSubscribeId(person) : uls.generateNewFolderId(person);
            }
            catch (Exception e) {
                throw new PortalException("Exception encountered while generating new user layout node Id for userId=" + person.getID(), (Throwable)e);
            }
            plfNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:plfID", plfID);
            plfNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:origin", ID);
        }
        plfParent.appendChild(plfNode);
        PositionManager.updatePositionSet(compViewParent, plfParent, person);
        return plfNode;
    }

    static Element createOrMovePLFOwnedNode(Element compViewNode, Element compViewParent, boolean createIfNotFound, boolean createChildNodes, Document plf, Element plfParent, IPerson person) throws PortalException {
        String plfNodeID;
        Element plfNode;
        Element nextOwnedSibling = null;
        boolean insertionPointFound = false;
        for (Element child = (Element)compViewParent.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (insertionPointFound && nextOwnedSibling == null && !child.getAttribute("ID").startsWith("u")) {
                nextOwnedSibling = child;
            }
            if (child != compViewNode) continue;
            insertionPointFound = true;
        }
        if (!insertionPointFound) {
            return null;
        }
        String nextSibID = null;
        Element nextPlfSib = null;
        if (nextOwnedSibling != null) {
            nextSibID = nextOwnedSibling.getAttribute("ID");
            nextPlfSib = plf.getElementById(nextSibID);
        }
        if ((plfNode = plf.getElementById(plfNodeID = compViewNode.getAttribute("ID"))) == null) {
            if (createIfNotFound) {
                plfNode = (Element)plf.importNode(compViewNode, createChildNodes);
                plfNode.setIdAttribute("ID", true);
            } else {
                return null;
            }
        }
        if (nextPlfSib == null) {
            plfParent.appendChild(plfNode);
        } else {
            plfParent.insertBefore(plfNode, nextPlfSib);
        }
        PositionManager.updatePositionSet(compViewParent, plfParent, person);
        return plfNode;
    }
}

