/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.utils.DocumentFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ILFBuilder {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(ILFBuilder.class);

    public static Document constructILF(Document PLF, Vector sequence, IPerson person) throws ParserConfigurationException, AuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Constructing ILF for IPerson='" + person + "'"));
        }
        Document result = DocumentFactory.getNewDocument();
        Element plfLayout = PLF.getDocumentElement();
        Element ilfLayout = (Element)result.importNode(plfLayout, false);
        result.appendChild(ilfLayout);
        Element plfRoot = (Element)plfLayout.getFirstChild();
        Element ilfRoot = (Element)result.importNode(plfRoot, false);
        ilfLayout.appendChild(ilfRoot);
        if (ilfRoot.getAttribute("ID") != null) {
            ilfRoot.setIdAttribute("ID", true);
        }
        EntityIdentifier ei = person.getEntityIdentifier();
        AuthorizationService authS = AuthorizationService.instance();
        IAuthorizationPrincipal ap = authS.newPrincipal(ei.getKey(), ei.getType());
        Enumeration fragments = sequence.elements();
        while (fragments.hasMoreElements()) {
            ILFBuilder.mergeFragment((Document)fragments.nextElement(), result, ap);
        }
        return result;
    }

    public static void mergeFragment(Document fragment, Document composite, IAuthorizationPrincipal ap) throws AuthorizationException {
        Element fragmentLayout = fragment.getDocumentElement();
        Element fragmentRoot = (Element)fragmentLayout.getFirstChild();
        Element compositeLayout = composite.getDocumentElement();
        Element compositeRoot = (Element)compositeLayout.getFirstChild();
        ILFBuilder.mergeChildren(fragmentRoot, compositeRoot, ap, new HashSet());
    }

    private static void mergeChildren(Element source, Element dest, IAuthorizationPrincipal ap, Set visitedNodes) throws AuthorizationException {
        if (!visitedNodes.add(source)) {
            String msg = "mergeChildren has encountered a loop in the source DOM. currentNode='" + source + "', currentDepth='" + visitedNodes.size() + "', visitedNodes='" + visitedNodes + "'";
            IllegalStateException ise = new IllegalStateException(msg);
            LOG.error((Object)msg, (Throwable)ise);
            ILFBuilder.printNodeToDebug(source, "Source");
            ILFBuilder.printNodeToDebug(dest, "Dest");
            throw ise;
        }
        Document destDoc = dest.getOwnerDocument();
        for (Node item = source.getFirstChild(); item != null; item = item.getNextSibling()) {
            if (!(item instanceof Element)) continue;
            Element child = (Element)item;
            Element newChild = null;
            if (null == child || !ILFBuilder.mergeAllowed(child, ap)) continue;
            newChild = (Element)destDoc.importNode(child, false);
            dest.appendChild(newChild);
            String id = newChild.getAttribute("ID");
            if (id != null && !id.equals("")) {
                newChild.setIdAttribute("ID", true);
            }
            ILFBuilder.mergeChildren(child, newChild, ap, visitedNodes);
        }
        visitedNodes.remove(source);
    }

    private static boolean mergeAllowed(Element child, IAuthorizationPrincipal ap) throws AuthorizationException {
        if (!child.getTagName().equals("channel")) {
            return true;
        }
        String channelPublishId = child.getAttribute("chanID");
        return ap.canRender(Integer.parseInt(channelPublishId));
    }

    private static void printNodeToDebug(Node n, String name) throws TransformerFactoryConfigurationError {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            DOMSource xmlSource = new DOMSource(n);
            StreamResult transResult = new StreamResult(writer);
            trans.transform(xmlSource, transResult);
            String xmlStr = writer.toString();
            LOG.debug((Object)(name + " DOM Tree:\n\n" + xmlStr));
        }
        catch (Exception e) {
            LOG.error((Object)("Error printing out " + name + " DOM Tree"), (Throwable)e);
            String xmlStr = writer.toString();
            LOG.debug((Object)("Partial " + name + " DOM Tree:\n\n" + xmlStr));
        }
    }
}

