/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.dlm.ILayoutProcessingAction;
import org.jasig.portal.layout.dlm.ParameterEditManager;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LPAAddParameter
implements ILayoutProcessingAction {
    private String nodeId = null;
    private String name = null;
    private IPerson person = null;
    private Element ilfNode = null;
    private String value = null;

    LPAAddParameter(String nodeId, String name, String value, IPerson p, Element ilfNode) {
        this.nodeId = nodeId;
        this.name = name;
        this.person = p;
        this.ilfNode = ilfNode;
        this.value = value;
    }

    @Override
    public void perform() throws PortalException {
        if (this.nodeId.startsWith("u")) {
            ParameterEditManager.addParmEditDirective(this.ilfNode, this.nodeId, this.name, this.value, this.person);
        } else {
            Document plf = RDBMDistributedLayoutStore.getPLF(this.person);
            Element plfNode = plf.getElementById(this.nodeId);
            LPAAddParameter.addParameterChild(plfNode, this.name, this.value);
        }
        LPAAddParameter.addParameterChild(this.ilfNode, this.name, this.value);
    }

    static void addParameterChild(Element node, String name, String value) {
        if (node != null) {
            Document doc = node.getOwnerDocument();
            Element parm = doc.createElement("parameter");
            parm.setAttribute("name", name);
            parm.setAttribute("value", value);
            parm.setAttribute("override", "yes");
            node.appendChild(parm);
        }
    }
}

