/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.dlm.ILayoutProcessingAction;
import org.jasig.portal.layout.dlm.ParameterEditManager;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LPARemoveParameter
implements ILayoutProcessingAction {
    private String nodeId = null;
    private String name = null;
    private IPerson person = null;
    private Element ilfNode = null;

    LPARemoveParameter(String nodeId, String name, IPerson p, Element ilfNode) {
        this.nodeId = nodeId;
        this.name = name;
        this.person = p;
        this.ilfNode = ilfNode;
    }

    @Override
    public void perform() throws PortalException {
        if (this.nodeId.startsWith("u")) {
            ParameterEditManager.removeParmEditDirective(this.nodeId, this.name, this.person);
        } else {
            Document plf = RDBMDistributedLayoutStore.getPLF(this.person);
            Element plfNode = plf.getElementById(this.nodeId);
            LPARemoveParameter.removeParameterChild(plfNode, this.name);
        }
        LPARemoveParameter.removeParameterChild(this.ilfNode, this.name);
    }

    static void removeParameterChild(Element node, String name) {
        if (node != null) {
            for (Element parm = (Element)node.getFirstChild(); parm != null; parm = (Element)parm.getNextSibling()) {
                if (!parm.getAttribute("name").equals(name)) continue;
                node.removeChild(parm);
                return;
            }
        }
    }
}

