/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.UserProfile;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.support.UserLoggedOutPortalEvent;
import org.jasig.portal.events.support.UserSessionDestroyedPortalEvent;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.ILayoutCachingService;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.Tuple;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.w3c.dom.Document;

public class LayoutCachingService
implements ApplicationListener,
ILayoutCachingService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<Serializable, Document> layoutCache;

    public Map<Serializable, Document> getLayoutCache() {
        return this.layoutCache;
    }

    public void setLayoutCache(Map<Serializable, Document> layoutCache) {
        this.layoutCache = layoutCache;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof UserLoggedOutPortalEvent || event instanceof UserSessionDestroyedPortalEvent) {
            Hashtable<Integer, UserProfile> userProfiles;
            PortalEvent portalEvent = (PortalEvent)event;
            IPerson person = portalEvent.getPerson();
            if (person.isGuest()) {
                return;
            }
            UserProfile currentUserProfile = (UserProfile)person.getAttribute("UserProfile");
            if (currentUserProfile != null) {
                this.removeCachedLayout(person, currentUserProfile);
                return;
            }
            IUserLayoutStore userLayoutStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
            try {
                userProfiles = userLayoutStore.getUserProfileList(person);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to load all UserProfiles for '" + person.getUserName() + "'. The user's layouts will not be explicitly removed from the layout cache."), (Throwable)e);
                return;
            }
            for (UserProfile userProfile : userProfiles.values()) {
                this.removeCachedLayout(person, userProfile);
            }
        }
    }

    @Override
    public void cacheLayout(IPerson owner, UserProfile profile, Document layout) {
        Serializable cacheKey = this.getCacheKey(owner, profile);
        this.layoutCache.put(cacheKey, layout);
    }

    @Override
    public Document getCachedLayout(IPerson owner, UserProfile profile) {
        Serializable cacheKey = this.getCacheKey(owner, profile);
        return this.layoutCache.get(cacheKey);
    }

    @Override
    public void removeCachedLayout(IPerson owner, UserProfile profile) {
        Serializable cacheKey = this.getCacheKey(owner, profile);
        this.layoutCache.remove(cacheKey);
    }

    protected Serializable getCacheKey(IPerson owner, UserProfile profile) {
        return new Tuple<String, Integer>(owner.getUserName(), profile.getLayoutId());
    }
}

