/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterEditManager {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(ParameterEditManager.class);
    private static RDBMDistributedLayoutStore dls = null;

    private static RDBMDistributedLayoutStore getDLS() {
        if (dls == null) {
            IUserLayoutStore uls = null;
            uls = UserLayoutStoreFactory.getUserLayoutStoreImpl();
            dls = (RDBMDistributedLayoutStore)uls;
        }
        return dls;
    }

    static void applyAndUpdateParmEditSet(Document plf, Document ilf, IntegrationResult result) {
        Element pSet = null;
        try {
            pSet = ParameterEditManager.getParmEditSet(plf, null, false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while getting user's DLM paramter-edit-set.", (Throwable)e);
        }
        if (pSet == null) {
            return;
        }
        NodeList edits = pSet.getChildNodes();
        for (int i = edits.getLength() - 1; i >= 0; --i) {
            if (!ParameterEditManager.applyEdit((Element)edits.item(i), ilf)) {
                pSet.removeChild(edits.item(i));
                result.changedPLF = true;
                continue;
            }
            result.changedILF = true;
        }
        if (pSet.getChildNodes().getLength() == 0) {
            plf.getDocumentElement().removeChild(pSet);
            result.changedPLF = true;
        }
    }

    private static boolean applyEdit(Element edit, Document ilf) {
        String nodeID = edit.getAttribute("dlm:target");
        Element channel = ilf.getElementById(nodeID);
        if (channel == null) {
            return false;
        }
        String parmName = edit.getAttribute("name");
        String parmValue = edit.getAttribute("dlm:userValue");
        NodeList ilfParms = channel.getChildNodes();
        Element targetParm = null;
        for (int i = 0; i < ilfParms.getLength(); ++i) {
            Element ilfParm = (Element)ilfParms.item(i);
            if (!ilfParm.getAttribute("name").equals(parmName)) continue;
            targetParm = ilfParm;
            break;
        }
        if (targetParm == null) {
            Element parameter = ilf.createElement("parameter");
            parameter.setAttribute("name", parmName);
            parameter.setAttribute("value", parmValue);
            parameter.setAttribute("override", "yes");
            channel.appendChild(parameter);
            return true;
        }
        Attr override = targetParm.getAttributeNode("override");
        if (override != null && !override.getNodeValue().equals("yes")) {
            return false;
        }
        if (targetParm.getAttribute("value").equals(parmValue)) {
            return false;
        }
        targetParm.setAttribute("value", parmValue);
        return true;
    }

    private static Element getParmEditSet(Document plf, IPerson person, boolean create) throws PortalException {
        Element root = plf.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("dlm:parmSet")) continue;
            return (Element)child;
        }
        if (!create) {
            return null;
        }
        String ID = null;
        try {
            ID = ParameterEditManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new parameter edit set node Id for userId=" + person.getID(), (Throwable)e);
        }
        Element parmSet = plf.createElement("dlm:parmSet");
        parmSet.setAttribute("type", "dlm:parmSet");
        parmSet.setAttribute("ID", ID);
        parmSet.setIdAttribute("ID", true);
        root.appendChild(parmSet);
        return parmSet;
    }

    public static synchronized void addParmEditDirective(Element compViewChannelNode, String targetId, String name, String value, IPerson person) throws PortalException {
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        Element parmSet = ParameterEditManager.getParmEditSet(plf, person, true);
        NodeList edits = parmSet.getChildNodes();
        Element existingEdit = null;
        for (int i = 0; i < edits.getLength(); ++i) {
            Element edit = (Element)edits.item(i);
            if (!edit.getAttribute("dlm:target").equals(targetId) || !edit.getAttribute("name").equals(name)) continue;
            existingEdit = edit;
            break;
        }
        if (existingEdit == null) {
            ParameterEditManager.addParmEditDirective(targetId, name, value, person, plf, parmSet);
            return;
        }
        existingEdit.setAttribute("dlm:userValue", value);
    }

    private static void addParmEditDirective(String targetID, String name, String value, IPerson person, Document plf, Element parmSet) throws PortalException {
        String ID = null;
        try {
            ID = ParameterEditManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new parameter edit node Id for userId=" + person.getID(), (Throwable)e);
        }
        Element parm = plf.createElement("dlm:parm");
        parm.setAttribute("type", "dlm:parm");
        parm.setAttribute("ID", ID);
        parm.setIdAttribute("ID", true);
        parm.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:target", targetID);
        parm.setAttribute("name", name);
        parm.setAttribute("dlm:userValue", value);
        parmSet.appendChild(parm);
    }

    public static void removeParmEditDirective(String targetId, String name, IPerson person) throws PortalException {
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        Element parmSet = ParameterEditManager.getParmEditSet(plf, person, false);
        if (parmSet == null) {
            return;
        }
        NodeList edits = parmSet.getChildNodes();
        for (int i = 0; i < edits.getLength(); ++i) {
            Element edit = (Element)edits.item(i);
            if (!edit.getAttribute("dlm:target").equals(targetId) || !edit.getAttribute("name").equals(name)) continue;
            parmSet.removeChild(edit);
            break;
        }
        if (parmSet.getChildNodes().getLength() == 0) {
            Node parent = parmSet.getParentNode();
            parent.removeChild(parmSet);
        }
    }
}

