/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.danann.cernunnos.Attributes;
import org.danann.cernunnos.ReturnValueImpl;
import org.danann.cernunnos.Task;
import org.danann.cernunnos.TaskRequest;
import org.danann.cernunnos.TaskResponse;
import org.danann.cernunnos.runtime.RuntimeRequestResponse;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMUserIdentityStore;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channel.ChannelLifecycleState;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channel.XmlGeneratingBaseChannelDefinition;
import org.jasig.portal.channels.error.ErrorCode;
import org.jasig.portal.layout.LayoutStructure;
import org.jasig.portal.layout.StructureParameter;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.DecoratorLoader;
import org.jasig.portal.layout.dlm.DistributedUserPreferences;
import org.jasig.portal.layout.dlm.EditManager;
import org.jasig.portal.layout.dlm.FragmentActivator;
import org.jasig.portal.layout.dlm.FragmentChannelInfo;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.FragmentNodeInfo;
import org.jasig.portal.layout.dlm.ILFBuilder;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.LayoutDecorator;
import org.jasig.portal.layout.dlm.LayoutStoreProvider;
import org.jasig.portal.layout.dlm.PLFIntegrator;
import org.jasig.portal.layout.dlm.UserView;
import org.jasig.portal.layout.simple.RDBMUserLayoutStore;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.provider.BrokenSecurityContext;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.spring.locator.ConfigurationLoaderLocator;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.SmartCache;
import org.jasig.portal.utils.XML;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class RDBMDistributedLayoutStore
extends RDBMUserLayoutStore {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(RDBMDistributedLayoutStore.class);
    private static final Pattern USER_NODE_PATTERN = Pattern.compile("\\A([a-zA-Z]\\d*)\\z");
    private String systemDefaultUser = null;
    private boolean systemDefaultUserLoaded = false;
    private ConfigurationLoader configurationLoader;
    private Map<String, FragmentNodeInfo> fragmentInfoCache = new ConcurrentHashMap<String, FragmentNodeInfo>();
    private LayoutDecorator decorator = null;
    private FragmentActivator fragmentActivator;
    private final SingletonDoubleCheckedCreator<FragmentActivator> fragmentActivatorCreator = new SingletonDoubleCheckedCreator<FragmentActivator>(){

        @Override
        protected FragmentActivator createSingleton(Object ... args) {
            RDBMDistributedLayoutStore parent = (RDBMDistributedLayoutStore)args[0];
            FragmentActivator rslt = new FragmentActivator(parent, RDBMDistributedLayoutStore.this.configurationLoader.getFragments());
            rslt.activateFragments();
            return rslt;
        }
    };
    static final String TEMPLATE_USER_NAME = "org.jasig.portal.services.Authentication.defaultTemplateUserName";
    static final String DECORATOR_PROPERTY = "layoutDecorator";
    private static final int THEME = 0;
    private static final int STRUCT = 1;
    static final String DELETE_FROM_UP_SS_USER_ATTS_SQL = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID = ? AND PROFILE_ID = ? AND SS_ID = ? AND SS_TYPE = ?";
    static final String DELETE_FROM_UP_USER_PARM = "DELETE FROM UP_SS_USER_PARM WHERE USER_ID=?  AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=?";
    private static SmartCache tsdCache;
    private static SmartCache ssdCache;
    private final org.dom4j.DocumentFactory fac = new org.dom4j.DocumentFactory();
    private final DOMReader reader = new DOMReader();
    private final DOMWriter writer = new DOMWriter();
    private Task lookupNoderefTask;
    private Task lookupPathrefTask;
    private final IUserIdentityStore identityStore = new RDBMUserIdentityStore();
    private static final String INSERT__INTO__UP_SS_USER_ATTS = "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_TYPE,PARAM_NAME,PARAM_VAL) VALUES (?,?,?,?,?,?,?,?)";

    public void setLookupNoderefTask(Task k) {
        this.lookupNoderefTask = k;
    }

    public void setLookupPathrefTask(Task k) {
        this.lookupPathrefTask = k;
    }

    public Map<String, org.w3c.dom.Document> getFragmentLayoutCopies() throws Exception {
        FragmentActivator activator = this.getFragmentActivator();
        HashMap<String, org.w3c.dom.Document> layouts = new HashMap<String, org.w3c.dom.Document>();
        List<FragmentDefinition> definitions = this.configurationLoader.getFragments();
        for (FragmentDefinition fragmentDefinition : definitions) {
            org.w3c.dom.Document layout = DocumentFactory.getNewDocument();
            org.w3c.dom.Node copy = layout.importNode(activator.getUserView((FragmentDefinition)fragmentDefinition).layout.getDocumentElement(), true);
            layout.appendChild(copy);
            layouts.put(fragmentDefinition.getOwnerId(), layout);
        }
        return layouts;
    }

    public RDBMDistributedLayoutStore() throws Exception {
        tsdCache = new SmartCache();
        ssdCache = new SmartCache();
        this.configurationLoader = ConfigurationLoaderLocator.getConfigurationLoader();
        try {
            String decoratorClass = this.configurationLoader.getProperty(DECORATOR_PROPERTY);
            if (decoratorClass != null) {
                this.decorator = DecoratorLoader.load(decoratorClass);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("\n\n---------- Warning ---------\nUnable to load layout decorator '" + this.configurationLoader.getProperty(DECORATOR_PROPERTY) + "' specified in dlm.xml. It will not be used."), (Throwable)e);
        }
    }

    private FragmentActivator getFragmentActivator() {
        return (FragmentActivator)this.fragmentActivatorCreator.get(this);
    }

    @Override
    public Integer addStructureStylesheetDescription(StructureStylesheetDescription ssd) throws Exception {
        Integer id = super.addStructureStylesheetDescription(ssd);
        ssdCache.put(new Integer(id), ssd);
        return id;
    }

    @Override
    public Integer addThemeStylesheetDescription(ThemeStylesheetDescription tsd) throws Exception {
        Integer id = super.addThemeStylesheetDescription(tsd);
        tsdCache.put(new Integer(id), tsd);
        return id;
    }

    @Override
    public StructureStylesheetDescription getStructureStylesheetDescription(int stylesheetId) throws Exception {
        StructureStylesheetDescription ssd = null;
        ssd = (StructureStylesheetDescription)ssdCache.get(new Integer(stylesheetId));
        if (ssd != null) {
            return ssd;
        }
        ssd = super.getStructureStylesheetDescription(stylesheetId);
        ssdCache.put(new Integer(stylesheetId), ssd);
        return ssd;
    }

    @Override
    public ThemeStylesheetDescription getThemeStylesheetDescription(int stylesheetId) throws Exception {
        ThemeStylesheetDescription tsd = null;
        tsd = (ThemeStylesheetDescription)tsdCache.get(new Integer(stylesheetId));
        if (tsd != null) {
            return tsd;
        }
        tsd = super.getThemeStylesheetDescription(stylesheetId);
        tsdCache.put(new Integer(stylesheetId), tsd);
        return tsd;
    }

    @Override
    public void removeStructureStylesheetDescription(int stylesheetId) throws Exception {
        super.removeStructureStylesheetDescription(stylesheetId);
        ssdCache.remove(new Integer(stylesheetId));
    }

    @Override
    public void removeThemeStylesheetDescription(int stylesheetId) throws Exception {
        super.removeThemeStylesheetDescription(stylesheetId);
        tsdCache.remove(new Integer(stylesheetId));
    }

    @Override
    public void updateStructureStylesheetDescription(StructureStylesheetDescription ssd) throws Exception {
        super.updateStructureStylesheetDescription(ssd);
        ssdCache.put(new Integer(ssd.getId()), ssd);
    }

    @Override
    public void updateThemeStylesheetDescription(ThemeStylesheetDescription tsd) throws Exception {
        super.updateThemeStylesheetDescription(tsd);
        tsdCache.put(new Integer(tsd.getId()), tsd);
    }

    public void cleanFragments() {
        FragmentActivator activator = this.getFragmentActivator();
        List<FragmentDefinition> definitions = this.configurationLoader.getFragments();
        if (null != definitions) {
            HashMap<PersonImpl, FragmentDefinition> owners = new HashMap<PersonImpl, FragmentDefinition>();
            for (FragmentDefinition fragmentDefinition : definitions) {
                String ownerId = fragmentDefinition.getOwnerId();
                UserView userView = activator.getUserView(fragmentDefinition);
                if (userView == null) continue;
                int userId = userView.getUserId();
                if (null == ownerId) continue;
                PersonImpl p = new PersonImpl();
                p.setID(userId);
                p.setAttribute("username", ownerId);
                owners.put(p, fragmentDefinition);
            }
            for (Map.Entry entry : owners.entrySet()) {
                org.w3c.dom.Document layout;
                UserProfile profile;
                IPerson person = (IPerson)entry.getKey();
                try {
                    profile = this.getUserProfileByFname(person, "default");
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to retrieve UserProfile for person " + person + " while cleaning fragment cache, person will be skipped"), (Throwable)e);
                    continue;
                }
                profile.setProfileFname("default");
                try {
                    layout = this.getFragmentLayout(person, profile);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to retrieve layout for person " + person + " and profile " + profile + " while cleaning fragment cache, person will be skipped"), (Throwable)e);
                    continue;
                }
                FragmentDefinition fragment = (FragmentDefinition)entry.getValue();
                this.updateCachedLayout(layout, profile, fragment);
            }
        }
        this.fragmentInfoCache = new ConcurrentHashMap<String, FragmentNodeInfo>();
    }

    public double getFragmentPrecedence(int index) {
        List<FragmentDefinition> definitions = this.configurationLoader.getFragments();
        if (index < 0 || index > definitions.size() - 1) {
            return 0.0;
        }
        for (FragmentDefinition fragmentDefinition : definitions) {
            if (fragmentDefinition.getIndex() != index) continue;
            return fragmentDefinition.getPrecedence();
        }
        return 0.0;
    }

    @Override
    public org.w3c.dom.Document getUserLayout(IPerson person, UserProfile profile) throws Exception {
        org.w3c.dom.Document layout = this._getUserLayout(person, profile);
        if (this.decorator != null) {
            this.decorator.decorate(layout, person, profile);
        }
        return layout;
    }

    private boolean layoutExistsForUser(IPerson person) {
        if (person == null) {
            String msg = "Argument 'person' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(RDBMServices.getDataSource());
        int struct_count = jdbcTemplate.queryForInt("SELECT COUNT(*) FROM up_layout_struct WHERE user_id = ?", new Object[]{person.getID()});
        return struct_count != 0;
    }

    @Override
    public org.dom4j.Element exportLayout(IPerson person, UserProfile profile) {
        String[] pathTokens;
        if (!this.layoutExistsForUser(person)) {
            return null;
        }
        Document layoutDoc = null;
        UserPreferences up = null;
        try {
            org.w3c.dom.Document layoutDom = this._safeGetUserLayout(person, profile);
            person.setAttribute("RDBMDistributedLayoutStore.PLF", layoutDom);
            layoutDoc = this.reader.read(layoutDom);
            up = this.getUserPreferences(person, profile);
        }
        catch (Throwable t) {
            String msg = "Unable to obtain layout & profile for user '" + person.getUserName() + "', profileId " + profile.getProfileId();
            throw new RuntimeException(msg, t);
        }
        if (this.log.isDebugEnabled()) {
            StringWriter str = new StringWriter();
            XMLWriter xml = new XMLWriter((Writer)str, new OutputFormat("  ", true));
            try {
                xml.write(layoutDoc);
                xml.close();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to write the layout for user '" + person.getUserName() + "' to the DEBUG log", t);
            }
            this.log.debug((Object)("Layout for user:  " + person.getUserName() + "\n" + str.getBuffer().toString()));
        }
        StructureStylesheetUserPreferences ssup = up.getStructureStylesheetUserPreferences();
        ArrayList<String> structFolderAttrNames = Collections.list(ssup.getFolderAttributeNames());
        for (org.dom4j.Element fld : layoutDoc.selectNodes("//folder")) {
            for (String attr : structFolderAttrNames) {
                String val = ssup.getDefinedFolderAttributeValue(fld.valueOf("@ID"), attr);
                if (val == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding structure folder attribute:  name=" + attr + ", value=" + val));
                }
                org.dom4j.Element sa = this.fac.createElement("structure-attribute");
                org.dom4j.Element n = sa.addElement("name");
                n.setText(attr);
                org.dom4j.Element v = sa.addElement("value");
                v.setText(val);
                fld.elements().add(0, sa);
            }
        }
        ArrayList<String> structChannelAttrNames = Collections.list(ssup.getChannelAttributeNames());
        for (org.dom4j.Element chnl : layoutDoc.selectNodes("//channel")) {
            for (String attr : structChannelAttrNames) {
                String val = ssup.getDefinedChannelAttributeValue(chnl.valueOf("@ID"), attr);
                if (val == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding structure channel attribute:  name=" + attr + ", value=" + val));
                }
                org.dom4j.Element sa = this.fac.createElement("structure-attribute");
                org.dom4j.Element n = sa.addElement("name");
                n.setText(attr);
                org.dom4j.Element v = sa.addElement("value");
                v.setText(val);
                chnl.elements().add(0, sa);
            }
        }
        ThemeStylesheetUserPreferences tsup = up.getThemeStylesheetUserPreferences();
        ArrayList<String> themeChannelAttrNames = Collections.list(tsup.getChannelAttributeNames());
        for (org.dom4j.Element chnl : layoutDoc.selectNodes("//channel")) {
            for (String attr : themeChannelAttrNames) {
                String val = tsup.getDefinedChannelAttributeValue(chnl.valueOf("@ID"), attr);
                if (val == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding theme channel attribute:  name=" + attr + ", value=" + val));
                }
                org.dom4j.Element ta = this.fac.createElement("theme-attribute");
                org.dom4j.Element n = ta.addElement("name");
                n.setText(attr);
                org.dom4j.Element v = ta.addElement("value");
                v.setText(val);
                chnl.elements().add(0, ta);
            }
        }
        for (Attribute loc : layoutDoc.selectNodes("//@locale")) {
            loc.getParent().remove(loc);
        }
        for (org.dom4j.Element ch : layoutDoc.selectNodes("//channel[@fname = '']")) {
            ch.getParent().remove(ch);
        }
        List<String> channelAttributeWhitelist = Arrays.asList("fname", "unremovable", "hidden", "immutable", "ID", "dlm:plfID");
        for (org.dom4j.Element oldCh : layoutDoc.selectNodes("//channel")) {
            org.dom4j.Element parent = oldCh.getParent();
            org.dom4j.Element newCh = this.fac.createElement("channel");
            for (String aName : channelAttributeWhitelist) {
                Attribute a = (Attribute)oldCh.selectSingleNode("@" + aName);
                if (a == null) continue;
                newCh.addAttribute(a.getName(), a.getValue());
            }
            parent.elements().add(parent.elements().indexOf(oldCh), newCh);
            parent.remove(oldCh);
        }
        for (Attribute org : layoutDoc.selectNodes("//@dlm:origin")) {
            pathTokens = this.getDlmPathref((String)person.getAttribute("username"), person.getID(), org.getValue(), layoutDoc.getRootElement());
            if (pathTokens != null) {
                org.setValue(pathTokens[0] + ":" + pathTokens[1]);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Layout element '" + org.getUniquePath() + "' from user '" + person.getAttribute("username") + "' failed to match noderef '" + org.getValue() + "'"));
        }
        for (Attribute target : layoutDoc.selectNodes("//@dlm:target")) {
            pathTokens = this.getDlmPathref((String)person.getAttribute("username"), person.getID(), target.getValue(), layoutDoc.getRootElement());
            if (pathTokens != null) {
                target.setValue(pathTokens[0] + ":" + pathTokens[1]);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Layout element '" + target.getUniquePath() + "' from user '" + person.getAttribute("username") + "' failed to match noderef '" + target.getValue() + "'"));
        }
        for (org.dom4j.Element n : layoutDoc.selectNodes("//dlm:*/@name")) {
            if (n.getValue() == null || n.getValue().trim().length() == 0) continue;
            pathTokens = this.getDlmPathref((String)person.getAttribute("username"), person.getID(), n.getValue(), layoutDoc.getRootElement());
            if (pathTokens != null) {
                n.setValue(pathTokens[0] + ":" + pathTokens[1]);
                if (pathTokens[2] == null || pathTokens[2].trim().length() == 0) continue;
                n.getParent().addAttribute("fname", pathTokens[2]);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Layout element '" + n.getUniquePath() + "' from user '" + person.getAttribute("username") + "' failed to match noderef '" + n.getValue() + "'"));
        }
        if (!this.isFragmentOwner(person)) {
            for (Attribute plf : layoutDoc.selectNodes("//@dlm:plfID")) {
                plf.getParent().remove(plf);
            }
            for (Attribute a : layoutDoc.selectNodes("//@ID")) {
                a.getParent().remove(a);
            }
        }
        return layoutDoc.getRootElement();
    }

    @Override
    public void importLayout(org.dom4j.Element layout) {
        Object fname;
        String noderef;
        String ownerUsername = layout.valueOf("@username");
        PersonImpl person = null;
        UserProfile profile = null;
        try {
            person = new PersonImpl();
            person.setUserName(ownerUsername);
            int ownerId = this.identityStore.getPortalUID(person);
            if (ownerId == -1) {
                String msg = "No userId for username=" + ownerUsername;
                throw new RuntimeException(msg);
            }
            person.setID(ownerId);
            person.setSecurityContext(new BrokenSecurityContext());
            profile = this.getUserProfileByFname(person, "default");
        }
        catch (Throwable t) {
            String msg = "Unrecognized user " + person.getUserName() + "; you must import users before their layouts.";
            throw new RuntimeException(msg, t);
        }
        int nextId = 1;
        Iterator it = layout.selectNodes("folder | dlm:*").iterator();
        while (it.hasNext()) {
            nextId = this.addIdAttributesIfNecessary((org.dom4j.Element)it.next(), nextId);
        }
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(RDBMServices.getDataSource());
        jdbcTemplate.update("UPDATE up_user SET next_struct_id = ? WHERE user_id = ?", new Object[]{nextId, person.getID()});
        for (Attribute a : layout.selectNodes("//@dlm:origin")) {
            noderef = this.getDlmNoderef(ownerUsername, a.getValue(), null, true, layout);
            if (noderef == null) continue;
            a.setValue(noderef);
            a.getParent().addAttribute("ID", noderef);
        }
        for (Attribute a : layout.selectNodes("//@dlm:target")) {
            noderef = this.getDlmNoderef(ownerUsername, a.getValue(), null, true, layout);
            if (noderef == null) continue;
            a.setValue(noderef);
        }
        for (Attribute a : layout.selectNodes("//dlm:*/@name")) {
            fname = a.getParent().attribute("fname");
            String noderef2 = null;
            if (fname != null) {
                noderef2 = this.getDlmNoderef(ownerUsername, a.getValue(), fname.getValue(), false, layout);
                fname.getParent().remove(fname);
            } else {
                noderef2 = this.getDlmNoderef(ownerUsername, a.getValue(), null, true, layout);
            }
            if (noderef2 == null) continue;
            a.setValue(noderef2);
        }
        for (org.dom4j.Element c : layout.selectNodes("//channel")) {
            fname = c.valueOf("@fname");
            IChannelDefinition cd = this.channelRegistryStore.getChannelDefinition((String)fname);
            if (cd == null) {
                throw new IllegalArgumentException("No published channel for fname=" + (String)fname + " referenced by layout for " + ownerUsername);
            }
            c.addAttribute("chanID", String.valueOf(cd.getId()));
        }
        org.w3c.dom.Document layoutDom = null;
        try {
            String n;
            UserPreferences up = new UserPreferences(profile);
            up.setStructureStylesheetUserPreferences(this.getDistributedSSUP(person, profile.getProfileId(), profile.getStructureStylesheetId()));
            up.setThemeStylesheetUserPreferences(this.getDistributedTSUP(person, profile.getProfileId(), profile.getThemeStylesheetId()));
            boolean saSet = false;
            StructureStylesheetUserPreferences ssup = up.getStructureStylesheetUserPreferences();
            Enumeration names = ssup.getFolderAttributeNames();
            while (names.hasMoreElements()) {
                n = (String)names.nextElement();
                Enumeration fIds = ssup.getFolders();
                while (fIds.hasMoreElements()) {
                    String f = (String)fIds.nextElement();
                    if (ssup.getDefinedFolderAttributeValue(f, n) == null) continue;
                    ssup.removeFolder(f);
                }
            }
            names = ssup.getChannelAttributeNames();
            while (names.hasMoreElements()) {
                n = (String)names.nextElement();
                Enumeration chds = ssup.getChannels();
                while (chds.hasMoreElements()) {
                    String c = (String)chds.nextElement();
                    if (ssup.getDefinedChannelAttributeValue(c, n) == null) continue;
                    ssup.removeChannel(c);
                }
            }
            for (org.dom4j.Element sa : layout.selectNodes("//structure-attribute")) {
                String idAttr = sa.getParent().valueOf("@ID");
                if (sa.getParent().getName().equals("folder")) {
                    ssup.setFolderAttributeValue(idAttr, sa.valueOf("name"), sa.valueOf("value"));
                    saSet = true;
                } else if (sa.getParent().getName().equals("channel")) {
                    ssup.setChannelAttributeValue(idAttr, sa.valueOf("name"), sa.valueOf("value"));
                    saSet = true;
                } else {
                    String msg = "Unrecognized parent element for user preferences attribute:  " + sa.getParent().getName();
                    throw new RuntimeException(msg);
                }
                sa.getParent().remove(sa);
            }
            boolean taSet = false;
            ThemeStylesheetUserPreferences tsup = up.getThemeStylesheetUserPreferences();
            Enumeration names2 = tsup.getChannelAttributeNames();
            while (names2.hasMoreElements()) {
                String n2 = (String)names2.nextElement();
                Enumeration chds = tsup.getChannels();
                while (chds.hasMoreElements()) {
                    String c = (String)chds.nextElement();
                    if (tsup.getDefinedChannelAttributeValue(c, n2) == null) continue;
                    tsup.removeChannel(c);
                }
            }
            for (org.dom4j.Element ta : layout.selectNodes("//theme-attribute")) {
                String idAttr = ta.getParent().valueOf("@ID");
                tsup.setChannelAttributeValue(idAttr, ta.valueOf("name"), ta.valueOf("value"));
                taSet = true;
                ta.getParent().remove(ta);
            }
            for (Text txt : layout.selectNodes("descendant::text()")) {
                if (txt.getText().trim().length() != 0) continue;
                txt.getParent().remove(txt);
            }
            org.dom4j.Element copy = layout.createCopy();
            Document doc = this.fac.createDocument(copy);
            doc.normalize();
            layoutDom = this.writer.write(doc);
            person.setAttribute("RDBMDistributedLayoutStore.PLF", layoutDom);
            if (saSet) {
                this.setStructureStylesheetUserPreferences(person, profile.getProfileId(), ssup);
            }
            if (taSet) {
                this.setThemeStylesheetUserPreferences(person, profile.getProfileId(), tsup);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to set UserPreferences for user:  " + person.getUserName()));
            throw new RuntimeException(t);
        }
        try {
            this.setUserLayout(person, profile, layoutDom, true, false);
        }
        catch (Throwable t) {
            String msg = "Unable to persist layout for user:  " + ownerUsername;
            throw new RuntimeException(msg, t);
        }
    }

    private final int addIdAttributesIfNecessary(org.dom4j.Element e, int nextId) {
        int idAfterThisOne = nextId;
        if (e.selectSingleNode("@ID | @dlm:plfID") == null) {
            char prefix;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No ID or dlm:plfID attribute for the following node (one will be generated and added):  element" + e.getName() + ", name=" + e.valueOf("@name") + ", fname=" + e.valueOf("@fname")));
            }
            if (e.getName().equals("folder")) {
                prefix = 's';
            } else if (e.getName().equals("channel")) {
                prefix = 'n';
            } else if (e.getQName().getNamespacePrefix().equals("dlm")) {
                prefix = 'd';
            } else {
                throw new RuntimeException("Unrecognized element type:  " + e.getName());
            }
            String origin = e.valueOf("@dlm:origin");
            if (origin != null && origin.length() != 0) {
                e.addAttribute("dlm:plfID", prefix + String.valueOf(nextId));
            } else {
                e.addAttribute("ID", prefix + String.valueOf(nextId));
            }
            ++idAfterThisOne;
        }
        for (org.dom4j.Element child : e.selectNodes("folder | channel | dlm:*")) {
            idAfterThisOne = this.addIdAttributesIfNecessary(child, idAfterThisOne);
        }
        return idAfterThisOne;
    }

    private final String[] getDlmPathref(String layoutOwnerUsername, int layoutOwnerUserId, String dlmNoderef, org.dom4j.Element layout) {
        if (layoutOwnerUsername == null) {
            String msg = "Argument 'layoutOwnerUsername' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (dlmNoderef == null) {
            String msg = "Argument 'dlmNoderef' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (layout == null) {
            String msg = "Argument 'layout' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        String[] rslt = null;
        Matcher m = USER_NODE_PATTERN.matcher(dlmNoderef);
        if (m.find()) {
            String structId = m.group(1);
            Node target = layout.selectSingleNode("//*[@ID = '" + structId + "']");
            if (target != null) {
                rslt = new String[3];
                rslt[0] = layoutOwnerUsername;
                rslt[1] = target.getUniquePath();
                if (target.getName().equals("channel")) {
                    rslt[2] = target.valueOf("@fname");
                }
            } else {
                this.log.warn((Object)("no match found on layout for user '" + layoutOwnerUsername + "' for the specified dlmNoderef:  " + dlmNoderef));
            }
        } else {
            ReturnValueImpl rvi = new ReturnValueImpl();
            RuntimeRequestResponse tr = new RuntimeRequestResponse();
            tr.setAttribute(Attributes.RETURN_VALUE, (Object)rvi);
            tr.setAttribute("USER_NAME", (Object)layoutOwnerUsername);
            tr.setAttribute("DLM_NODEREF", (Object)dlmNoderef);
            final RDBMDistributedLayoutStore layoutStore = this;
            tr.setAttribute("layoutStoreProvider", (Object)new LayoutStoreProvider(){

                @Override
                public RDBMDistributedLayoutStore getLayoutStore() {
                    return layoutStore;
                }
            });
            this.lookupNoderefTask.perform((TaskRequest)tr, (TaskResponse)new RuntimeRequestResponse());
            rslt = (String[])rvi.getValue();
        }
        return rslt;
    }

    private final String getDlmNoderef(String layoutOwner, String pathref, String fname, boolean isStructRef, org.dom4j.Element layoutElement) {
        if (layoutOwner == null) {
            String msg = "Argument 'layoutOwner' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (pathref == null) {
            String msg = "Argument 'pathref' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (layoutElement == null) {
            String msg = "Argument 'layoutElement' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        String rslt = pathref;
        if (pathref.startsWith(layoutOwner + ":")) {
            String[] pathTokens = pathref.split("\\:");
            org.dom4j.Element target = (org.dom4j.Element)layoutElement.selectSingleNode(pathTokens[1]);
            if (target != null) {
                rslt = target.valueOf("@ID");
            } else if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Unable to resolve pathref '" + pathref + "' for layoutOwner '" + layoutOwner + "'"));
            }
        } else {
            ReturnValueImpl rvi = new ReturnValueImpl();
            RuntimeRequestResponse tr = new RuntimeRequestResponse();
            tr.setAttribute(Attributes.RETURN_VALUE, (Object)rvi);
            tr.setAttribute("USER_NAME", (Object)layoutOwner);
            tr.setAttribute("DLM_PATHREF", (Object)pathref);
            if (fname != null) {
                tr.setAttribute("FNAME", (Object)fname);
            }
            if (isStructRef) {
                tr.setAttribute("IS_STRUCT_REF", (Object)Boolean.TRUE);
            }
            final RDBMDistributedLayoutStore layoutStore = this;
            tr.setAttribute("layoutStoreProvider", (Object)new LayoutStoreProvider(){

                @Override
                public RDBMDistributedLayoutStore getLayoutStore() {
                    return layoutStore;
                }
            });
            this.lookupPathrefTask.perform((TaskRequest)tr, (TaskResponse)new RuntimeRequestResponse());
            String val = (String)rvi.getValue();
            if (val != null) {
                rslt = val;
            }
        }
        return rslt.length() <= 35 ? rslt : "";
    }

    private org.w3c.dom.Document _safeGetUserLayout(IPerson person, UserProfile profile) throws Exception {
        org.w3c.dom.Document layoutDoc = super.getUserLayout(person, profile);
        Element layout = layoutDoc.getDocumentElement();
        layout.setAttribute("xmlns:dlm", "http://www.uportal.org/layout/dlm");
        return layoutDoc;
    }

    private org.w3c.dom.Document _getUserLayout(IPerson person, UserProfile profile) throws Exception {
        String userName = (String)person.getAttribute("username");
        FragmentDefinition ownedFragment = this.getOwnedFragment(person);
        boolean isLayoutOwnerDefault = this.isLayoutOwnerDefault(person);
        if (ownedFragment != null || isLayoutOwnerDefault) {
            org.w3c.dom.Document ILF = null;
            org.w3c.dom.Document PLF = this._safeGetUserLayout(person, profile);
            ILF = XML.cloneDocument(PLF);
            Element layoutNode = ILF.getDocumentElement();
            if (ownedFragment != null) {
                layoutNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:fragmentName", ownedFragment.getName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User '" + userName + "' is owner of '" + ownedFragment.getName() + "' fragment."));
                }
            } else if (isLayoutOwnerDefault) {
                layoutNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:isTemplateUser", "true");
                layoutNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:templateLoginID", (String)person.getAttribute("username"));
            }
            person.setAttribute("RDBMDistributedLayoutStore.PLF", PLF);
            return ILF;
        }
        return this.getCompositeLayout(person, profile);
    }

    org.w3c.dom.Document getFragmentLayout(IPerson person, UserProfile profile) throws Exception {
        return this._safeGetUserLayout(person, profile);
    }

    public String getNextStructDirectiveId(IPerson person) throws Exception {
        return super.getNextStructId(person, "d");
    }

    private void updateCachedLayout(org.w3c.dom.Document layout, UserProfile profile, FragmentDefinition fragment) {
        layout = XML.cloneDocument(layout);
        FragmentActivator activator = this.getFragmentActivator();
        Element root = layout.getDocumentElement();
        UserView userView = activator.getUserView(fragment);
        root.setAttribute("ID", "u" + userView.getUserId() + "l" + "1");
        UserView view = new UserView(userView.getUserId(), profile, layout, userView.structUserPrefs, userView.themeUserPrefs);
        try {
            activator.fragmentizeLayout(view, fragment);
            activator.setUserView(fragment.getOwnerId(), view);
            this.fragmentInfoCache = new HashMap<String, FragmentNodeInfo>();
        }
        catch (Exception e) {
            LOG.error((Object)"An exception occurred attempting to update a layout.", (Throwable)e);
        }
    }

    private boolean isLayoutOwnerDefault(IPerson person) {
        String globalDefault;
        String userName = (String)person.getAttribute("username");
        List<FragmentDefinition> definitions = this.configurationLoader.getFragments();
        if (userName != null && definitions != null) {
            for (FragmentDefinition fragmentDefinition : definitions) {
                if (fragmentDefinition.defaultLayoutOwnerID == null || !fragmentDefinition.defaultLayoutOwnerID.equals(userName)) continue;
                return true;
            }
        }
        if ((globalDefault = this.getProperty("defaultLayoutOwner")) != null && globalDefault.equals(userName)) {
            return true;
        }
        if (!this.systemDefaultUserLoaded) {
            this.systemDefaultUserLoaded = true;
            try {
                this.systemDefaultUser = PropertiesManager.getProperty(TEMPLATE_USER_NAME);
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Property 'org.jasig.portal.services.Authentication.defaultTemplateUserName' not defined.", (Throwable)re);
            }
            if (this.systemDefaultUser != null && this.systemDefaultUser.equals(userName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isFragmentOwner(IPerson person) {
        return this.getOwnedFragment(person) != null;
    }

    private FragmentDefinition getOwnedFragment(IPerson person) {
        int userId = person.getID();
        FragmentActivator activator = this.getFragmentActivator();
        List<FragmentDefinition> definitions = this.configurationLoader.getFragments();
        if (definitions != null) {
            for (FragmentDefinition fragmentDefinition : definitions) {
                int fdId;
                UserView userView = activator.getUserView(fragmentDefinition);
                if (userView == null || (fdId = userView.getUserId()) != userId) continue;
                return fragmentDefinition;
            }
        }
        return null;
    }

    private org.w3c.dom.Document getCompositeLayout(IPerson person, UserProfile profile) throws Exception {
        org.w3c.dom.Document PLF;
        Vector<org.w3c.dom.Document> applicables = new Vector<org.w3c.dom.Document>();
        List<FragmentDefinition> definitions = this.configurationLoader.getFragments();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to check applicability of " + definitions.size() + " fragments"));
        }
        FragmentActivator activator = this.getFragmentActivator();
        if (definitions != null) {
            for (FragmentDefinition fragmentDefinition : definitions) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Checking applicability of the following fragment:  " + fragmentDefinition.getName()));
                }
                if (!fragmentDefinition.isApplicable(person)) continue;
                UserView userView = activator.getUserView(fragmentDefinition);
                if (userView != null) {
                    applicables.add(userView.layout);
                    continue;
                }
                this.log.warn((Object)("No UserView exists for fragment definition: " + fragmentDefinition.getOwnerId() + " it will not be included in the applicable fragment list"));
            }
        }
        if (null == (PLF = (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF"))) {
            PLF = this._safeGetUserLayout(person, profile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PLF for " + person.getAttribute("username") + " immediately after loading\n" + XML.serializeNode(PLF)));
        }
        org.w3c.dom.Document ILF = ILFBuilder.constructILF(PLF, applicables, person);
        person.setAttribute("RDBMDistributedLayoutStore.PLF", PLF);
        IntegrationResult result = new IntegrationResult();
        PLFIntegrator.mergePLFintoILF(PLF, ILF, result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PLF for " + person.getAttribute("username") + " after MERGING\n" + XML.serializeNode(PLF)));
            LOG.debug((Object)("ILF for " + person.getAttribute("username") + " after MERGING\n" + XML.serializeNode(ILF)));
        }
        if (result.changedPLF) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving PLF for " + person.getAttribute("username") + " due to changes during merge."));
            }
            super.setUserLayout(person, profile, PLF, false);
        }
        return ILF;
    }

    @Override
    public void setUserLayout(IPerson person, UserProfile profile, org.w3c.dom.Document layoutXML, boolean channelsAdded) throws Exception {
        this.setUserLayout(person, profile, layoutXML, channelsAdded, true);
    }

    void setUserLayout(IPerson person, UserProfile profile, org.w3c.dom.Document layoutXML, boolean channelsAdded, boolean updateFragmentCache) throws Exception {
        FragmentDefinition fragment;
        org.w3c.dom.Document plf = (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PLF for " + person.getAttribute("username") + "\n" + XML.serializeNode(plf)));
        }
        super.setUserLayout(person, profile, plf, channelsAdded);
        if (updateFragmentCache && (fragment = this.getOwnedFragment(person)) != null) {
            this.updateCachedLayout(plf, profile, fragment);
        }
    }

    public int getPropertyCount() {
        return this.configurationLoader.getPropertyCount();
    }

    public String getProperty(String name) {
        return this.configurationLoader.getProperty(name);
    }

    FragmentChannelInfo getFragmentChannelInfo(String sId) {
        FragmentNodeInfo node = this.getFragmentNodeInfo(sId);
        if (node != null && node instanceof FragmentChannelInfo) {
            return (FragmentChannelInfo)node;
        }
        return null;
    }

    FragmentNodeInfo getFragmentNodeInfo(String sId) {
        Map<String, FragmentNodeInfo> infoCache = this.fragmentInfoCache;
        List<FragmentDefinition> fragments = this.configurationLoader.getFragments();
        FragmentActivator activator = this.getFragmentActivator();
        FragmentNodeInfo info = infoCache.get(sId);
        if (info == null) {
            for (FragmentDefinition fragmentDefinition : fragments) {
                UserView userView = activator.getUserView(fragmentDefinition);
                if (userView == null) {
                    this.log.warn((Object)("No UserView is present for fragment " + fragmentDefinition.getName() + " it will be skipped when fragment node information"));
                    continue;
                }
                Element node = userView.layout.getElementById(sId);
                if (node == null) continue;
                info = node.getTagName().equals("channel") ? new FragmentChannelInfo(node) : new FragmentNodeInfo(node);
                infoCache.put(sId, info);
                break;
            }
        }
        return info;
    }

    DistributedUserPreferences getDistributedSSUP(IPerson person, int profileId, int stylesheetId) throws Exception {
        return new DistributedUserPreferences(this._getStructureStylesheetUserPreferences(person, profileId, stylesheetId));
    }

    DistributedUserPreferences getDistributedTSUP(IPerson person, int profileId, int stylesheetId) throws Exception {
        return new DistributedUserPreferences(this._getThemeStylesheetUserPreferences(person, profileId, stylesheetId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, String> getOriginIds(Connection con, int userId, int profileId, int stylesheetType, int stylesheetId) throws SQLException {
        String originIdQuery = "SELECT struct_id, struct_parm_val FROM up_layout_param WHERE user_id=? AND layout_id = 1 and (struct_parm_nm=? OR struct_parm_nm=?) AND struct_id IN (SELECT struct_id FROM up_ss_user_atts WHERE user_id=? AND profile_id=? AND ss_type=? AND ss_id=?)";
        PreparedStatement pstmt = con.prepareStatement(originIdQuery);
        pstmt.setInt(1, userId);
        pstmt.setString(2, "dlm:origin");
        pstmt.setString(3, "cp:origin");
        pstmt.setInt(4, userId);
        pstmt.setInt(5, profileId);
        pstmt.setInt(6, stylesheetType);
        pstmt.setInt(7, stylesheetId);
        HashMap<Integer, String> originIds = null;
        try {
            ResultSet rs = pstmt.executeQuery();
            try {
                while (rs.next()) {
                    if (originIds == null) {
                        originIds = new HashMap<Integer, String>();
                    }
                    String originId = rs.getString(2);
                    int structId = rs.getInt(1);
                    originIds.put(new Integer(structId), originId);
                }
            }
            finally {
                RDBMDistributedLayoutStore.close(rs);
            }
        }
        finally {
            RDBMDistributedLayoutStore.close(pstmt);
        }
        return originIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructureStylesheetUserPreferences _getStructureStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        StructureStylesheetUserPreferences ssup;
        int userId = person.getID();
        StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(stylesheetId);
        Connection con = RDBMServices.getConnection();
        try {
            String sQuery;
            block38: {
                String pName;
                int origProfileId;
                int origId;
                block36: {
                    sQuery = "SELECT USER_DFLT_USR_ID FROM UP_USER WHERE USER_ID = ?";
                    PreparedStatement pstmt1 = con.prepareStatement(sQuery);
                    try {
                        int layoutId = this.getLayoutID(userId, profileId);
                        origId = userId;
                        origProfileId = profileId;
                        if (layoutId != 0) break block36;
                        pstmt1.setInt(1, userId);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(sQuery + " VALUE " + userId));
                        }
                        ResultSet rs = pstmt1.executeQuery();
                        try {
                            rs.next();
                            userId = rs.getInt(1);
                            UserProfile profile = this.getUserProfileById(person, profileId);
                            PersonImpl defaultProfilePerson = new PersonImpl();
                            defaultProfilePerson.setID(userId);
                            profileId = this.getUserProfileByFname(defaultProfilePerson, profile.getProfileFname()).getProfileId();
                        }
                        finally {
                            RDBMDistributedLayoutStore.close(rs);
                        }
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(pstmt1);
                    }
                }
                ssup = new StructureStylesheetUserPreferences();
                ssup.setStylesheetId(stylesheetId);
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.putParameterValue(pName, ssd.getStylesheetParameterDefaultValue(pName));
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.addChannelAttribute(pName, ssd.getChannelAttributeDefaultValue(pName));
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.addFolderAttribute(pName, ssd.getFolderAttributeDefaultValue(pName));
                }
                String pstmtQuery = "SELECT PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=? AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=1";
                PreparedStatement pstmt2 = con.prepareStatement(pstmtQuery);
                try {
                    pstmt2.setInt(1, userId);
                    pstmt2.setInt(2, profileId);
                    pstmt2.setInt(3, stylesheetId);
                    ResultSet rs1 = pstmt2.executeQuery();
                    try {
                        while (rs1.next()) {
                            String pName2 = rs1.getString(1);
                            if (!ssd.containsParameterName(pName2)) continue;
                            ssup.putParameterValue(pName2, rs1.getString(2));
                        }
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(rs1);
                    }
                    if (userId == origId) break block38;
                    pstmt2.setInt(1, origId);
                    pstmt2.setInt(2, origProfileId);
                    ResultSet rs2 = pstmt2.executeQuery();
                    try {
                        while (rs2.next()) {
                            String pName3 = rs2.getString(1);
                            if (!ssd.containsParameterName(pName3)) continue;
                            ssup.putParameterValue(pName3, rs2.getString(2));
                        }
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(rs2);
                    }
                }
                finally {
                    RDBMDistributedLayoutStore.close(pstmt2);
                }
            }
            Map<Integer, String> originIds = this.getOriginIds(con, userId, profileId, 1, stylesheetId);
            sQuery = "SELECT PARAM_NAME, PARAM_VAL, PARAM_TYPE, ULS.STRUCT_ID, CHAN_ID FROM UP_LAYOUT_STRUCT ULS,  UP_SS_USER_ATTS UUSA WHERE UUSA.USER_ID=? AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=1 AND UUSA.STRUCT_ID = ULS.STRUCT_ID AND UUSA.USER_ID = ULS.USER_ID";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(sQuery + "VALUES "));
            }
            PreparedStatement pstmt4 = con.prepareStatement(sQuery);
            try {
                pstmt4.setInt(1, userId);
                pstmt4.setInt(2, profileId);
                pstmt4.setInt(3, stylesheetId);
                ResultSet rs = pstmt4.executeQuery();
                try {
                    while (rs.next()) {
                        String param_val = rs.getString(2);
                        int structId = rs.getInt(4);
                        String originId = null;
                        if (originIds != null) {
                            originId = originIds.get(new Integer(structId));
                        }
                        int param_type = rs.getInt(3);
                        if (rs.wasNull()) {
                            structId = 0;
                        }
                        String pName = rs.getString(1);
                        int chanId = rs.getInt(5);
                        if (rs.wasNull()) {
                            chanId = 0;
                        }
                        if (param_type == 2) {
                            String folderStructId = null;
                            folderStructId = originId != null ? originId : this.getStructId(structId, chanId);
                            if (!ssd.containsFolderAttribute(pName)) continue;
                            ssup.setFolderAttributeValue(folderStructId, pName, param_val);
                            continue;
                        }
                        if (param_type != 3) continue;
                        String channelStructId = null;
                        channelStructId = originId != null ? originId : this.getStructId(structId, chanId);
                        if (!ssd.containsChannelAttribute(pName)) continue;
                        ssup.setChannelAttributeValue(channelStructId, pName, param_val);
                    }
                }
                finally {
                    RDBMDistributedLayoutStore.close(rs);
                }
            }
            finally {
                RDBMDistributedLayoutStore.close(pstmt4);
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return ssup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThemeStylesheetUserPreferences _getThemeStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        ThemeStylesheetUserPreferences tsup;
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            block39: {
                String pName;
                ResultSet rs;
                ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(stylesheetId);
                int layoutId = this.getLayoutID(userId, profileId);
                int origId = userId;
                int origProfileId = profileId;
                if (layoutId == 0) {
                    String sQuery = "SELECT USER_DFLT_USR_ID FROM UP_USER WHERE USER_ID=?";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(sQuery + " VALUE = " + userId));
                    }
                    PreparedStatement pstmt1 = con.prepareStatement(sQuery);
                    try {
                        pstmt1.setInt(1, userId);
                        rs = pstmt1.executeQuery();
                        try {
                            rs.next();
                            userId = rs.getInt(1);
                            UserProfile profile = this.getUserProfileById(person, profileId);
                            PersonImpl defaultProfilePerson = new PersonImpl();
                            defaultProfilePerson.setID(userId);
                            profileId = this.getUserProfileByFname(defaultProfilePerson, profile.getProfileFname()).getProfileId();
                        }
                        finally {
                            RDBMDistributedLayoutStore.close(rs);
                        }
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(pstmt1);
                    }
                }
                tsup = new ThemeStylesheetUserPreferences();
                tsup.setStylesheetId(stylesheetId);
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    tsup.putParameterValue(pName, tsd.getStylesheetParameterDefaultValue(pName));
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    tsup.addChannelAttribute(pName, tsd.getChannelAttributeDefaultValue(pName));
                }
                String sQuery2 = "SELECT PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=? AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=2";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(sQuery2 + " VALUES " + userId + "," + profileId + "," + stylesheetId));
                }
                PreparedStatement pstmt2 = con.prepareStatement(sQuery2);
                try {
                    pstmt2.setInt(1, userId);
                    pstmt2.setInt(2, profileId);
                    pstmt2.setInt(3, stylesheetId);
                    rs = pstmt2.executeQuery();
                    try {
                        while (rs.next()) {
                            String pName2 = rs.getString(1);
                            if (!tsd.containsParameterName(pName2)) continue;
                            tsup.putParameterValue(pName2, rs.getString(2));
                        }
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(rs);
                    }
                    if (userId == origId) break block39;
                    pstmt2.setInt(1, origId);
                    pstmt2.setInt(2, origProfileId);
                    ResultSet rs2 = pstmt2.executeQuery();
                    try {
                        while (rs2.next()) {
                            String pName3 = rs2.getString(1);
                            if (!tsd.containsParameterName(pName3)) continue;
                            tsup.putParameterValue(pName3, rs2.getString(2));
                        }
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(rs2);
                    }
                }
                finally {
                    RDBMDistributedLayoutStore.close(pstmt2);
                }
            }
            Map<Integer, String> originIds = this.getOriginIds(con, userId, profileId, 2, stylesheetId);
            String sQuery3 = "SELECT PARAM_TYPE, PARAM_NAME, PARAM_VAL, ULS.STRUCT_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT ULS WHERE UUSA.USER_ID=? AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=2 AND UUSA.STRUCT_ID = ULS.STRUCT_ID AND UUSA.USER_ID = ULS.USER_ID";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("SQL to load theme channel attribute prefs: SELECT PARAM_TYPE, PARAM_NAME, PARAM_VAL, ULS.STRUCT_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT ULS WHERE UUSA.USER_ID=? AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=2 AND UUSA.STRUCT_ID = ULS.STRUCT_ID AND UUSA.USER_ID = ULS.USER_ID VALUES " + userId + "," + profileId + "," + stylesheetId));
            }
            PreparedStatement pstmt3 = con.prepareStatement("SELECT PARAM_TYPE, PARAM_NAME, PARAM_VAL, ULS.STRUCT_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT ULS WHERE UUSA.USER_ID=? AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=2 AND UUSA.STRUCT_ID = ULS.STRUCT_ID AND UUSA.USER_ID = ULS.USER_ID");
            try {
                pstmt3.setInt(1, userId);
                pstmt3.setInt(2, profileId);
                pstmt3.setInt(3, stylesheetId);
                ResultSet rs = pstmt3.executeQuery();
                try {
                    while (rs.next()) {
                        int param_type = rs.getInt(1);
                        if (rs.wasNull()) {
                            param_type = 0;
                        }
                        int structId = rs.getInt(4);
                        String originId = null;
                        if (originIds != null) {
                            originId = originIds.get(new Integer(structId));
                        }
                        if (rs.wasNull()) {
                            structId = 0;
                        }
                        int chanId = rs.getInt(5);
                        if (rs.wasNull()) {
                            chanId = 0;
                        }
                        if (param_type != 3) continue;
                        String channelStructId = null;
                        channelStructId = originId != null ? originId : this.getStructId(structId, chanId);
                        tsup.setChannelAttributeValue(channelStructId, rs.getString(2), rs.getString(3));
                    }
                }
                finally {
                    RDBMDistributedLayoutStore.close(rs);
                }
            }
            finally {
                RDBMDistributedLayoutStore.close(pstmt3);
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return tsup;
    }

    @Override
    public StructureStylesheetUserPreferences getStructureStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        DistributedUserPreferences ssup = this.getDistributedSSUP(person, profileId, stylesheetId);
        FragmentDefinition ownedFragment = this.getOwnedFragment(person);
        boolean isLayoutOwnerDefault = this.isLayoutOwnerDefault(person);
        if (ownedFragment != null || isLayoutOwnerDefault) {
            return ssup;
        }
        FragmentActivator activator = this.getFragmentActivator();
        List<FragmentDefinition> fragments = this.configurationLoader.getFragments();
        if (fragments != null) {
            for (FragmentDefinition fragmentDefinition : fragments) {
                if (!fragmentDefinition.isApplicable(person)) continue;
                UserView userView = activator.getUserView(fragmentDefinition);
                if (userView != null) {
                    this.loadIncorporatedPreferences(person, 1, ssup, userView.structUserPrefs);
                    continue;
                }
                this.log.warn((Object)("No UserView is present for fragment " + fragmentDefinition.getName() + " it will be skipped when loading structure preferences"));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("***** " + person.getAttribute("username") + "'s StructureStylesheetUserPrefereneces\n" + this.showFolderAttribs(ssup) + this.showChannelAttribs(ssup)));
        }
        return ssup;
    }

    @Override
    public ThemeStylesheetUserPreferences getThemeStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        DistributedUserPreferences tsup = this.getDistributedTSUP(person, profileId, stylesheetId);
        FragmentDefinition ownedFragment = this.getOwnedFragment(person);
        boolean isLayoutOwnerDefault = this.isLayoutOwnerDefault(person);
        if (ownedFragment != null || isLayoutOwnerDefault) {
            return tsup;
        }
        FragmentActivator activator = this.getFragmentActivator();
        List<FragmentDefinition> fragments = this.configurationLoader.getFragments();
        if (fragments != null) {
            for (FragmentDefinition fragmentDefinition : fragments) {
                if (!fragmentDefinition.isApplicable(person)) continue;
                UserView userView = activator.getUserView(fragmentDefinition);
                if (userView != null) {
                    this.loadIncorporatedPreferences(person, 0, tsup, userView.themeUserPrefs);
                    continue;
                }
                this.log.warn((Object)("No UserView is present for fragment " + fragmentDefinition.getName() + " it will be skipped when loading theme preferences"));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("***** " + person.getAttribute("username") + "'s ThemeStylesheetUserPrefereneces\n" + this.showChannelAttribs(tsup)));
        }
        return tsup;
    }

    private void loadIncorporatedPreferences(IPerson person, int which, DistributedUserPreferences userPrefs, DistributedUserPreferences incdPrefs) {
        String incdValue;
        String userValue;
        String attrib;
        Enumeration attribs;
        Enumeration channels = incdPrefs.getChannels();
        while (channels.hasMoreElements()) {
            String channel = (String)channels.nextElement();
            attribs = incdPrefs.getChannelAttributeNames();
            while (attribs.hasMoreElements()) {
                attrib = (String)attribs.nextElement();
                userValue = userPrefs.getDefinedChannelAttributeValue(channel, attrib);
                incdValue = incdPrefs.getDefinedChannelAttributeValue(channel, attrib);
                if (incdValue != null) {
                    userPrefs.setIncorporatedChannelAttributeValue(channel, attrib, incdValue);
                }
                if (incdValue == null || userValue == null || !incdValue.equals(userValue)) continue;
                userPrefs.removeDefinedChannelAttributeValue(channel, attrib);
                EditManager.removePreferenceDirective(person, channel, attrib);
            }
        }
        if (which == 0) {
            return;
        }
        Enumeration folders = incdPrefs.getFolders();
        while (folders.hasMoreElements()) {
            String folder = (String)folders.nextElement();
            attribs = incdPrefs.getFolderAttributeNames();
            while (attribs.hasMoreElements()) {
                attrib = (String)attribs.nextElement();
                userValue = userPrefs.getDefinedFolderAttributeValue(folder, attrib);
                incdValue = incdPrefs.getDefinedFolderAttributeValue(folder, attrib);
                if (incdValue != null) {
                    userPrefs.setIncorporatedFolderAttributeValue(folder, attrib, incdValue);
                }
                if (incdValue == null || userValue == null || !incdValue.equals(userValue)) continue;
                userPrefs.removeDefinedFolderAttributeValue(folder, attrib);
                EditManager.removePreferenceDirective(person, folder, attrib);
            }
        }
    }

    private String showFolderAttribs(StructureStylesheetUserPreferences ssup) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("\n*** Folder Attributes");
        Enumeration folders = ssup.getFolders();
        while (folders.hasMoreElements()) {
            String folder = (String)folders.nextElement();
            Enumeration attribs = ssup.getFolderAttributeNames();
            while (attribs.hasMoreElements()) {
                String attrib = (String)attribs.nextElement();
                String val = ssup.getFolderAttributeValue(folder, attrib);
                String defVal = ssup.getDefinedFolderAttributeValue(folder, attrib);
                pw.println((val != null ? "> " : "  ") + folder + "." + attrib + " = (" + defVal + ") " + (val != null ? val : ""));
            }
        }
        pw.close();
        return sw.toString();
    }

    private String showChannelAttribs(ThemeStylesheetUserPreferences tsup) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("\n*** Channel Attributes");
        Enumeration channels = tsup.getChannels();
        while (channels.hasMoreElements()) {
            String channel = (String)channels.nextElement();
            Enumeration attribs = tsup.getChannelAttributeNames();
            while (attribs.hasMoreElements()) {
                String attrib = (String)attribs.nextElement();
                String val = tsup.getChannelAttributeValue(channel, attrib);
                String defVal = tsup.getDefinedChannelAttributeValue(channel, attrib);
                pw.println((val != null ? "> " : "  ") + channel + "." + attrib + " = (" + defVal + ") " + (val != null ? val : ""));
            }
        }
        pw.close();
        return sw.toString();
    }

    private void updateFragmentSSUP(IPerson person, DistributedUserPreferences ssup) {
        FragmentDefinition ownedFragment = this.getOwnedFragment(person);
        if (ownedFragment == null) {
            return;
        }
        FragmentActivator activator = this.getFragmentActivator();
        try {
            UserProfile profile = this.getUserProfileByFname(person, "default");
            ssup = new DistributedUserPreferences((StructureStylesheetUserPreferences)ssup);
            UserView userView = activator.getUserView(ownedFragment);
            UserView view = new UserView(userView.getUserId(), profile, userView.layout, ssup, userView.themeUserPrefs);
            activator.fragmentizeSSUP(view, ownedFragment);
            activator.setUserView(ownedFragment.getOwnerId(), view);
        }
        catch (Exception e) {
            LOG.error((Object)" *** Error - DLM unable to update fragment prefs:  \n\n", (Throwable)e);
        }
    }

    private String getPlfId(org.w3c.dom.Document PLF, String incdId) {
        Element element = null;
        try {
            XPathFactory fac = XPathFactory.newInstance();
            XPath xp = fac.newXPath();
            element = (Element)xp.evaluate("//*[@ID = '" + incdId + "']", PLF, XPathConstants.NODE);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        if (element == null) {
            this.log.warn((Object)("The specified folderId was not found in the user's PLF:  " + incdId));
            return null;
        }
        Attr attr = element.getAttributeNode("dlm:plfID");
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    protected Element getStructure(org.w3c.dom.Document doc, LayoutStructure ls) throws Exception {
        String prefix;
        Element structure = null;
        String type = ls.getType();
        if (type != null && type.startsWith("cp:")) {
            type = "dlm:" + type.substring("cp:".length());
        }
        if (ls.isChannel()) {
            IChannelDefinition channelDef = this.channelRegistryStore.getChannelDefinition(ls.getChanId());
            if (channelDef != null && RDBMDistributedLayoutStore.channelApproved(channelDef.getApprovalDate())) {
                if (localeAware) {
                    channelDef.setLocale(ls.getLocale());
                }
                structure = channelDef.getDocument(doc, "n" + ls.getStructId());
            } else {
                String missingChannel = "Unknown";
                if (channelDef != null) {
                    missingChannel = channelDef.getName();
                }
                structure = MissingChannelDefinition.INSTANCE.getDocument(doc, "n" + ls.getStructId(), "The '" + missingChannel + "' channel is no longer available. " + "Please remove it from your layout.", ErrorCode.CHANNEL_MISSING_EXCEPTION.getCode());
            }
        } else {
            structure = type != null && type.startsWith("dlm:") ? doc.createElementNS("http://www.uportal.org/layout/dlm", type) : doc.createElement("folder");
            structure.setAttribute("name", ls.getName());
            structure.setAttribute("type", type != null ? type : "regular");
        }
        structure.setAttribute("hidden", ls.isHidden() ? "true" : "false");
        structure.setAttribute("immutable", ls.isImmutable() ? "true" : "false");
        structure.setAttribute("unremovable", ls.isUnremovable() ? "true" : "false");
        if (localeAware) {
            structure.setAttribute("locale", ls.getLocale());
        }
        if (ls.getParameters() != null) {
            Iterator itr = ls.getParameters().iterator();
            block0: while (itr.hasNext()) {
                StructureParameter sp = (StructureParameter)itr.next();
                String pName = sp.getName();
                if (pName.startsWith("cp:")) {
                    pName = "dlm:" + sp.getName().substring("cp:".length());
                }
                if (!ls.isChannel()) {
                    if (pName.startsWith("dlm:")) {
                        structure.setAttributeNS("http://www.uportal.org/layout/dlm", pName, sp.getValue());
                        continue;
                    }
                    structure.setAttribute(pName, sp.getValue());
                    continue;
                }
                if (pName.startsWith("dlm:")) {
                    structure.setAttributeNS("http://www.uportal.org/layout/dlm", pName, sp.getValue());
                    itr.remove();
                    continue;
                }
                NodeList nodeListParameters = structure.getElementsByTagName("parameter");
                for (int j = 0; j < nodeListParameters.getLength(); ++j) {
                    Element parmElement = (Element)nodeListParameters.item(j);
                    NamedNodeMap nm = parmElement.getAttributes();
                    String nodeName = nm.getNamedItem("name").getNodeValue();
                    if (!nodeName.equals(pName)) continue;
                    org.w3c.dom.Node override = nm.getNamedItem("override");
                    if (override != null && override.getNodeValue().equals("yes")) {
                        org.w3c.dom.Node valueNode = nm.getNamedItem("value");
                        valueNode.setNodeValue(sp.getValue());
                    }
                    itr.remove();
                    continue block0;
                }
            }
            if (ls.isChannel()) {
                for (StructureParameter sp : ls.getParameters()) {
                    Element parameter = doc.createElement("parameter");
                    parameter.setAttribute("name", sp.getName());
                    parameter.setAttribute("value", sp.getValue());
                    parameter.setAttribute("override", "yes");
                    structure.appendChild(parameter);
                }
            }
        }
        String origin = structure.getAttribute("dlm:origin");
        String string = prefix = ls.isChannel() ? "n" : "s";
        if (!origin.equals("")) {
            structure.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:plfID", prefix + ls.getStructId());
            structure.setAttribute("ID", origin);
        } else if (!ls.isChannel()) {
            if (type != null && type.startsWith("dlm:")) {
                structure.setAttribute("ID", "d" + ls.getStructId());
            } else {
                structure.setAttribute("ID", "s" + ls.getStructId());
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding identifier s" + ls.getStructId()));
            }
            structure.setAttribute("ID", "n" + ls.getStructId());
        }
        structure.setIdAttribute("ID", true);
        return structure;
    }

    @Override
    protected int saveStructure(org.w3c.dom.Node node, PreparedStatement structStmt, PreparedStatement parmStmt) throws Exception {
        if (node == null) {
            return 0;
        }
        if (node.getNodeName().equals("parameter")) {
            return this.saveStructure(node.getNextSibling(), structStmt, parmStmt);
        }
        Element structure = (Element)node;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveStructure XML content: " + XML.serializeNode(node)));
        }
        int saveStructId = -1;
        String plfID = structure.getAttribute("dlm:plfID");
        saveStructId = !plfID.equals("") ? Integer.parseInt(plfID.substring(1)) : Integer.parseInt(structure.getAttribute("ID").substring(1));
        int nextStructId = 0;
        int childStructId = 0;
        int chanId = -1;
        boolean isChannel = node.getNodeName().equals("channel");
        if (node.hasChildNodes()) {
            childStructId = this.saveStructure(node.getFirstChild(), structStmt, parmStmt);
        }
        nextStructId = this.saveStructure(node.getNextSibling(), structStmt, parmStmt);
        structStmt.clearParameters();
        structStmt.setInt(1, saveStructId);
        structStmt.setInt(2, nextStructId);
        structStmt.setInt(3, childStructId);
        String externalId = structure.getAttribute("external_id");
        if (externalId != null && externalId.trim().length() > 0) {
            Integer eID = new Integer(externalId);
            structStmt.setInt(4, eID);
        } else {
            structStmt.setNull(4, 2);
        }
        if (isChannel) {
            chanId = Integer.parseInt(node.getAttributes().getNamedItem("chanID").getNodeValue());
            structStmt.setInt(5, chanId);
            structStmt.setNull(6, 12);
        } else {
            structStmt.setNull(5, 2);
            structStmt.setString(6, structure.getAttribute("name"));
        }
        String structType = structure.getAttribute("type");
        structStmt.setString(7, structType);
        structStmt.setString(8, RDBMServices.dbFlag(RDBMDistributedLayoutStore.xmlBool(structure.getAttribute("hidden"))));
        structStmt.setString(9, RDBMServices.dbFlag(RDBMDistributedLayoutStore.xmlBool(structure.getAttribute("immutable"))));
        structStmt.setString(10, RDBMServices.dbFlag(RDBMDistributedLayoutStore.xmlBool(structure.getAttribute("unremovable"))));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)structStmt.toString());
        }
        structStmt.executeUpdate();
        NamedNodeMap attribs = node.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            org.w3c.dom.Node attrib = attribs.item(i);
            String name = attrib.getNodeName();
            if (!name.startsWith("dlm:") || name.equals("dlm:plfID") || name.equals("dlm:fragment") || name.equals("dlm:precedence")) continue;
            parmStmt.clearParameters();
            parmStmt.setInt(1, saveStructId);
            parmStmt.setString(2, name);
            parmStmt.setString(3, attrib.getNodeValue());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)parmStmt.toString());
            }
            parmStmt.executeUpdate();
        }
        NodeList parameters = node.getChildNodes();
        if (parameters != null && isChannel) {
            IChannelDefinition channelDef = this.channelRegistryStore.getChannelDefinition(chanId);
            for (int i = 0; i < parameters.getLength(); ++i) {
                IChannelParameter cp;
                if (!parameters.item(i).getNodeName().equals("parameter")) continue;
                Element parmElement = (Element)parameters.item(i);
                NamedNodeMap nm = parmElement.getAttributes();
                String parmName = nm.getNamedItem("name").getNodeValue();
                String parmValue = nm.getNamedItem("value").getNodeValue();
                org.w3c.dom.Node override = nm.getNamedItem("override");
                if (override != null && !override.getNodeValue().equals("yes") || (cp = channelDef.getParameter(parmName)) != null && cp.getValue().equals(parmValue)) continue;
                parmStmt.clearParameters();
                parmStmt.setInt(1, saveStructId);
                parmStmt.setString(2, parmName);
                parmStmt.setString(3, parmValue);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)parmStmt);
                }
                parmStmt.executeUpdate();
            }
        }
        return saveStructId;
    }

    public static org.w3c.dom.Document getPLF(IPerson person) throws PortalException {
        try {
            return (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        }
        catch (Exception ex) {
            throw new PortalException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStructureStylesheetUserPreferences(IPerson person, int profileId, StructureStylesheetUserPreferences ssup) throws Exception {
        DistributedUserPreferences dssup = (DistributedUserPreferences)ssup;
        int userId = person.getID();
        org.w3c.dom.Document PLF = (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        if (PLF == null) {
            throw new Exception("Unable to obtain user's PLF to translate incorporated ids to plfIds.");
        }
        int stylesheetId = ssup.getStylesheetId();
        StructureStylesheetDescription ssDesc = this.getStructureStylesheetDescription(stylesheetId);
        Connection con = RDBMServices.getConnection();
        try {
            con.setAutoCommit(false);
            try {
                String deflt;
                String pValue;
                String pName;
                Enumeration attre;
                String plfId;
                RDBMDistributedLayoutStore.deleteFromUpSsUserParm(con, userId, profileId, stylesheetId, 1);
                Enumeration e = ssup.getParameterValues().keys();
                while (e.hasMoreElements()) {
                    String pName2 = e.nextElement();
                    if (!ssDesc.containsParameterName(pName2) || ssDesc.getStylesheetParameterDefaultValue(pName2).equals(ssup.getParameterValue(pName2))) continue;
                    String sQuery = "INSERT INTO UP_SS_USER_PARM (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,PARAM_NAME,PARAM_VAL) VALUES (?,?,?,1,?,?)";
                    PreparedStatement pstmt2 = con.prepareStatement(sQuery);
                    try {
                        pstmt2.setInt(1, userId);
                        pstmt2.setInt(2, profileId);
                        pstmt2.setInt(3, stylesheetId);
                        pstmt2.setString(4, pName2);
                        pstmt2.setString(5, ssup.getParameterValue(pName2));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)sQuery);
                        }
                        pstmt2.executeUpdate();
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(pstmt2);
                    }
                }
                RDBMDistributedLayoutStore.deleteFromUpSsUserAtts(con, userId, profileId, stylesheetId, 1);
                e = ssup.getFolders();
                while (e.hasMoreElements()) {
                    String folderId;
                    plfId = folderId = (String)e.nextElement();
                    if (folderId.startsWith("u")) {
                        plfId = this.getPlfId(PLF, folderId);
                    }
                    if (plfId == null) {
                        this.log.warn((Object)("Unable to translate the specified folderId to a folder on the PLF:  " + folderId));
                        continue;
                    }
                    attre = ssup.getFolderAttributeNames();
                    while (attre.hasMoreElements()) {
                        pName = (String)attre.nextElement();
                        pValue = ssup.getDefinedFolderAttributeValue(folderId, pName);
                        if (!ssDesc.containsFolderAttribute(pName)) continue;
                        deflt = dssup.getDefaultFolderAttributeValue(folderId, pName);
                        if (pValue == null || deflt != null && pValue.equals(deflt)) continue;
                        RDBMDistributedLayoutStore.insertIntoUpSsUserAtts(con, userId, profileId, stylesheetId, 1, plfId, 2, pName, pValue);
                    }
                }
                e = ssup.getChannels();
                while (e.hasMoreElements()) {
                    String channelId = (String)e.nextElement();
                    plfId = channelId;
                    if (plfId.startsWith("u")) {
                        plfId = this.getPlfId(PLF, channelId);
                    }
                    if (plfId == null) continue;
                    attre = ssup.getChannelAttributeNames();
                    while (attre.hasMoreElements()) {
                        pName = (String)attre.nextElement();
                        pValue = ssup.getDefinedChannelAttributeValue(channelId, pName);
                        if (!ssDesc.containsChannelAttribute(pName)) continue;
                        deflt = dssup.getDefaultChannelAttributeValue(channelId, pName);
                        if (pValue == null || deflt != null && pValue.equals(deflt)) continue;
                        RDBMDistributedLayoutStore.insertIntoUpSsUserAtts(con, userId, profileId, stylesheetId, 1, plfId, 3, pName, pValue);
                    }
                }
                RDBMServices.commit(con);
                if (this.fragmentActivatorCreator.isCreated()) {
                    this.updateFragmentSSUP(person, (DistributedUserPreferences)ssup);
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Problem occurred ", (Throwable)e);
                }
                RDBMServices.rollback(con);
                throw new Exception("Exception setting Structure Sylesheet User Preferences", e);
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThemeStylesheetUserPreferences(IPerson person, int profileId, ThemeStylesheetUserPreferences tsup) throws Exception {
        DistributedUserPreferences dtsup = (DistributedUserPreferences)tsup;
        int userId = person.getID();
        org.w3c.dom.Document PLF = (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        if (PLF == null) {
            throw new Exception("Unable to obtain user's PLF to translate incorporated ids to plfIds.");
        }
        int stylesheetId = tsup.getStylesheetId();
        ThemeStylesheetDescription tsDesc = this.getThemeStylesheetDescription(stylesheetId);
        Connection con = RDBMServices.getConnection();
        try {
            con.setAutoCommit(false);
            try {
                RDBMDistributedLayoutStore.deleteFromUpSsUserParm(con, userId, profileId, stylesheetId, 2);
                Enumeration e = tsup.getParameterValues().keys();
                while (e.hasMoreElements()) {
                    String pName = e.nextElement();
                    if (!tsDesc.containsParameterName(pName) || tsDesc.getStylesheetParameterDefaultValue(pName).equals(tsup.getParameterValue(pName))) continue;
                    String sQuery = "INSERT INTO UP_SS_USER_PARM (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,PARAM_NAME,PARAM_VAL) VALUES (?,?,?,2,?,?)";
                    PreparedStatement pstmt2 = con.prepareStatement(sQuery);
                    try {
                        pstmt2.setInt(1, userId);
                        pstmt2.setInt(2, profileId);
                        pstmt2.setInt(3, stylesheetId);
                        pstmt2.setString(4, pName);
                        pstmt2.setString(5, tsup.getParameterValue(pName));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(sQuery + "VALUE " + userId + "," + profileId + "," + stylesheetId + "," + pName + "," + tsup.getParameterValue(pName)));
                        }
                        pstmt2.executeUpdate();
                    }
                    finally {
                        RDBMDistributedLayoutStore.close(pstmt2);
                    }
                }
                RDBMDistributedLayoutStore.deleteFromUpSsUserAtts(con, userId, profileId, stylesheetId, 2);
                e = tsup.getChannels();
                while (e.hasMoreElements()) {
                    String channelId = (String)e.nextElement();
                    String plfChannelId = channelId;
                    if (plfChannelId.startsWith("u")) {
                        plfChannelId = this.getPlfId(PLF, channelId);
                    }
                    if (plfChannelId == null) continue;
                    Enumeration attre = tsup.getChannelAttributeNames();
                    while (attre.hasMoreElements()) {
                        String pName = (String)attre.nextElement();
                        String pValue = tsup.getDefinedChannelAttributeValue(channelId, pName);
                        if (!tsDesc.containsChannelAttribute(pName)) continue;
                        String deflt = dtsup.getDefaultChannelAttributeValue(channelId, pName);
                        if (pValue == null || deflt != null && pValue.equals(deflt)) continue;
                        RDBMDistributedLayoutStore.insertIntoUpSsUserAtts(con, userId, profileId, stylesheetId, 2, plfChannelId, 3, pName, pValue);
                    }
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw new Exception("Exception setting Theme Sylesheet User Preferences", e);
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertIntoUpSsUserAtts(Connection con, int userId, int profileId, int stylesheetId, int stylesheetType, String nodeId, int parmType, String parmName, String parmValue) throws SQLException {
        int structId = Integer.parseInt(nodeId.substring(1));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_TYPE,PARAM_NAME,PARAM_VAL) VALUES (?,?,?,?,?,?,?,?): with values USER_ID=" + userId + ", PROFILE_ID=" + profileId + ", SS_ID=" + stylesheetId + ", SS_TYPE=" + stylesheetType + ", STRUCT_ID=" + structId + ", PARAM_TYPE=" + parmType + ", PARAM_NAME=" + parmName + ", PARAM_VAL=" + parmValue));
        }
        PreparedStatement pstmt = con.prepareStatement(INSERT__INTO__UP_SS_USER_ATTS);
        try {
            pstmt.setInt(1, userId);
            pstmt.setInt(2, profileId);
            pstmt.setInt(3, stylesheetId);
            pstmt.setInt(4, stylesheetType);
            pstmt.setInt(5, structId);
            pstmt.setInt(6, parmType);
            pstmt.setString(7, parmName);
            pstmt.setString(8, parmValue);
            pstmt.execute();
        }
        finally {
            RDBMDistributedLayoutStore.close(pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFromUpSsUserParm(Connection con, int userId, int profileId, int stylesheetId, int stylesheetType) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE FROM UP_SS_USER_PARM WHERE USER_ID=?  AND PROFILE_ID=? AND SS_ID=? AND SS_TYPE=? VALUES = " + userId + "," + profileId + "," + stylesheetId + "," + stylesheetType));
        }
        PreparedStatement pstmt = con.prepareStatement(DELETE_FROM_UP_USER_PARM);
        try {
            pstmt.setInt(1, userId);
            pstmt.setInt(2, profileId);
            pstmt.setInt(3, stylesheetId);
            pstmt.setInt(4, stylesheetType);
            pstmt.executeUpdate();
        }
        finally {
            RDBMDistributedLayoutStore.close(pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFromUpSsUserAtts(Connection con, int userId, int profileId, int stylesheetId, int stylesheetType) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE FROM UP_SS_USER_ATTS WHERE USER_ID = ? AND PROFILE_ID = ? AND SS_ID = ? AND SS_TYPE = ? VALUES = " + userId + "," + profileId + "," + stylesheetId + "," + stylesheetType));
        }
        PreparedStatement pstmt = con.prepareStatement(DELETE_FROM_UP_SS_USER_ATTS_SQL);
        try {
            pstmt.setInt(1, userId);
            pstmt.setInt(2, profileId);
            pstmt.setInt(3, stylesheetId);
            pstmt.setInt(4, stylesheetType);
            pstmt.executeUpdate();
        }
        finally {
            RDBMDistributedLayoutStore.close(pstmt);
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException e) {
            LOG.warn((Object)"failed to close resultset", (Throwable)e);
        }
    }

    private static void close(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            LOG.warn((Object)"failed to close statement", (Throwable)e);
        }
    }

    private static void rollback(Connection con) {
        LOG.warn((Object)"problem encountered, attempting to roll back");
        boolean goodRollBack = true;
        try {
            con.rollback();
        }
        catch (SQLException e) {
            goodRollBack = false;
        }
        if (goodRollBack) {
            LOG.info((Object)"rollback successful");
        } else {
            LOG.warn((Object)"rollback failed!");
        }
    }

    private static final class MissingChannelDefinition
    extends XmlGeneratingBaseChannelDefinition {
        public static final IChannelDefinition INSTANCE = new MissingChannelDefinition();

        private MissingChannelDefinition() {
        }

        @Override
        public String getName() {
            return "Missing channel";
        }

        @Override
        public String getName(String locale) {
            return "Missing channel";
        }

        @Override
        public int getTimeout() {
            return 20000;
        }

        @Override
        public String getTitle() {
            return "Missing channel";
        }

        @Override
        public String getTitle(String locale) {
            return "Missing channel";
        }

        @Override
        public String getFName() {
            return "DLMStaticMissingChannel";
        }

        @Override
        public void addLocalizedDescription(String locale, String chanDesc) {
        }

        @Override
        public void addLocalizedName(String locale, String chanName) {
        }

        @Override
        public void addLocalizedTitle(String locale, String chanTitle) {
        }

        @Override
        public void addParameter(IChannelParameter parameter) {
        }

        @Override
        public void addParameter(String name, String value, boolean override) {
        }

        @Override
        @Deprecated
        public void addParameter(String name, String value, String override) {
        }

        @Override
        public void clearParameters() {
        }

        @Override
        public Date getApprovalDate() {
            return null;
        }

        @Override
        public int getApproverId() {
            return 0;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getDescription(String locale) {
            return null;
        }

        @Override
        public EntityIdentifier getEntityIdentifier() {
            return null;
        }

        @Override
        public Date getExpirationDate() {
            return null;
        }

        @Override
        public int getExpirerId() {
            return 0;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public String getJavaClass() {
            return null;
        }

        @Override
        public String getLocale() {
            return null;
        }

        @Override
        public IChannelParameter getParameter(String key) {
            return null;
        }

        @Override
        public Set<IChannelParameter> getParameters() {
            return null;
        }

        @Override
        public Map<String, IChannelParameter> getParametersAsUnmodifiableMap() {
            return null;
        }

        public IPortletPreference[] getPortletPreferences() {
            return null;
        }

        @Override
        public Date getPublishDate() {
            return null;
        }

        @Override
        public int getPublisherId() {
            return 0;
        }

        @Override
        @Deprecated
        public int getTypeId() {
            return 0;
        }

        @Override
        public boolean hasAbout() {
            return false;
        }

        @Override
        public boolean hasHelp() {
            return false;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public boolean isPortlet() {
            return false;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        public IPortletDefinition getPortletDefinition() {
            return null;
        }

        @Override
        public void removeParameter(IChannelParameter parameter) {
        }

        @Override
        public void removeParameter(String name) {
        }

        @Override
        public void replaceParameters(Set<IChannelParameter> parameters) {
        }

        public void replacePortletPreference(List<IPortletPreference> portletPreferences) {
        }

        @Override
        public void setApprovalDate(Date approvalDate) {
        }

        @Override
        public void setApproverId(int approvalId) {
        }

        @Override
        public void setDescription(String descr) {
        }

        @Override
        public void setEditable(boolean editable) {
        }

        @Override
        public void setExpirationDate(Date expirationDate) {
        }

        @Override
        public void setExpirerId(int expirerId) {
        }

        @Override
        public void setFName(String fname) {
        }

        @Override
        public void setHasAbout(boolean hasAbout) {
        }

        @Override
        public void setHasHelp(boolean hasHelp) {
        }

        @Override
        public void setIsSecure(boolean isSecure) {
        }

        @Override
        public void setJavaClass(String javaClass) {
        }

        @Override
        public void setLocale(String locale) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setParameters(Set<IChannelParameter> parameters) {
        }

        @Override
        public void setPublishDate(Date publishDate) {
        }

        @Override
        public void setPublisherId(int publisherId) {
        }

        @Override
        public void setTimeout(int timeout) {
        }

        @Override
        public void setTitle(String title) {
        }

        @Override
        public IChannelType getType() {
            return null;
        }

        @Override
        public void setType(IChannelType channelType) {
        }

        @Override
        public ChannelLifecycleState getLifecycleState() {
            return null;
        }
    }
}

