/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.UserAttributeDD;
import org.apache.pluto.internal.InternalPortletRequest;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.spi.optional.UserInfoService;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.cas.CasProxyTicketAcquisitionException;
import org.jasig.portal.security.provider.cas.ICasSecurityContext;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;

public class CasTicketUserInfoService
implements UserInfoService {
    private IUserInstanceManager userInstanceManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    protected final Log log = LogFactory.getLog(this.getClass());
    private String proxyTicketKey = "casProxyTicket";

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public String getProxyTicketKey() {
        return this.proxyTicketKey;
    }

    public void setProxyTicketKey(String proxyTicketKey) {
        this.proxyTicketKey = proxyTicketKey;
    }

    @Deprecated
    public Map getUserInfo(PortletRequest request) throws PortletContainerException {
        if (!(request instanceof InternalPortletRequest)) {
            throw new IllegalArgumentException("The CasTicketUserInfoServices requires the PortletRequest parameter to implement the '" + InternalPortletRequest.class.getName() + "' interface.");
        }
        InternalPortletRequest internalRequest = (InternalPortletRequest)request;
        InternalPortletWindow internalPortletWindow = internalRequest.getInternalPortletWindow();
        return this.getUserInfo(request, (PortletWindow)internalPortletWindow);
    }

    public Map getUserInfo(PortletRequest request, PortletWindow portletWindow) throws PortletContainerException {
        String proxyTicket;
        HashMap<String, String> userInfo = new HashMap<String, String>();
        if (this.isCasProxyTicketRequested(request, portletWindow) && (proxyTicket = this.getProxyTicket(request)) != null) {
            userInfo.put(this.proxyTicketKey, proxyTicket);
        }
        return userInfo;
    }

    public boolean isCasProxyTicketRequested(PortletRequest request, PortletWindow plutoPortletWindow) throws PortletContainerException {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        PortletAppDD portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        List requestedUserAttributes = portletApplicationDescriptor.getUserAttributes();
        for (UserAttributeDD userAttributeDD : requestedUserAttributes) {
            String attributeName = userAttributeDD.getName();
            if (!attributeName.equals(this.proxyTicketKey)) continue;
            return true;
        }
        return false;
    }

    private String getProxyTicket(PortletRequest request) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
        String targetService = null;
        try {
            URL url = null;
            int port = request.getServerPort();
            url = port == 80 || port == 443 ? new URL(request.getScheme(), request.getServerName(), request.getContextPath()) : new URL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
            targetService = url.toString();
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"Failed to create a URL for the target portlet", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(httpServletRequest);
        IPerson person = userInstance.getPerson();
        ISecurityContext context = person.getSecurityContext();
        if (context == null) {
            this.log.error((Object)"no security context, no proxy ticket passed to the portlet");
            return null;
        }
        ISecurityContext casContext = CasTicketUserInfoService.getCasContext(context);
        if (casContext == null) {
            this.log.debug((Object)"no CAS security context, no proxy ticket passed to the portlet");
            return null;
        }
        if (!casContext.isAuthenticated()) {
            this.log.debug((Object)"no CAS authentication, no proxy ticket passed to the portlet");
            return null;
        }
        String proxyTicket = null;
        try {
            proxyTicket = ((ICasSecurityContext)((Object)casContext)).getCasServiceToken(targetService);
            this.log.debug((Object)("Put proxy ticket in userinfo: " + proxyTicket));
        }
        catch (CasProxyTicketAcquisitionException e) {
            this.log.error((Object)("no proxy ticket passed to the portlet: " + e));
        }
        return proxyTicket;
    }

    private static ISecurityContext getCasContext(ISecurityContext context) {
        if (context instanceof ICasSecurityContext) {
            return context;
        }
        Enumeration contextEnum = context.getSubContexts();
        while (contextEnum.hasMoreElements()) {
            ISecurityContext subContext = (ISecurityContext)contextEnum.nextElement();
            if (!(subContext instanceof ICasSecurityContext)) continue;
            return subContext;
        }
        return null;
    }
}

