/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.core.DefaultRequestAttributeService;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.UserAttributeDD;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;

public class RequestAttributeServiceImpl
extends DefaultRequestAttributeService {
    private IPersonAttributeDao personAttributeDao;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;

    public void setPersonAttributeDao(IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public Object getAttribute(PortletRequest portletRequest, HttpServletRequest httpServletRequest, PortletWindow plutoPortletWindow, String name) {
        if ("org.jasig.portlet.USER_INFO_MULTIVALUED".equals(name)) {
            httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
            String remoteUser = portletRequest.getRemoteUser();
            if (remoteUser == null) {
                return null;
            }
            IPersonAttributes personAttributes = this.personAttributeDao.getPerson(remoteUser);
            if (personAttributes == null) {
                return Collections.emptyMap();
            }
            IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
            List<UserAttributeDD> expectedUserAttributes = this.getExpectedUserAttributes(httpServletRequest, portletWindow);
            HashMap<String, List> portletMultivaluedAttributes = new HashMap<String, List>(expectedUserAttributes.size());
            Map attributes = personAttributes.getAttributes();
            for (UserAttributeDD userAttributeDD : expectedUserAttributes) {
                String attributeName = userAttributeDD.getName();
                if (!attributes.containsKey(attributeName)) continue;
                List list_valueObjs = (List)attributes.get(attributeName);
                portletMultivaluedAttributes.put(attributeName, list_valueObjs);
            }
            return Collections.unmodifiableMap(portletMultivaluedAttributes);
        }
        return super.getAttribute(portletRequest, httpServletRequest, plutoPortletWindow, name);
    }

    public Enumeration getAttributeNames(PortletRequest portletRequest, HttpServletRequest httpServletRequest, PortletWindow portletWindow) {
        Enumeration attributeNamesEnum = super.getAttributeNames(portletRequest, httpServletRequest, portletWindow);
        String remoteUser = portletRequest.getRemoteUser();
        if (remoteUser == null) {
            return attributeNamesEnum;
        }
        List attributeNames = EnumerationUtils.toList((Enumeration)attributeNamesEnum);
        attributeNames.add("org.jasig.portlet.USER_INFO_MULTIVALUED");
        return new IteratorEnumeration(attributeNames.iterator());
    }

    protected List<UserAttributeDD> getExpectedUserAttributes(HttpServletRequest request, IPortletWindow portletWindow) {
        PortletAppDD portletApplicationDescriptor;
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(request, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        try {
            portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        }
        catch (PortletContainerException e) {
            throw new RuntimeException(e);
        }
        return portletApplicationDescriptor.getUserAttributes();
    }
}

