/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.dao.jpa.ChannelDefinitionImpl;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionIdImpl;
import org.jasig.portal.portlet.dao.jpa.PortletEntityImpl;
import org.jasig.portal.portlet.dao.jpa.PortletPreferencesImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletPreferences;

@Entity
@Table(name="UP_PORTLET_DEF")
@GenericGenerator(name="UP_PORTLET_DEF_GEN", strategy="native", parameters={@Parameter(name="sequence", value="UP_PORTLET_DEF_SEQ"), @Parameter(name="table", value="UP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_UP_PORTLET_DEF_HI")})
public class PortletDefinitionImpl
implements IPortletDefinition {
    @Id
    @GeneratedValue(generator="UP_PORTLET_DEF_GEN")
    @Column(name="PORTLET_DEF_ID")
    private final long internalPortletDefinitionId;
    @OneToOne(targetEntity=ChannelDefinitionImpl.class)
    @JoinColumn(name="CHANNEL_DEF_ID", nullable=false, updatable=false, unique=true)
    private final IChannelDefinition channelDefinition;
    @OneToMany(mappedBy="portletDefinition", targetEntity=PortletEntityImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<IPortletEntity> portletEntities = null;
    @OneToOne(targetEntity=PortletPreferencesImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PORTLET_PREFS_ID", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private IPortletPreferences portletPreferences = null;
    @Transient
    private IPortletDefinitionId portletDefinitionId = null;

    @PostLoad
    @PostPersist
    @PostUpdate
    @PostRemove
    private void init() {
        this.portletDefinitionId = new PortletDefinitionIdImpl(this.internalPortletDefinitionId);
    }

    private PortletDefinitionImpl() {
        this.internalPortletDefinitionId = -1L;
        this.channelDefinition = null;
        this.portletPreferences = null;
    }

    public PortletDefinitionImpl(ChannelDefinitionImpl channelDefinition) {
        this.internalPortletDefinitionId = -1L;
        this.channelDefinition = channelDefinition;
        this.portletPreferences = new PortletPreferencesImpl();
    }

    @Override
    public IPortletDefinitionId getPortletDefinitionId() {
        return this.portletDefinitionId;
    }

    @Override
    public IChannelDefinition getChannelDefinition() {
        return this.channelDefinition;
    }

    @Override
    public IPortletPreferences getPortletPreferences() {
        return this.portletPreferences;
    }

    @Override
    public void setPortletPreferences(IPortletPreferences portletPreferences) {
        Validate.notNull((Object)portletPreferences, (String)"portletPreferences can not be null");
        this.portletPreferences = portletPreferences;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPortletDefinition)) {
            return false;
        }
        IPortletDefinition rhs = (IPortletDefinition)object;
        return new EqualsBuilder().append(this.channelDefinition.getId(), rhs.getChannelDefinition().getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(464270933, -1074792143).append(this.channelDefinition.getId()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("portletDefinitionId", (Object)this.portletDefinitionId).append("channelDefinitionId", this.channelDefinition.getId()).toString();
    }
}

