/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.trans;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.trans.TransientPortletEntity;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;

public class TransientPortletEntityDao
implements IPortletEntityDao {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletEntityDao delegatePortletEntityDao;
    private IUserInstanceManager userInstanceManager;
    private IPortalRequestUtils portalRequestUtils;

    public IPortletEntityDao getDelegatePortletEntityDao() {
        return this.delegatePortletEntityDao;
    }

    @Required
    public void setDelegatePortletEntityDao(IPortletEntityDao delegatePortletEntityDao) {
        this.delegatePortletEntityDao = delegatePortletEntityDao;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Override
    public IPortletEntity createPortletEntity(IPortletDefinitionId portletDefinitionId, String channelSubscribeId, int userId) {
        if (channelSubscribeId.startsWith("ctf")) {
            String transientChannelSubscribeId = channelSubscribeId;
            channelSubscribeId = this.getDatabaseChannelSubscribeId(portletDefinitionId);
            IPortletEntity portletEntity = this.delegatePortletEntityDao.createPortletEntity(portletDefinitionId, channelSubscribeId, userId);
            return new TransientPortletEntity(portletEntity, transientChannelSubscribeId);
        }
        return this.delegatePortletEntityDao.createPortletEntity(portletDefinitionId, channelSubscribeId, userId);
    }

    @Override
    public void deletePortletEntity(IPortletEntity portletEntity) {
        portletEntity = this.unwrapEntity(portletEntity);
        this.delegatePortletEntityDao.deletePortletEntity(portletEntity);
    }

    @Override
    public Set<IPortletEntity> getPortletEntities(IPortletDefinitionId portletDefinitionId) {
        Set<IPortletEntity> portletEntities = this.delegatePortletEntityDao.getPortletEntities(portletDefinitionId);
        return this.wrapEntities(portletEntities);
    }

    @Override
    public Set<IPortletEntity> getPortletEntitiesForUser(int userId) {
        Set<IPortletEntity> portletEntities = this.delegatePortletEntityDao.getPortletEntitiesForUser(userId);
        return this.wrapEntities(portletEntities);
    }

    @Override
    public IPortletEntity getPortletEntity(IPortletEntityId portletEntityId) {
        IPortletEntity portletEntity = this.delegatePortletEntityDao.getPortletEntity(portletEntityId);
        return this.wrapEntity(portletEntity);
    }

    @Override
    public IPortletEntity getPortletEntity(String channelSubscribeId, int userId) {
        if (channelSubscribeId.startsWith("ctf")) {
            String databaseChannelSubscribeId = this.determineDatabaseChannelSubscribeId(channelSubscribeId);
            IPortletEntity portletEntity = this.delegatePortletEntityDao.getPortletEntity(databaseChannelSubscribeId, userId);
            return this.wrapEntity(portletEntity);
        }
        return this.delegatePortletEntityDao.getPortletEntity(channelSubscribeId, userId);
    }

    @Override
    public void updatePortletEntity(IPortletEntity portletEntity) {
        portletEntity = this.unwrapEntity(portletEntity);
        this.delegatePortletEntityDao.updatePortletEntity(portletEntity);
    }

    protected IPortletEntity unwrapEntity(IPortletEntity portletEntity) {
        if (portletEntity instanceof TransientPortletEntity) {
            return ((TransientPortletEntity)portletEntity).getDelegatePortletEntity();
        }
        return portletEntity;
    }

    protected IPortletEntity wrapEntity(IPortletEntity portletEntity) {
        if (portletEntity == null) {
            return null;
        }
        String databaseChannelSubscribeId = portletEntity.getChannelSubscribeId();
        if (databaseChannelSubscribeId.startsWith("ctf")) {
            IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
            IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
            IChannelDefinition channelDefinition = portletDefinition.getChannelDefinition();
            String fname = channelDefinition.getFName();
            IUserLayoutManager userLayoutManager = this.getUserLayoutManager();
            if (userLayoutManager == null) {
                this.logger.warn((Object)("Could not find IUserLayoutManager when trying to wrap transient portlet entity: " + portletEntity));
                return portletEntity;
            }
            String subscribeId = userLayoutManager.getSubscribeId(fname);
            return new TransientPortletEntity(portletEntity, subscribeId);
        }
        return portletEntity;
    }

    protected Set<IPortletEntity> wrapEntities(Set<IPortletEntity> portletEntities) {
        LinkedHashSet<IPortletEntity> wrappedPortletEntities = new LinkedHashSet<IPortletEntity>(portletEntities.size());
        for (IPortletEntity portletEntity : portletEntities) {
            IPortletEntity wrappedEntity = this.wrapEntity(portletEntity);
            if (wrappedEntity == null) continue;
            wrappedPortletEntities.add(wrappedEntity);
        }
        return wrappedPortletEntities;
    }

    protected String determineDatabaseChannelSubscribeId(String channelSubscribeId) {
        IUserLayoutManager userLayoutManager = this.getUserLayoutManager();
        IUserLayoutChannelDescription channelNode = (IUserLayoutChannelDescription)userLayoutManager.getNode(channelSubscribeId);
        String channelPublishId = channelNode.getChannelPublishId();
        int channelDefinitionId = Integer.valueOf(channelPublishId.startsWith("chan") ? channelPublishId.substring(4) : channelPublishId);
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(channelDefinitionId);
        return this.getDatabaseChannelSubscribeId(portletDefinition.getPortletDefinitionId());
    }

    protected String getDatabaseChannelSubscribeId(IPortletDefinitionId portletDefinitionId) {
        return "ctf." + portletDefinitionId.getStringId();
    }

    protected IUserLayoutManager getUserLayoutManager() {
        HttpServletRequest portalRequest;
        try {
            portalRequest = this.portalRequestUtils.getCurrentPortalRequest();
        }
        catch (IllegalStateException ise) {
            return null;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(portalRequest);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        return preferencesManager.getUserLayoutManager();
    }
}

