/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.spi.optional.PortletInvocationEvent;
import org.apache.pluto.spi.optional.PortletInvocationListener;
import org.jasig.portal.spring.web.context.support.HttpSessionDestroyedEvent;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.web.util.WebUtils;

public class PortletSessionExpirationManager
implements PortletInvocationListener,
ApplicationListener {
    public static final String PORTLET_SESSIONS_MAP = PortletSessionExpirationManager.class.getName() + ".PORTLET_SESSIONS";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnd(PortletInvocationEvent event) {
        PortletRequest portletRequest = event.getPortletRequest();
        PortletSession portletSession = portletRequest.getPortletSession(false);
        if (portletSession == null) {
            return;
        }
        HttpServletRequest portalRequest = this.portalRequestUtils.getOriginalPortalRequest(portletRequest);
        HttpSession portalSession = portalRequest.getSession();
        if (portalSession != null) {
            NonSerializableMapHolder<String, PortletSession> portletSessions;
            Object object = WebUtils.getSessionMutex((HttpSession)portalSession);
            synchronized (object) {
                portletSessions = (NonSerializableMapHolder<String, PortletSession>)portalSession.getAttribute(PORTLET_SESSIONS_MAP);
                if (portletSessions == null || !portletSessions.isValid()) {
                    portletSessions = new NonSerializableMapHolder<String, PortletSession>(new ConcurrentHashMap());
                    portalSession.setAttribute(PORTLET_SESSIONS_MAP, portletSessions);
                }
            }
            PortletWindow portletWindow = event.getPortletWindow();
            String contextPath = portletWindow.getContextPath();
            portletSessions.put(contextPath, portletSession);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionDestroyedEvent) {
            HttpSession session = ((HttpSessionDestroyedEvent)event).getSession();
            Map portletSessions = (Map)session.getAttribute(PORTLET_SESSIONS_MAP);
            if (portletSessions == null) {
                return;
            }
            for (Map.Entry portletSessionEntry : portletSessions.entrySet()) {
                String contextPath = (String)portletSessionEntry.getKey();
                PortletSession portletSession = (PortletSession)portletSessionEntry.getValue();
                try {
                    portletSession.invalidate();
                }
                catch (IllegalStateException e) {
                    this.logger.info((Object)("PortletSession with id '" + portletSession.getId() + "' for context '" + contextPath + "' has already been invalidated."));
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to invalidate PortletSession with id '" + portletSession.getId() + "' for context '" + contextPath + "'"), (Throwable)e);
                }
            }
        }
    }

    public void onBegin(PortletInvocationEvent event) {
    }

    public void onError(PortletInvocationEvent event, Throwable t) {
    }

    private static final class NonSerializableMapHolder<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient Map<K, V> delegate;

        public NonSerializableMapHolder(Map<K, V> delegate) {
            this.delegate = delegate;
        }

        public boolean isValid() {
            return this.delegate != null;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.delegate).equals(o);
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public V put(K key, V value) {
            return this.delegate.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            this.delegate.putAll(t);
        }

        @Override
        public V remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Collection<V> values() {
            return this.delegate.values();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

