/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin;

import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.dao.usertype.FunctionalNameType;
import org.jasig.portal.portlets.portletadmin.ChannelDefinitionForm;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDParameter;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDParameterTypeRestriction;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDStep;
import org.jasig.portal.portlets.portletadmin.xmlsupport.ChannelPublishingDefinition;
import org.jasig.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;

public class ChannelDefinitionFormValidator {
    private IChannelPublishingDefinitionDao channelPublishingDefinitionDao;
    private IChannelRegistryStore channelStore;

    public void setChannelPublishingDefinitionDao(IChannelPublishingDefinitionDao channelPublishingDefinitionDao) {
        this.channelPublishingDefinitionDao = channelPublishingDefinitionDao;
    }

    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelStore = channelRegistryStore;
    }

    public void validateChooseType(ChannelDefinitionForm def, MessageContext context) {
        if (def.getTypeId() == 0) {
            context.addMessage(new MessageBuilder().error().source((Object)"typeId").code("errors.channelDefinition.type.empty").defaultText("Please choose a channel type").build());
        }
    }

    public void validateBasicInfo(ChannelDefinitionForm def, MessageContext context) {
        Matcher matcher = FunctionalNameType.VALID_FNAME_PATTERN.matcher(def.getFname());
        if (StringUtils.isEmpty((String)def.getFname())) {
            context.addMessage(new MessageBuilder().error().source((Object)"fName").code("errors.channelDefinition.fName.empty").defaultText("Please enter an fname").build());
        } else if (!matcher.matches()) {
            context.addMessage(new MessageBuilder().error().source((Object)"fName").code("errors.channelDefinition.fName.invalid").defaultText("Fnames may only contain letters, numbers, dashes, and underscores").build());
        } else if (def.getId() == -1 && this.channelStore.getChannelDefinition(def.getFname()) != null) {
            context.addMessage(new MessageBuilder().error().source((Object)"fName").code("errors.channelDefinition.fName.duplicate").defaultText("This fname is already in use").build());
        }
        if (StringUtils.isEmpty((String)def.getTitle())) {
            context.addMessage(new MessageBuilder().error().source((Object)"title").code("errors.channelDefinition.title.empty").defaultText("Please enter a title").build());
        }
        if (StringUtils.isEmpty((String)def.getName())) {
            context.addMessage(new MessageBuilder().error().source((Object)"name").code("errors.channelDefinition.name.empty").defaultText("Please enter a name").build());
        }
        if (def.getId() == -1 && this.channelStore.getChannelDefinitionByName(def.getName()) != null) {
            context.addMessage(new MessageBuilder().error().source((Object)"name").code("errors.channelDefinition.name.duplicate").defaultText("This name is already in use").build());
        }
    }

    public void validateSetParameters(ChannelDefinitionForm def, MessageContext context) {
        ChannelPublishingDefinition cpd = this.channelPublishingDefinitionDao.getChannelPublishingDefinition(def.getTypeId());
        for (CPDStep step : cpd.getParams().getSteps()) {
            if (step.getParameters() == null) continue;
            for (CPDParameter param : step.getParameters()) {
                CPDParameterTypeRestriction restriction;
                if (!def.getParameters().containsKey(param.getName()) || StringUtils.isEmpty((String)def.getParameters().get(param.getName()).getValue())) continue;
                String paramValue = def.getParameters().get(param.getName()).getValue();
                String paramPath = "parameters['" + param.getName() + "'].value";
                String base = param.getType().getBase();
                if ("integer".equals(base)) {
                    try {
                        Integer.parseInt(paramValue);
                    }
                    catch (NumberFormatException e) {
                        context.addMessage(new MessageBuilder().error().source((Object)paramPath).code("errors.channelDefinition.param.int").defaultText("Value must be an integer").build());
                    }
                } else if ("float".equals(base)) {
                    try {
                        Float.parseFloat(paramValue);
                    }
                    catch (NumberFormatException e) {
                        context.addMessage(new MessageBuilder().error().source((Object)paramPath).code("errors.channelDefinition.param.float").defaultText("Value must be a number").build());
                    }
                }
                if (param.getType().getRestriction() == null || !def.getParameters().containsKey(param.getName()) || "range".equals((restriction = param.getType().getRestriction()).getType()) || !"enumeration".equals(restriction.getType()) || restriction.getValues().contains(paramValue)) continue;
                context.addMessage(new MessageBuilder().error().source((Object)paramPath).code("errors.channelDefinition.param.enum").defaultText("Invalid selection").build());
            }
        }
    }

    public void validateChooseCategory(ChannelDefinitionForm def, MessageContext context) {
        if (def.getCategories().size() == 0) {
            context.addMessage(new MessageBuilder().error().source((Object)"categories").code("errors.channelDefinition.param.categories.empty").defaultText("Please choose at least one category").build());
        }
    }

    public void validateChooseGroup(ChannelDefinitionForm def, MessageContext context) {
        if (def.getGroups().size() == 0) {
            context.addMessage(new MessageBuilder().error().source((Object)"groups").code("errors.channelDefinition.groups.empty").defaultText("Please choose at least one group").build());
        }
    }

    public void validateLifecycle(ChannelDefinitionForm def, ValidationContext context) {
        MessageContext messageContext = context.getMessageContext();
        if (def.getLifecycleState() == null) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"lifecycle").code("lifecycle.error.selectLifecycle").defaultText("Please select a lifecycle stage").build());
        }
        Date now = new Date();
        if (def.getPublishDate() != null && def.getPublishDateTime().before(now)) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"publishDate").code("lifecycle.error.invalidPublishDate").defaultText("The auto-publishing date must be in the future").build());
        }
        if (def.getExpirationDate() != null && def.getExpirationDateTime().before(now)) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"expirationDate").code("lifecycle.error.invalidExpirationDate").defaultText("The auto-expiration date must be in the future").build());
        }
        if (def.getPublishDate() != null && def.getExpirationDate() != null && def.getExpirationDateTime().before(def.getPublishDateTime())) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"expirationDate").code("lifecycle.error.invalidPublishAndExpirationDate").defaultText("The auto-expiration date must be after the auto-publish date").build());
        }
    }

    public void checkSave(ChannelDefinitionForm def, ValidationContext context) {
        this.validateBasicInfo(def, context.getMessageContext());
        this.validateChooseType(def, context.getMessageContext());
        this.validateSetParameters(def, context.getMessageContext());
        this.validateChooseGroup(def, context.getMessageContext());
    }
}

