/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.registerportal;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class PortalRegistrationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String institutionName;
    private String deployerName;
    private String deployerAddress;
    private String portalName;
    private String portalUrl;
    private String demoUrl;
    private String numberOfUsers;
    private String audience;
    private String authnSystem;
    private String notes;
    private boolean shareInfo = true;
    private Map<String, String> dataToSubmit;

    public PortalRegistrationRequest() {
    }

    public PortalRegistrationRequest(PortalRegistrationRequest registrationRequest) {
        this.institutionName = registrationRequest.institutionName;
        this.deployerName = registrationRequest.deployerName;
        this.deployerAddress = registrationRequest.deployerAddress;
        this.portalName = registrationRequest.portalName;
        this.portalUrl = registrationRequest.portalUrl;
        this.demoUrl = registrationRequest.demoUrl;
        this.numberOfUsers = registrationRequest.numberOfUsers;
        this.audience = registrationRequest.audience;
        this.authnSystem = registrationRequest.authnSystem;
        this.notes = registrationRequest.notes;
        this.shareInfo = registrationRequest.shareInfo;
        if (registrationRequest.dataToSubmit != null) {
            this.dataToSubmit = new LinkedHashMap<String, String>(registrationRequest.dataToSubmit);
        }
    }

    public void validateOrganizationInfoForm(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"institutionName", (String)"", null, (String)"Institution Name is required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"deployerName", (String)"", null, (String)"Contact Name is required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"deployerAddress", (String)"", null, (String)"Contact email is required");
        if (StringUtils.isNotBlank((String)this.deployerAddress)) {
            try {
                InternetAddress email = new InternetAddress(this.deployerAddress);
                email.validate();
            }
            catch (AddressException ae) {
                errors.rejectValue("deployerAddress", "", null, "Contact email must be a valid email address");
            }
        }
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public String getDeployerName() {
        return this.deployerName;
    }

    public void setDeployerName(String deployerName) {
        this.deployerName = deployerName;
    }

    public String getDeployerAddress() {
        return this.deployerAddress;
    }

    public void setDeployerAddress(String deployerAddress) {
        this.deployerAddress = deployerAddress;
    }

    public String getPortalName() {
        return this.portalName;
    }

    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public void setPortalUrl(String portalUrl) {
        this.portalUrl = portalUrl;
    }

    public boolean isShareInfo() {
        return this.shareInfo;
    }

    public void setShareInfo(boolean shareInfo) {
        this.shareInfo = shareInfo;
    }

    public Map<String, String> getDataToSubmit() {
        return this.dataToSubmit;
    }

    public void setDataToSubmit(Map<String, String> dataToSubmit) {
        this.dataToSubmit = dataToSubmit;
    }

    public String getDemoUrl() {
        return this.demoUrl;
    }

    public void setDemoUrl(String demoUrl) {
        this.demoUrl = demoUrl;
    }

    public String getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public void setNumberOfUsers(String numberOfUsers) {
        this.numberOfUsers = numberOfUsers;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getAuthnSystem() {
        return this.authnSystem;
    }

    public void setAuthnSystem(String authnSystem) {
        this.authnSystem = authnSystem;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PortalRegistrationRequest)) {
            return false;
        }
        PortalRegistrationRequest rhs = (PortalRegistrationRequest)object;
        return new EqualsBuilder().append(this.dataToSubmit, rhs.dataToSubmit).append((Object)this.deployerAddress, (Object)rhs.deployerAddress).append((Object)this.portalName, (Object)rhs.portalName).append((Object)this.deployerName, (Object)rhs.deployerName).append((Object)this.institutionName, (Object)rhs.institutionName).append((Object)this.portalUrl, (Object)rhs.portalUrl).append(this.shareInfo, rhs.shareInfo).append((Object)this.demoUrl, (Object)rhs.demoUrl).append((Object)this.numberOfUsers, (Object)rhs.numberOfUsers).append((Object)this.audience, (Object)rhs.audience).append((Object)this.authnSystem, (Object)rhs.authnSystem).append((Object)this.notes, (Object)rhs.notes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(554822571, 313513477).append(this.dataToSubmit).append((Object)this.deployerAddress).append((Object)this.portalName).append((Object)this.deployerName).append((Object)this.institutionName).append((Object)this.portalUrl).append(this.shareInfo).append((Object)this.demoUrl).append((Object)this.numberOfUsers).append((Object)this.audience).append((Object)this.authnSystem).append((Object)this.notes).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dataToSubmit", this.dataToSubmit).append("deployerAddress", (Object)this.deployerAddress).append("portalName", (Object)this.portalName).append("deployerName", (Object)this.deployerName).append("institutionName", (Object)this.institutionName).append("portalUrl", (Object)this.portalUrl).append("shareInfo", this.shareInfo).append("demoUrl", (Object)this.demoUrl).append("numberOfUsers", (Object)this.numberOfUsers).append("audience", (Object)this.audience).append("authnSystem", (Object)this.authnSystem).append("notes", (Object)this.notes).toString();
    }
}

