/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jasig.portal.serialize.CachingOutputStream;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.serialize.CachingWriter;
import org.jasig.portal.serialize.CharacterCachingWriter;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XHTMLSerializer;

public final class CachingXHTMLSerializer
extends XHTMLSerializer
implements CachingSerializer {
    CharacterCachingWriter cacher;

    public CachingXHTMLSerializer() {
        super(new OutputFormat("xhtml", null, false));
    }

    public CachingXHTMLSerializer(OutputFormat format) {
        super(format);
    }

    public CachingXHTMLSerializer(Writer writer, OutputFormat format) {
        this(format);
        this.setOutputCharStream(writer);
    }

    @Override
    public void setOutputCharStream(Writer writer) {
        CachingWriter cw = new CachingWriter(writer);
        this.cacher = cw;
        super.setOutputCharStream(cw);
    }

    public CachingXHTMLSerializer(OutputStream output, OutputFormat format) {
        this(format);
        this.setOutputByteStream(output);
    }

    @Override
    public void setOutputByteStream(OutputStream output) {
        CachingOutputStream cos = new CachingOutputStream(output);
        this.cacher = cos;
        super.setOutputByteStream(cos);
    }

    @Override
    public boolean startCaching() throws IOException {
        this.content();
        this._printer.flush();
        return this.cacher.startCaching();
    }

    @Override
    public boolean stopCaching() throws IOException {
        this.content();
        this._printer.flush();
        return this.cacher.stopCaching();
    }

    @Override
    public String getCache() throws UnsupportedEncodingException, IOException {
        this._printer.flush();
        return this.cacher.getCache(this._format.getEncoding());
    }

    @Override
    public void printRawCharacters(String text) throws IOException {
        this.content();
        this._printer.printText(text);
    }

    @Override
    public void setDocumentStarted(boolean setting) {
        this._started = setting;
    }

    @Override
    public void flush() throws IOException {
        this._printer.flush();
        this.cacher.flush();
    }
}

