/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.jndi.IJndiManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jndi.JndiTemplate;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class ExternalServices
implements InitializingBean {
    private static final Log log = LogFactory.getLog(ExternalServices.class);
    private IJndiManager jndiManager;
    private CarResources carResources;
    private ServiceHandler svcHandler;
    private Context servicesContext;

    public static void startServices(Context servicesContext) throws PortalException {
        log.warn((Object)"Method 'public static void startServices(Context)' is no longer supported. ExternalServices will be initialized by Spring");
    }

    public IJndiManager getJndiManager() {
        return this.jndiManager;
    }

    @Required
    public void setJndiManager(IJndiManager jndiManager) {
        this.jndiManager = jndiManager;
    }

    public CarResources getCarResources() {
        return this.carResources;
    }

    @Required
    public void setCarResources(CarResources carResources) {
        this.carResources = carResources;
    }

    public void afterPropertiesSet() throws Exception {
        JndiTemplate jndiTemplate = this.jndiManager.getJndiTemplate();
        this.servicesContext = (Context)jndiTemplate.lookup("/services", Context.class);
        this.svcHandler = new ServiceHandler();
        if (this.carResources.hasDescriptors()) {
            try {
                this.carResources.getServices(this.svcHandler);
            }
            catch (Exception ex) {
                throw new PortalException("Failed to start external portal services in CAR descriptors.", (Throwable)ex);
            }
        }
    }

    protected SAXParser createParser() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        return factory.newSAXParser();
    }

    protected void outputMessage(String msg) {
        System.out.println("External services: " + msg);
        log.info((Object)("External services: " + msg));
    }

    public Class<?> getClassObject(String className) throws Exception {
        if (className.indexOf("TYPE") != -1 || className.indexOf("class") != -1) {
            if (className.equals("boolean.class") || className.equals("Boolean.TYPE")) {
                return Boolean.TYPE;
            }
            if (className.equals("byte.class") || className.equals("Byte.TYPE")) {
                return Byte.TYPE;
            }
            if (className.equals("short.class") || className.equals("Short.TYPE")) {
                return Short.TYPE;
            }
            if (className.equals("char.class") || className.equals("Char.TYPE")) {
                return Character.TYPE;
            }
            if (className.equals("int.class") || className.equals("Integer.TYPE")) {
                return Integer.TYPE;
            }
            if (className.equals("long.class") || className.equals("Long.TYPE")) {
                return Long.TYPE;
            }
            if (className.equals("float.class") || className.equals("Float.TYPE")) {
                return Float.TYPE;
            }
            if (className.equals("double.class") || className.equals("Double.TYPE")) {
                return Double.TYPE;
            }
        } else {
            return this.carResources.getClassLoader().loadClass(className);
        }
        return null;
    }

    class ServiceHandler
    extends DefaultHandler {
        ServiceItem svcItem;
        String elementName;
        Argument argItem;
        boolean argProcessing = false;
        boolean jndiNameporcessing = false;

        ServiceHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementName = qName;
            if (qName.equals("service")) {
                this.svcItem = new ServiceItem();
            } else if (qName.equals("method")) {
                this.svcItem.setMethodType(atts.getValue("type"));
            } else if (qName.equals("arguments")) {
                this.argProcessing = true;
            } else if (qName.equals("argitem")) {
                this.argItem = new Argument();
            } else if (qName.equals("datatype")) {
                String array = atts.getValue("array");
                this.argItem.setArray(array != null && array.equals("true"));
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            this.elementName = null;
            if (qName.equals("service")) {
                String javaClass = this.svcItem.getJavaClass();
                Class<?>[] classNames = null;
                Object[] args = null;
                Class<?> svcClass = null;
                try {
                    svcClass = ExternalServices.this.carResources.getClassLoader().loadClass(javaClass);
                    args = this.svcItem.getArguments();
                    classNames = this.svcItem.getArgumentClasses();
                }
                catch (ClassNotFoundException cnfe) {
                    ExternalServices.this.outputMessage("Class not found - " + cnfe.getMessage());
                    return;
                }
                catch (Exception e) {
                    ExternalServices.this.outputMessage("The service \"" + this.svcItem.getName() + "\" FAILED TO START.");
                    return;
                }
                try {
                    Object obj = null;
                    Object returnObject = null;
                    if (this.svcItem.getStartMethod().length() > 0) {
                        Method startMethod = svcClass.getMethod(this.svcItem.getStartMethod(), classNames);
                        if (Modifier.isStatic(startMethod.getModifiers())) {
                            returnObject = startMethod.invoke(null, args);
                        } else {
                            obj = svcClass.newInstance();
                            returnObject = startMethod.invoke(obj, args);
                        }
                        ExternalServices.this.outputMessage("initialized \"" + this.svcItem.getName() + "\"");
                    }
                    if (this.svcItem.getJndiName().length() > 0) {
                        if (returnObject != null) {
                            ExternalServices.this.servicesContext.bind(this.svcItem.getJndiName(), returnObject);
                            ExternalServices.this.outputMessage("bound intialization result for service \"" + this.svcItem.getName() + "\"");
                        } else {
                            if (obj == null) {
                                obj = svcClass.newInstance();
                            }
                            ExternalServices.this.servicesContext.bind(this.svcItem.getJndiName(), obj);
                            ExternalServices.this.outputMessage("bound class instance for service \"" + this.svcItem.getName() + "\"");
                        }
                    }
                    return;
                }
                catch (NoSuchMethodException nsme) {
                    ExternalServices.this.outputMessage("Method not found - " + nsme.getMessage());
                }
                catch (Exception ex) {
                    ExternalServices.this.outputMessage("General Exception - " + ex.getMessage());
                    ex.printStackTrace();
                }
                ExternalServices.this.outputMessage("The service \"" + this.svcItem.getName() + "\" FAILED TO START.");
            } else if (qName.equals("arguments")) {
                this.argProcessing = false;
            } else if (qName.equals("argitem")) {
                this.svcItem.addArgument(this.argItem);
                this.argItem = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.elementName == null) {
                return;
            }
            String chValue = new String(ch, start, length);
            if (this.elementName.equals("name")) {
                this.svcItem.setName(chValue);
            } else if (this.elementName.equals("class")) {
                this.svcItem.setJavaClass(chValue);
            } else if (this.elementName.equals("jndi_name")) {
                this.svcItem.setJndiName(chValue);
            } else if (this.elementName.equals("method")) {
                this.svcItem.setStartMethod(chValue);
            } else if (this.elementName.equals("datatype") && this.argProcessing) {
                this.argItem.setDataType(chValue);
            } else if (this.elementName.equals("value") && this.argProcessing) {
                this.argItem.addValue(chValue);
            }
        }
    }

    class Argument {
        String datatype;
        boolean array;
        ArrayList<String> values = new ArrayList();

        Argument() {
        }

        public void addValue(String argValue) {
            this.values.add(argValue);
        }

        public String getDataType() {
            return this.datatype;
        }

        public void setDataType(String argDataType) {
            this.datatype = argDataType;
        }

        public boolean getArray() {
            return this.array;
        }

        public void setArray(boolean b) {
            this.array = b;
        }

        public Object getValue() throws Exception {
            Object value = null;
            if (this.array) {
                value = Array.newInstance(ExternalServices.this.getClassObject(this.datatype), this.values.size());
                for (int i = 0; i < this.values.size(); ++i) {
                    Array.set(value, i, this.values.get(i));
                }
            } else {
                value = this.getValue(this.datatype, this.values.get(0));
            }
            return value;
        }

        private Object getValue(String className, String value) throws Exception {
            if (className.indexOf("TYPE") != -1 || className.indexOf("class") != -1) {
                try {
                    if (className.equals("boolean.class") || className.equals("BOOLEAN.TYPE")) {
                        return new Boolean(value);
                    }
                    if (className.equals("byte.class") || className.equals("Byte.TYPE")) {
                        return new Byte(value);
                    }
                    if (className.equals("short.class") || className.equals("Short.TYPE")) {
                        return new Short(value);
                    }
                    if (className.equals("char.class") || className.equals("Char.TYPE")) {
                        return new Character(value.charAt(0));
                    }
                    if (className.equals("int.class") || className.equals("Integer.TYPE")) {
                        return new Integer(value);
                    }
                    if (className.equals("long.class") || className.equals("Long.TYPE")) {
                        return new Long(value);
                    }
                    if (className.equals("float.class") || className.equals("Float.TYPE")) {
                        return new Float(value);
                    }
                    if (className.equals("double.class") || className.equals("Double.TYPE")) {
                        return new Double(value);
                    }
                }
                catch (NumberFormatException nfe) {
                    ExternalServices.this.outputMessage("Cannot convert " + value + " to declared datatype class " + className);
                }
            } else {
                return value;
            }
            return null;
        }
    }

    class ServiceItem {
        StringBuffer name = new StringBuffer("");
        StringBuffer javaClass = new StringBuffer("");
        StringBuffer jndiName = new StringBuffer("");
        StringBuffer startMethod = new StringBuffer("");
        StringBuffer methodType = new StringBuffer("");
        List<Argument> argList;

        ServiceItem() {
        }

        public void setName(String svcName) {
            this.name.append(svcName);
        }

        public String getName() {
            return this.name.toString();
        }

        public void setJavaClass(String svcClass) {
            this.javaClass.append(svcClass);
        }

        public String getJavaClass() {
            return this.javaClass.toString();
        }

        public void setStartMethod(String methodName) {
            this.startMethod.append(methodName);
        }

        public String getStartMethod() {
            return this.startMethod.toString();
        }

        public void setJndiName(String name) {
            this.jndiName.append(name);
        }

        public String getJndiName() {
            return this.jndiName.toString();
        }

        public void setMethodType(String type) {
            this.methodType.append(type);
        }

        public boolean isStatic() {
            return this.methodType.length() > 0;
        }

        public void addArgument(Argument argItem) {
            if (this.argList == null) {
                this.argList = new ArrayList<Argument>();
            }
            this.argList.add(argItem);
        }

        public Object[] getArguments() throws Exception {
            Object[] args;
            if (this.argList != null) {
                args = new Object[this.argList.size()];
                for (int i = 0; i < this.argList.size(); ++i) {
                    Argument argItem = this.argList.get(i);
                    args[i] = argItem.getValue();
                }
            } else {
                args = new Object[]{};
            }
            return args;
        }

        public Class<?>[] getArgumentClasses() throws Exception {
            Class[] classNames = null;
            if (this.argList != null) {
                classNames = new Class[this.argList.size()];
                for (int i = 0; i < this.argList.size(); ++i) {
                    Argument argItem = this.argList.get(i);
                    String className = argItem.getDataType();
                    classNames[i] = argItem.getArray() ? Array.newInstance(ExternalServices.this.getClassObject(className), 1).getClass() : ExternalServices.this.getClassObject(className);
                }
            }
            return classNames;
        }
    }
}

