/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.spring.LazyInitByDefaultBeanDefinitionDocumentReader;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortalApplicationContextLocator
implements ServletContextListener {
    private static Log LOGGER = LogFactory.getLog(PortalApplicationContextLocator.class);
    private static final SingletonDoubleCheckedCreator<ConfigurableApplicationContext> applicationContextCreator = new PortalApplicationContextCreator();
    private static Throwable directCreatorThrowable;
    private static ServletContext servletContext;

    public void contextInitialized(ServletContextEvent sce) {
        servletContext = sce.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        servletContext = null;
    }

    @Deprecated
    public static boolean isRunningInWebApplication() {
        return servletContext != null;
    }

    @Deprecated
    public static WebApplicationContext getRequiredWebApplicationContext() {
        ServletContext context = servletContext;
        if (context == null) {
            throw new IllegalStateException("No ServletContext is available to load a WebApplicationContext for. Is this ServletContextListener not configured or has the ServletContext been destroyed?");
        }
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
    }

    @Deprecated
    public static WebApplicationContext getWebApplicationContext() {
        ServletContext context = servletContext;
        if (context == null) {
            return null;
        }
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
    }

    public static ApplicationContext getApplicationContext() {
        ServletContext context = servletContext;
        if (context != null) {
            LOGGER.debug((Object)"Using WebApplicationContext");
            if (applicationContextCreator.isCreated()) {
                IllegalStateException createException = new IllegalStateException("A portal managed ApplicationContext has already been created but now a ServletContext is available and a WebApplicationContext will be returned. This situation should be resolved by delaying calls to this class until after the web-application has completely initialized.");
                LOGGER.error((Object)createException, (Throwable)createException);
                LOGGER.error((Object)"Stack trace of original ApplicationContext creator", directCreatorThrowable);
                throw createException;
            }
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            if (webApplicationContext == null) {
                throw new IllegalStateException("ServletContext is available but WebApplicationContextUtils.getWebApplicationContext(ServletContext) returned null. Either the application context failed to load or is not yet done loading.");
            }
            return webApplicationContext;
        }
        return (ApplicationContext)applicationContextCreator.get(new Object[0]);
    }

    public static void shutdown() {
        if (applicationContextCreator.isCreated()) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)applicationContextCreator.get(new Object[0]);
            applicationContext.close();
        } else {
            IllegalStateException createException = new IllegalStateException("No portal managed ApplicationContext has been created, there is nothing to shutdown.");
            LOGGER.error((Object)createException, (Throwable)createException);
        }
    }

    private static class PortalApplicationContextCreator
    extends SingletonDoubleCheckedCreator<ConfigurableApplicationContext> {
        private PortalApplicationContextCreator() {
        }

        @Override
        protected ConfigurableApplicationContext createSingleton(Object ... args) {
            LOGGER.info((Object)"Creating new lazily initialized GenericApplicationContext for the portal");
            long startTime = System.currentTimeMillis();
            GenericApplicationContext genericApplicationContext = new GenericApplicationContext();
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)genericApplicationContext);
            reader.setDocumentReaderClass(LazyInitByDefaultBeanDefinitionDocumentReader.class);
            reader.loadBeanDefinitions("/properties/contexts/*.xml");
            genericApplicationContext.refresh();
            genericApplicationContext.registerShutdownHook();
            directCreatorThrowable = new Throwable();
            directCreatorThrowable.fillInStackTrace();
            LOGGER.info((Object)("Created new lazily initialized GenericApplicationContext for the portal in " + (System.currentTimeMillis() - startTime) + "ms"));
            return genericApplicationContext;
        }
    }
}

