/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.properties;

import java.beans.PropertyEditor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

public class PortalPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<Class<?>, PropertyEditor> propertyEditors;

    public Map<Class<?>, PropertyEditor> getPropertyEditors() {
        return this.propertyEditors;
    }

    public void setPropertyEditors(Map<Class<?>, PropertyEditor> propertyEditors) {
        this.propertyEditors = propertyEditors;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (this.propertyEditors == null) {
            this.logger.warn((Object)"No PropertyEditors Map configured, returning with no action taken.");
            return;
        }
        for (Map.Entry<Class<?>, PropertyEditor> editorEntry : this.propertyEditors.entrySet()) {
            Class<?> requiredType = editorEntry.getKey();
            PropertyEditor editor = editorEntry.getValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering PropertyEditor '" + editor + "' for type '" + requiredType + "'"));
            }
            registry.registerCustomEditor(requiredType, editor);
        }
    }
}

