/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.web.context.support;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jasig.portal.spring.web.context.support.HttpSessionCreatedEvent;
import org.jasig.portal.spring.web.context.support.HttpSessionDestroyedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationContextDelagatingSessionListener
implements HttpSessionListener {
    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        HttpSessionCreatedEvent httpSessionCreatedEvent = new HttpSessionCreatedEvent(session);
        WebApplicationContext webApplicationContext = this.getWebApplicationContext(session);
        webApplicationContext.publishEvent((ApplicationEvent)httpSessionCreatedEvent);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        HttpSessionDestroyedEvent httpSessionDestroyedEvent = new HttpSessionDestroyedEvent(session);
        WebApplicationContext webApplicationContext = this.getWebApplicationContext(session);
        webApplicationContext.publishEvent((ApplicationEvent)httpSessionDestroyedEvent);
    }

    protected WebApplicationContext getWebApplicationContext(HttpSession session) {
        ServletContext servletContext = session.getServletContext();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }
}

