/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools;

import java.util.List;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelType;

public class RegisterChannelType {
    protected static IChannelRegistryStore chanRegStore = null;

    public static void main(String[] args) {
        if (args.length == 4) {
            try {
                RegisterChannelType.msg(RegisterChannelType.register(args[0].trim(), args[1].trim(), args[2].trim(), args[3].trim()));
            }
            catch (IllegalArgumentException e) {
                RegisterChannelType.msg(e.getMessage());
                RegisterChannelType.printHelp();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            RegisterChannelType.printHelp();
        }
    }

    private static void checkValidity(String name, String value) throws IllegalArgumentException {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Parameter '" + name + "' must be specified when publishing a channel type.");
        }
    }

    public static String register(String clazz, String name, String description, String uri) throws Exception {
        clazz = clazz.trim();
        name = name.trim();
        description = description.trim();
        uri = uri.trim();
        RegisterChannelType.checkValidity("<class>", clazz);
        RegisterChannelType.checkValidity("<name>", name);
        RegisterChannelType.checkValidity("<description>", description);
        RegisterChannelType.checkValidity("<CPD URI>", uri);
        boolean isNew = false;
        chanRegStore = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
        List<IChannelType> types = chanRegStore.getChannelTypes();
        IChannelType chanType = null;
        for (IChannelType type : types) {
            if (!type.getCpdUri().equals(uri)) continue;
            chanType = type;
        }
        if (chanType == null) {
            isNew = true;
            chanType = chanRegStore.newChannelType(name, clazz, uri);
        }
        chanType.setDescription(description);
        chanRegStore.saveChannelType(chanType);
        return "The \"" + name + "\" channel type has been " + (isNew ? "added" : "updated") + " successfully.";
    }

    private static void msg(String msg) {
        System.out.println(msg);
    }

    private static void printHelp() {
        RegisterChannelType.msg("Usage: RegisterChannelType <class> <name> <description> <CPD URI>");
        RegisterChannelType.msg("  <class> = Fully qualified channel java class. Ex: org.jasig.portal.channels.CImage");
        RegisterChannelType.msg("  <name> = Name of channel type.  Ex: Image channel");
        RegisterChannelType.msg("  <description> = Description of channel type.  Ex: Displays image with optional title and subtitle");
        RegisterChannelType.msg("  <CPD URI> = URL or classpath-relative path to channel publishing document.  Ex: /org/jasig/portal/channels/CImage/CImage.cpd");
    }
}

