/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.jasig.portal.url.processing.IRequestParameterProcessorController;

public class RequestParameterProcessorListController
implements IRequestParameterProcessorController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<IRequestParameterProcessor> dynamicRequestParameterProcessors = Collections.emptyList();
    private int maxNumberOfProcessingCycles = 10;

    public List<IRequestParameterProcessor> getDynamicRequestParameterProcessors() {
        return this.dynamicRequestParameterProcessors;
    }

    public void setDynamicRequestParameterProcessors(List<IRequestParameterProcessor> dynamicRequestParameterProcessors) {
        Validate.notNull(dynamicRequestParameterProcessors, (String)"IDynamicRequestParameterProcessor List can not be null");
        Validate.noNullElements(dynamicRequestParameterProcessors, (String)"IDynamicRequestParameterProcessor List can not contain a null element");
        this.dynamicRequestParameterProcessors = dynamicRequestParameterProcessors;
    }

    public int getMaxNumberOfProcessingCycles() {
        return this.maxNumberOfProcessingCycles;
    }

    public void setMaxNumberOfProcessingCycles(int maxNumberOfProcessingCycles) {
        this.maxNumberOfProcessingCycles = maxNumberOfProcessingCycles;
    }

    @Override
    public void processParameters(IWritableHttpServletRequest req, HttpServletResponse res) {
        LinkedList<IRequestParameterProcessor> incompleteDynamicProcessors = new LinkedList<IRequestParameterProcessor>(this.dynamicRequestParameterProcessors);
        int cycles = 0;
        while (incompleteDynamicProcessors.size() > 0) {
            Iterator processorItr = incompleteDynamicProcessors.iterator();
            while (processorItr.hasNext()) {
                IRequestParameterProcessor requestParameterProcessor = (IRequestParameterProcessor)processorItr.next();
                boolean complete = requestParameterProcessor.processParameters(req, res);
                if (!complete) continue;
                processorItr.remove();
            }
            if (++cycles < this.maxNumberOfProcessingCycles) continue;
            this.logger.warn((Object)(incompleteDynamicProcessors.size() + " IDynamicRequestParameterProcessors did not completel processing after " + cycles + " attempts. Execution will continue but this situation should be reviewed. Incomplete Processors=" + incompleteDynamicProcessors), new Throwable("Stack Trace"));
            break;
        }
    }
}

