/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.TransientUserLayoutManagerWrapper;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.UserPrefsHandler;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Element;

public class UserLayoutParameterProcessor
implements IRequestParameterProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IUserInstanceManager userInstanceManager;

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        Validate.notNull((Object)userInstanceManager);
        this.userInstanceManager = userInstanceManager;
    }

    @Override
    public boolean processParameters(IWritableHttpServletRequest request, HttpServletResponse response) {
        String[] themeChannelAttrNames;
        String[] structChannelAttrNames;
        String[] structFolderAttrNames;
        String[] themeParamNames;
        String[] structParamNames;
        String fname;
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        ChannelManager channelManager = userInstance.getChannelManager();
        this.parseMultiTargetEvent(request, response, "uP_help_target", PortalEvent.HELP_BUTTON, channelManager);
        this.parseMultiTargetEvent(request, response, "uP_about_target", PortalEvent.ABOUT_BUTTON, channelManager);
        this.parseMultiTargetEvent(request, response, "uP_edit_target", PortalEvent.EDIT_BUTTON, channelManager);
        this.parseSingleTargetEvent(request, response, "uP_detach_target", PortalEvent.DETACH_BUTTON, channelManager);
        IPerson person = userInstance.getPerson();
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        UserPreferences userPreferences = preferencesManager.getUserPreferences();
        StructureStylesheetUserPreferences structureStylesheetUserPreferences = userPreferences.getStructureStylesheetUserPreferences();
        ThemeStylesheetUserPreferences themeStylesheetUserPreferences = userPreferences.getThemeStylesheetUserPreferences();
        String root = request.getParameter("uP_root");
        if (root != null) {
            if (root.equals("me")) {
                UPFileSpec upfs = new UPFileSpec(request);
                root = upfs.getTargetNodeId();
            }
            if ("root".equals(root)) {
                String oldChannelId = structureStylesheetUserPreferences.getParameterValue("userLayoutRoot");
                if (oldChannelId != null && !"root".equals(oldChannelId)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Sending window state event '" + PortalEvent.NORMAL + "' to '" + root + "'."));
                    }
                    channelManager.passPortalEvent(request, response, oldChannelId, PortalEvent.NORMAL);
                }
            } else {
                themeStylesheetUserPreferences.setChannelAttributeValue(root, "minimized", "false");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending window state event '" + PortalEvent.MAXIMIZE + "' to '" + root + "'."));
                }
                channelManager.passPortalEvent(request, response, root, PortalEvent.MAXIMIZE);
            }
            structureStylesheetUserPreferences.putParameterValue("userLayoutRoot", root);
        }
        if ((fname = request.getParameter("uP_fname")) != null) {
            String subId = null;
            try {
                subId = userLayoutManager.getSubscribeId(fname);
            }
            catch (PortalException pe) {
                this.logger.warn((Object)("Unable to get subscribe ID for fname='" + fname + "'"), (Throwable)pe);
            }
            if (subId != null) {
                if (userLayoutManager instanceof TransientUserLayoutManagerWrapper) {
                    TransientUserLayoutManagerWrapper transientUserLayoutManagerWrapper = (TransientUserLayoutManagerWrapper)userLayoutManager;
                    transientUserLayoutManagerWrapper.setFocusedId(subId);
                }
                structureStylesheetUserPreferences.putParameterValue("userLayoutRoot", subId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("setting structure preference 'userLayoutRoot'='" + subId + "'"));
                }
            }
        }
        if ((structParamNames = request.getParameterValues("uP_sparam")) != null) {
            for (String structParamName : structParamNames) {
                String structParamValue = request.getParameter(structParamName);
                structureStylesheetUserPreferences.putParameterValue(structParamName, structParamValue);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("set structure parameter '" + structParamName + "'='" + structParamValue + "'."));
            }
        }
        if ((themeParamNames = request.getParameterValues("uP_tparam")) != null) {
            for (String themeParamName : themeParamNames) {
                String themeParamValue = request.getParameter(themeParamName);
                themeStylesheetUserPreferences.putParameterValue(themeParamName, themeParamValue);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("set theme parameter '" + themeParamName + "'='" + themeParamValue + "'."));
            }
        }
        if ((structFolderAttrNames = request.getParameterValues("uP_sfattr")) != null) {
            for (String structFolderAttrName : structFolderAttrNames) {
                String[] folderIds = request.getParameterValues(structFolderAttrName + "_folderId");
                if (folderIds == null) continue;
                for (String folderId : folderIds) {
                    String structFolderAttrValue = request.getParameter(structFolderAttrName + "_" + folderId + "_value");
                    structureStylesheetUserPreferences.setFolderAttributeValue(folderId, structFolderAttrName, structFolderAttrValue);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("set structure folder attribute '" + structFolderAttrName + "'='" + structFolderAttrValue + "' on folder '" + folderId + "'."));
                }
            }
        }
        if ((structChannelAttrNames = request.getParameterValues("uP_scattr")) != null) {
            for (String structChannelAttrName : structChannelAttrNames) {
                String[] channelIds = request.getParameterValues(structChannelAttrName + "_channelId");
                if (channelIds == null) continue;
                for (String channelId : channelIds) {
                    String structChannelAttrValue = request.getParameter(structChannelAttrName + "_" + channelId + "_value");
                    structureStylesheetUserPreferences.setChannelAttributeValue(channelId, structChannelAttrName, structChannelAttrValue);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("set structure channel attribute '" + structChannelAttrName + "'='" + structChannelAttrValue + "' on folder '" + channelId + "'."));
                }
            }
        }
        if ((themeChannelAttrNames = request.getParameterValues("uP_tcattr")) != null) {
            for (String themeChannelAttrName : themeChannelAttrNames) {
                String[] channelIds = request.getParameterValues(themeChannelAttrName + "_channelId");
                if (channelIds == null) continue;
                for (String channelId : channelIds) {
                    String themeChannelAttrValue = request.getParameter(themeChannelAttrName + "_" + channelId + "_value");
                    themeStylesheetUserPreferences.setChannelAttributeValue(channelId, themeChannelAttrName, themeChannelAttrValue);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("set theme channel attribute '" + themeChannelAttrName + "'='" + themeChannelAttrValue + "' on folder '" + channelId + "'."));
                    }
                    if (!"minimized".equals(themeChannelAttrName)) continue;
                    Element channel = userLayoutManager.getUserLayoutDOM().getElementById(channelId);
                    try {
                        UserPrefsHandler.setUserPreference(channel, themeChannelAttrName, person);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Failed to set 'minimized' attribute on channel '" + channelId + "' with element: " + channel), (Throwable)e);
                    }
                    PortalEvent event = "true".equals(themeChannelAttrValue) ? PortalEvent.MINIMIZE : PortalEvent.NORMAL;
                    channelManager.passPortalEvent(request, response, channelId, event);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Sent window state event '" + event + "' to '" + channelId + "'."));
                }
            }
        }
        if (!person.isGuest()) {
            String saveWhat;
            String localesString = request.getParameter("uP_locales");
            if (localesString != null) {
                UserProfile profile = userPreferences.getProfile();
                LocaleManager localeManager = profile.getLocaleManager();
                Locale[] locales = LocaleManager.parseLocales(localesString);
                localeManager.setSessionLocales(locales);
            }
            if ((saveWhat = request.getParameter("uP_save")) != null) {
                IUserLayoutStore userLayoutStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
                try {
                    if (saveWhat.equals("preferences")) {
                        userLayoutStore.putUserPreferences(person, userPreferences);
                    } else if (saveWhat.equals("layout")) {
                        userLayoutManager.saveUserLayout();
                    } else if (saveWhat.equals("all")) {
                        userLayoutStore.putUserPreferences(person, userPreferences);
                        userLayoutManager.saveUserLayout();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("persisted " + saveWhat + " changes."));
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("unable to persist " + saveWhat + " changes. "), (Throwable)e);
                }
            }
        }
        userLayoutManager.processLayoutParameters(person, userPreferences, request);
        return true;
    }

    protected void parseMultiTargetEvent(IWritableHttpServletRequest request, HttpServletResponse response, String parameterName, PortalEvent event, ChannelManager channelManager) {
        String[] channelIds = request.getParameterValues(parameterName);
        if (channelIds != null) {
            for (String channelId : channelIds) {
                channelManager.passPortalEvent(request, response, channelId, event);
            }
        }
    }

    protected void parseSingleTargetEvent(IWritableHttpServletRequest request, HttpServletResponse response, String parameterName, PortalEvent event, ChannelManager channelManager) {
        String channelId = request.getParameter(parameterName);
        if (channelId != null) {
            channelManager.passPortalEvent(request, response, channelId, event);
        }
    }
}

