/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import org.jasig.portal.utils.MovingAverageSample;

public class MovingAverage {
    public static final int SAMPLESIZE = 100;
    private long[] samples = new long[100];
    private int ent = -1;
    private long sum = 0L;
    private long totalSamples = 0L;
    private long highMax = 0L;

    public synchronized MovingAverageSample add(long sample) {
        long lastSample = sample;
        int first = ++this.ent % this.samples.length;
        if (this.totalSamples >= (long)this.samples.length) {
            this.sum -= this.samples[first];
        }
        this.sum += sample;
        this.samples[first] = sample;
        if (sample > this.highMax) {
            this.highMax = sample;
        }
        ++this.totalSamples;
        long max = 0L;
        long min = Long.MAX_VALUE;
        long arraySize = Math.min(this.totalSamples, (long)this.samples.length);
        int i = 0;
        while ((long)i < arraySize) {
            if (this.samples[i] > max) {
                max = this.samples[i];
            }
            if (this.samples[i] < min) {
                min = this.samples[i];
            }
            ++i;
        }
        return new MovingAverageSample(this.sum / arraySize, this.highMax, lastSample, max, min, this.totalSamples);
    }
}

