/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;

public class URLUtil {
    private static final Log log = LogFactory.getLog(URLUtil.class);
    public static final int REDIRECT_URL_LIMIT = 512;
    public static final String HTTP_GET_REQUEST = "GET";
    public static final String HTTP_POST_REQUEST = "POST";

    public static void redirect(HttpServletRequest req, HttpServletResponse res, String targetNodeId, boolean asRoot, String[] ignoreParams, String charset) throws PortalException {
        String extras = new UPFileSpec(req).getUPFileExtras();
        UPFileSpec uPFileSpec = URLUtil.buildUPFileSpec(targetNodeId, extras, asRoot);
        URLUtil.redirectGet(req, res, uPFileSpec, ignoreParams);
    }

    private static String buildRequestParams(HttpServletRequest req, String[] ignoreParams) {
        String parameterName = null;
        String[] parameterValues = null;
        StringBuffer sb = new StringBuffer(512);
        Enumeration requestParameterNames = req.getParameterNames();
        while (requestParameterNames.hasMoreElements()) {
            parameterName = (String)requestParameterNames.nextElement();
            if (URLUtil.parameterExistsIn(parameterName, ignoreParams)) continue;
            parameterValues = req.getParameterValues(parameterName);
            for (int index = 0; index < parameterValues.length; ++index) {
                sb.append(parameterName);
                sb.append("=");
                sb.append(parameterValues[index]);
                sb.append("&");
            }
        }
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) == '&') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static boolean parameterExistsIn(String param, String[] params) {
        boolean found = false;
        for (int index = 0; index < params.length; ++index) {
            if (!param.equals(params[index])) continue;
            found = true;
        }
        return found;
    }

    private static UPFileSpec buildUPFileSpec(String targetNodeId, String extras, boolean asRoot) throws PortalException {
        UPFileSpec up = null;
        up = asRoot ? new UPFileSpec(0, targetNodeId, null, extras) : new UPFileSpec(0, "userLayoutRootNode", targetNodeId, extras);
        return up;
    }

    public static void redirectGet(HttpServletRequest req, HttpServletResponse res, UPFileSpec up, String[] ignoreParams) throws PortalException {
        StringBuffer sb = new StringBuffer(512);
        try {
            sb.append(up.getUPFile());
            String qs = req.getQueryString();
            if (qs != null && !"".equals(qs)) {
                sb.append('?').append(URLUtil.buildRequestParams(req, ignoreParams));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("URLUtil::redirectGet() Redirecting to framework: " + sb.toString()));
            }
            res.sendRedirect(res.encodeRedirectURL(sb.toString()));
        }
        catch (IOException ioe) {
            log.error((Object)("URLUtil::redirectGet() Failed redirecting to framework: " + sb.toString()), (Throwable)ioe);
            throw new PortalException(ioe);
        }
    }

    private static void buildHeader(HttpServletRequest req, HttpURLConnection uconn) {
        Enumeration fields = req.getHeaderNames();
        while (fields.hasMoreElements()) {
            String name = (String)fields.nextElement();
            String value = req.getHeader(name);
            String currentValue = uconn.getRequestProperty(name);
            if (currentValue != null && !"".equals(currentValue)) {
                value = currentValue + ',' + value;
            }
            uconn.setRequestProperty(name, value);
        }
    }

    public static void redirectPost(HttpServletRequest req, HttpServletResponse res, UPFileSpec up, String[] ignoreParams, String charset) throws PortalException {
        String parameters = URLUtil.buildRequestParams(req, ignoreParams);
        StringBuffer urlStr = new StringBuffer(512);
        String thisUri = req.getRequestURI();
        urlStr.append("http://").append(req.getServerName());
        urlStr.append(":").append(req.getServerPort());
        int pos = thisUri.indexOf("tag");
        if (pos < 0) {
            log.error((Object)("URLUtil::redirectPost() Invalid url, no tag found: " + thisUri));
            throw new PortalException("Invalid URL, no tag found: " + thisUri);
        }
        urlStr.append(thisUri.substring(0, pos));
        urlStr.append(up.getUPFile());
        if (log.isDebugEnabled()) {
            log.debug((Object)("URLUtil::redirectPost() Redirecting to framework: " + urlStr.toString()));
        }
        OutputStreamWriter wr = null;
        BufferedReader br = null;
        HttpURLConnection conn = null;
        try {
            String oneline;
            URL url = new URL(urlStr.toString());
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            URLUtil.buildHeader(req, conn);
            wr = new OutputStreamWriter(conn.getOutputStream(), charset);
            wr.write(parameters);
            wr.flush();
            conn.connect();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
            StringBuffer results = new StringBuffer(512);
            while ((oneline = br.readLine()) != null) {
                results.append(oneline).append('\n');
            }
            res.getWriter().print(results.toString());
        }
        catch (IOException ioe) {
            log.error((Object)ioe, (Throwable)ioe);
            throw new PortalException(ioe);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (wr != null) {
                    wr.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException exception) {
                log.error((Object)("URLUtil:redirectPost()::Unable to close Resources " + exception));
            }
        }
    }
}

