/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.car.ResourceResolver;
import org.jasig.portal.i18n.LocaleAwareXSLT;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.spring.locator.CacheFactoryLocator;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.cache.CacheFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSLT {
    private static final String ROOT_CACHE_NAME = "org.jasig.portal.utils.XSLT.STYLESHEET_ROOT_CACHE";
    private static final String SET_CACHE_NAME = "org.jasig.portal.utils.XSLT.STYLESHEET_SET_CACHE";
    private static final Map<String, Templates> stylesheetRootCache;
    private static final Map<String, StylesheetSet> stylesheetSetCache;
    private static final Log log;
    protected static boolean stylesheetRootCacheEnabled;
    protected static boolean stylesheetSetCacheEnabled;
    protected static final String mediaProps = "/properties/media.properties";
    private static SAXTransformerFactory saxTFactory;
    protected Object caller = null;
    protected Source xmlSource;
    protected Result xmlResult;
    protected HashMap stylesheetParams = new HashMap();
    protected String xslURI;
    protected ResourceBundle l18n;

    public XSLT(Object instance) {
        this.caller = instance;
    }

    public static XSLT getTransformer(Object instance) {
        return new XSLT(instance);
    }

    public static XSLT getTransformer(Object instance, Locale[] locales) {
        return new LocaleAwareXSLT(instance, locales);
    }

    public static SAXTransformerFactory getSAXTFactory() {
        if (saxTFactory == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setURIResolver(new ResourceResolver());
            if (tFactory instanceof SAXTransformerFactory) {
                saxTFactory = (SAXTransformerFactory)tFactory;
            }
        }
        if (saxTFactory == null) {
            log.error((Object)"XSLT() : unable to instantiate SAX transformer ! Please make sure the TRAX implementation you're using supports SAX Transformers");
        }
        return saxTFactory;
    }

    public void setXML(String xml) {
        this.xmlSource = new StreamSource(new StringReader(xml));
    }

    public void setXML(Node xml) {
        this.xmlSource = new DOMSource(xml);
    }

    public void setXML(InputStream is) {
        this.xmlSource = new StreamSource(is);
    }

    public void setXML(File file) {
        this.xmlSource = new StreamSource(file);
    }

    public void setXSL(String xslUri) throws PortalException {
        this.xslURI = ResourceLoader.getResourceAsURLString(this.caller.getClass(), xslUri);
    }

    public void setXSL(String sslUri, String stylesheetTitle, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = XSLT.getStylesheetSet(ResourceLoader.getResourceAsURLString(this.caller.getClass(), sslUri));
        set.setMediaProps(mediaProps);
        String xslUri = set.getStylesheetURI(stylesheetTitle, browserInfo);
        this.setXSL(xslUri);
    }

    public void setXSL(String sslUri, BrowserInfo browserInfo) throws PortalException {
        this.setXSL(sslUri, null, browserInfo);
    }

    public void setTarget(ContentHandler contentHandler) {
        this.xmlResult = new SAXResult(contentHandler);
    }

    public void setTarget(OutputStream os) {
        this.xmlResult = new StreamResult(os);
    }

    public void setTarget(Node node) {
        this.xmlResult = new DOMResult(node);
    }

    public void setStylesheetParameters(Hashtable stylesheetParameters) {
        this.stylesheetParams.putAll(stylesheetParameters);
    }

    public void setStylesheetParameters(HashMap stylesheetParameters) {
        this.stylesheetParams = stylesheetParameters;
    }

    public void setStylesheetParameter(String name, String value) {
        this.stylesheetParams.put(name, value);
    }

    public void transform() throws PortalException {
        try {
            Transformer trans = this.l18n == null ? XSLT.getTransformer(this.xslURI) : XSLT.getTransformer(this.xslURI, this.l18n);
            XSLT.setStylesheetParams(trans, this.stylesheetParams);
            trans.transform(this.xmlSource, this.xmlResult);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SAXParseException p) {
            throw new PortalException("Parse exception occurred on line " + p.getLineNumber() + ", column " + p.getColumnNumber() + " in " + "document with public ID " + p.getPublicId() + ", and system ID " + p.getSystemId() + ".", (Throwable)p);
        }
        catch (TransformerException p) {
            throw new PortalException(p.getMessageAndLocation(), (Throwable)p);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public static void transform(Source xmlSource, Result xmlResult, Hashtable stylesheetParams, String xslURI) throws PortalException {
        try {
            Transformer trans = XSLT.getTransformer(xslURI);
            XSLT.setStylesheetParams(trans, stylesheetParams);
            trans.transform(xmlSource, xmlResult);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    private static void setStylesheetParams(Transformer transformer, Map stylesheetParams) {
        if (stylesheetParams != null) {
            for (String key : stylesheetParams.keySet()) {
                Object o = stylesheetParams.get(key);
                if (o != null) {
                    if (o.getClass().getName().equals("[Ljava.lang.String;")) {
                        o = ((String[])o)[0];
                    }
                    transformer.setParameter(key, o);
                    continue;
                }
                log.warn((Object)("Stylesheet parameter [" + key + "] was illegally null."));
            }
        }
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.l18n = bundle;
    }

    public static Templates getTemplates(String stylesheetURI, ResourceBundle l18n) throws SAXException, PortalException, TransformerConfigurationException {
        URL url;
        String lookup = new StringBuffer(stylesheetURI).append(l18n.getLocale().toString()).toString();
        Templates temp = stylesheetRootCache.get(lookup);
        if (null != temp) {
            return temp;
        }
        Document xsl = null;
        try {
            url = ResourceLoader.getResourceAsURL(DocumentFactory.class, stylesheetURI);
            xsl = DocumentFactory.getDocumentFromStream(new BufferedInputStream(url.openStream(), 2048), url.toExternalForm());
        }
        catch (IOException e) {
            throw new ResourceMissingException(stylesheetURI, "Stylesheet", "Unable to read stylesheet from the specified location. Please check the stylesheet URL");
        }
        XSLT.addLocalization(xsl, l18n);
        DOMSource src = new DOMSource(xsl, url.toExternalForm());
        TransformerFactory tFactory = TransformerFactory.newInstance();
        temp = tFactory.newTemplates(src);
        if (stylesheetRootCacheEnabled) {
            stylesheetRootCache.put(lookup, temp);
        }
        return temp;
    }

    public static Templates getTemplates(String stylesheetURI) throws SAXException, PortalException {
        Templates temp = stylesheetRootCache.get(stylesheetURI);
        if (null != temp) {
            return temp;
        }
        try {
            TemplatesHandler thand = XSLT.getSAXTFactory().newTemplatesHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(thand);
            reader.parse(stylesheetURI);
            temp = thand.getTemplates();
            if (stylesheetRootCacheEnabled) {
                stylesheetRootCache.put(stylesheetURI, temp);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Cached templates for: " + stylesheetURI));
                }
            }
            return temp;
        }
        catch (IOException ioe) {
            throw new ResourceMissingException(stylesheetURI, "Stylesheet", "Unable to read stylesheet from [" + stylesheetURI + "]. Please check the stylesheet URL", ioe);
        }
        catch (TransformerConfigurationException tce) {
            log.error((Object)"XSLT::getTemplates() : unable to obtain TemplatesHandler due to TRAX misconfiguration!", (Throwable)tce);
            throw new GeneralRenderingException("XSLT: current TRAX configuration does not allow for TemplateHandlers. Please reconfigure/reinstall your TRAX implementation.", (Throwable)tce);
        }
        catch (SAXParseException px) {
            throw new GeneralRenderingException("XSLT:getTemplates(): SAXParseExeption: " + px.getMessage() + " line:" + px.getLineNumber() + " col:" + px.getColumnNumber(), (Throwable)px);
        }
        catch (SAXException sx) {
            if (null != sx.getException() && sx.getException() instanceof TransformerException) {
                TransformerException trx = (TransformerException)sx.getException();
                throw new GeneralRenderingException(trx.getMessageAndLocation(), (Throwable)trx);
            }
            throw sx;
        }
    }

    public static Transformer getTransformer(String stylesheetURI, ResourceBundle l18n) throws SAXException, PortalException {
        Transformer t = null;
        try {
            t = XSLT.getTemplates(stylesheetURI, l18n).newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            log.error((Object)("XSLT::getTransformer() : TRAX transformer is misconfigured : " + tce.getMessage()));
            SourceLocator loc = tce.getLocator();
            if (loc != null) {
                throw new PortalException(tce.getClass().getName() + " occurred " + "for document " + stylesheetURI + " at line " + loc.getLineNumber() + " and column " + loc.getColumnNumber() + ".", (Throwable)tce);
            }
            throw new PortalException(tce.getClass().getName() + " occurred " + "for document " + stylesheetURI + ".", (Throwable)tce);
        }
        return t;
    }

    public static Transformer getTransformer(String stylesheetURI) throws SAXException, PortalException {
        Transformer t = null;
        try {
            t = XSLT.getTemplates(stylesheetURI).newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            log.error((Object)"XSLT::getTransformer() : TRAX transformer is misconfigured", (Throwable)tce);
        }
        return t;
    }

    public static TransformerHandler getTransformerHandler(String stylesheetURI) throws SAXException, PortalException {
        TransformerHandler th = null;
        try {
            th = XSLT.getSAXTFactory().newTransformerHandler(XSLT.getTemplates(stylesheetURI));
        }
        catch (TransformerConfigurationException tce) {
            log.error((Object)"XSLT::getTransformerHandler() : TRAX transformer is misconfigured", (Throwable)tce);
        }
        return th;
    }

    public static TransformerHandler getTransformerHandler(String stylesheetURI, Locale[] locales, Object caller) throws SAXException, PortalException {
        TransformerHandler th = null;
        try {
            String localizedStylesheetURI = LocaleAwareXSLT.getLocaleAwareXslUri(stylesheetURI, locales, caller);
            th = XSLT.getSAXTFactory().newTransformerHandler(XSLT.getTemplates(localizedStylesheetURI));
        }
        catch (TransformerConfigurationException tce) {
            log.error((Object)"XSLT::getTransformerHandler() : TRAX transformer is misconfigured", (Throwable)tce);
        }
        return th;
    }

    public static StylesheetSet getStylesheetSet(String stylesheetListURI) throws PortalException {
        StylesheetSet stylesheetSet = stylesheetSetCache.get(stylesheetListURI);
        if (null != stylesheetSet) {
            return stylesheetSet;
        }
        stylesheetSet = new StylesheetSet(stylesheetListURI);
        if (stylesheetSetCacheEnabled) {
            stylesheetSetCache.put(stylesheetListURI, stylesheetSet);
            if (log.isInfoEnabled()) {
                log.info((Object)("Cached StylesheetSet for: " + stylesheetListURI));
            }
        }
        return stylesheetSet;
    }

    public static String getStylesheetURI(String sslUri, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = XSLT.getStylesheetSet(sslUri);
        String xslUri = set.getStylesheetURI(browserInfo);
        return xslUri;
    }

    public static String getStylesheetURI(String sslUri, String title, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = XSLT.getStylesheetSet(sslUri);
        String xslUri = set.getStylesheetURI(title, browserInfo);
        return xslUri;
    }

    protected static void addLocalization(Document xsl, ResourceBundle localization) {
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<String> en = localization.getKeys();
        while (en.hasMoreElements()) {
            keys.add(en.nextElement());
        }
        Element root = xsl.getDocumentElement();
        Node ft = root.getFirstChild();
        boolean foundFT = false;
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String name;
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            if (!foundFT && e.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") && e.getLocalName().equals("template")) {
                ft = n;
                foundFT = true;
            }
            if (!e.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") || !e.getLocalName().equals("variable") || !keys.contains(name = e.getAttribute("name"))) continue;
            e.removeAttribute("select");
            if (e.hasChildNodes()) {
                NodeList cl = e.getChildNodes();
                for (int j = cl.getLength() - 1; j >= 0; --j) {
                    e.removeChild(cl.item(j));
                }
            }
            e.appendChild(xsl.createTextNode(localization.getString(name)));
            keys.remove(name);
        }
        for (int z = 0; z < keys.size(); ++z) {
            String k = (String)keys.get(z);
            String v = localization.getString(k);
            Element e = xsl.createElementNS("http://www.w3.org/1999/XSL/Transform", "xsl:variable");
            e.setAttribute("name", k);
            e.appendChild(xsl.createTextNode(v));
            root.insertBefore(e, ft);
        }
        xsl.normalizeDocument();
    }

    protected static String escape(String s) {
        s = CommonUtils.replaceText(s, "'", "\u2019");
        return s;
    }

    public static void purgeStylesheetCache() {
        stylesheetRootCache.clear();
        stylesheetSetCache.clear();
    }

    public static int getStylesheetCacheSize() {
        return stylesheetRootCache.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("XSLT: ");
        sb.append(" stylesheetRootCacheEnabled:");
        sb.append(stylesheetRootCacheEnabled);
        sb.append(" stylesheetSetCacheEnabled: ");
        sb.append(stylesheetSetCacheEnabled);
        sb.append(" mediaProps: ");
        sb.append(mediaProps);
        if (this.caller != null) {
            sb.append(" caller:");
            sb.append(this.caller.getClass().getName());
        }
        if (this.xslURI != null) {
            sb.append(" xslURI:");
            sb.append(this.xslURI);
        }
        if (this.stylesheetParams != null) {
            sb.append(" stylesheetParams:");
            sb.append(this.stylesheetParams);
        }
        return sb.toString();
    }

    static {
        CacheFactory factory = CacheFactoryLocator.getCacheFactory();
        stylesheetRootCache = factory.getCache(ROOT_CACHE_NAME);
        stylesheetSetCache = factory.getCache(SET_CACHE_NAME);
        log = LogFactory.getLog(XSLT.class);
        stylesheetRootCacheEnabled = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.utils.XSLT.stylesheet_root_caching", true);
        stylesheetSetCacheEnabled = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.utils.XSLT.stylesheet_set_caching", true);
        saxTFactory = null;
    }
}

