/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CacheManagementHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;

    @Required
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Map<String, CacheStatistics> getAllCacheStatistics() {
        TreeMap<String, CacheStatistics> allCacheStatistics = new TreeMap<String, CacheStatistics>(CaseInsenstivieStringComparator.INSTANCE);
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (null == cache || !Status.STATUS_ALIVE.equals(cache.getStatus())) continue;
            CacheConfiguration cacheConfiguration = cache.getCacheConfiguration();
            Statistics statistics = cache.getStatistics();
            CacheStatistics cacheStatistics = new CacheStatistics();
            cacheStatistics.hits = statistics.getCacheHits();
            cacheStatistics.misses = statistics.getCacheMisses();
            cacheStatistics.size = statistics.getObjectCount();
            cacheStatistics.maxSize = cacheConfiguration.getMaxElementsInMemory() + cacheConfiguration.getMaxElementsOnDisk();
            allCacheStatistics.put(cacheName, cacheStatistics);
        }
        return allCacheStatistics;
    }

    public Statistics getCacheStatistics(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (null != cache && Status.STATUS_ALIVE.equals(cache.getStatus())) {
            Statistics result = cache.getStatistics();
            return result;
        }
        return null;
    }

    public void clearCache(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (null != cache && Status.STATUS_ALIVE.equals(cache.getStatus())) {
            cache.removeAll();
            this.logger.warn((Object)("finished removeAll for cache: " + cacheName));
        }
    }

    public void clearAllCaches() {
        this.logger.warn((Object)"beginning request to clear all caches");
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.clearCache(cacheName);
        }
        this.logger.warn((Object)"completed request to clear all caches");
    }

    public static class CacheStatistics {
        public long hits;
        public long misses;
        public long size;
        public long maxSize;

        public long getHits() {
            return this.hits;
        }

        public long getMisses() {
            return this.misses;
        }

        public long getSize() {
            return this.size;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public double getUsage() {
            if (this.maxSize == 0L) {
                return 0.0;
            }
            return (double)this.size / (double)this.maxSize;
        }

        public double getEffectiveness() {
            double requests = this.hits + this.misses;
            if (requests == 0.0) {
                return 0.0;
            }
            return (double)this.hits / requests;
        }
    }

    private static final class CaseInsenstivieStringComparator
    implements Comparator<String> {
        public static final CaseInsenstivieStringComparator INSTANCE = new CaseInsenstivieStringComparator();

        private CaseInsenstivieStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

