/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.IPortalInfoProvider;
import org.jasig.portal.utils.RandomTokenGenerator;
import org.jasig.portal.utils.threading.ReadResult;
import org.jasig.portal.utils.threading.ReadWriteCallback;
import org.jasig.portal.utils.threading.ReadWriteLockTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="portalInfoProvider")
public class PortalInfoProviderImpl
implements IPortalInfoProvider,
ReadWriteCallback<String> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String serverName;
    private String networkInterfaceName;
    private String resolvedServerName;
    private String resolvedUniqueServerName;
    private final ReadWriteLock serverNameResolutionLock = new ReentrantReadWriteLock();

    @Value(value="${org.jasig.portal.PortalInfoProvider.serverName:}")
    public void setServerName(String serverName) {
        this.serverName = StringUtils.trimToNull((String)serverName);
    }

    @Value(value="${org.jasig.portal.PortalInfoProvider.networkInterfaceName:}")
    public void setNetworkInterfaceName(String networkInterfaceName) {
        this.networkInterfaceName = StringUtils.trimToNull((String)networkInterfaceName);
    }

    public final String getServerName() {
        return (String)ReadWriteLockTemplate.doWithLock((ReadWriteLock)this.serverNameResolutionLock, (ReadWriteCallback)this);
    }

    public String getUniqueServerName() {
        ReadWriteLockTemplate.doWithLock((ReadWriteLock)this.serverNameResolutionLock, (ReadWriteCallback)this);
        return this.resolvedUniqueServerName;
    }

    public ReadResult<String> doInReadLock() {
        if (this.resolvedServerName != null) {
            return ReadResult.create((boolean)false, (Object)this.resolvedServerName);
        }
        return ReadResult.create((boolean)true);
    }

    public String doInWriteLock(ReadResult<String> readResult) {
        this.resolvedServerName = this.resolveServerName();
        this.resolvedUniqueServerName = this.resolvedServerName + "_" + RandomTokenGenerator.INSTANCE.generateRandomToken(4);
        return this.resolvedServerName;
    }

    protected String resolveServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        String name = this.getNetworkInterfaceName(this.networkInterfaceName);
        if (name != null) {
            return name;
        }
        name = this.getLocalHostName();
        if (name != null) {
            return name;
        }
        name = this.getDefaultNetworkInterfaceName();
        if (name != null) {
            return name;
        }
        this.logger.warn("Failed to get serverName for NetworkInterface (" + this.networkInterfaceName + "), for InetAddress.getLocalHost(), for any NetworkInterface. Reverting to JVM instance specific UUID string.");
        return UUID.randomUUID().toString();
    }

    protected String getDefaultNetworkInterfaceName() {
        Enumeration<NetworkInterface> networkInterfaceEnum;
        this.logger.info("Attempting to resolve serverName by iterating over NetworkInterface.getNetworkInterfaces()");
        try {
            networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            this.logger.warn("Failed to get list of available NetworkInterfaces.", (Throwable)e);
            return null;
        }
        String name = null;
        while (networkInterfaceEnum.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
            Enumeration<InetAddress> inetAddressEnum = networkInterface.getInetAddresses();
            while (inetAddressEnum.hasMoreElements()) {
                InetAddress inetAddress = inetAddressEnum.nextElement();
                name = inetAddress.getHostName();
                if (name.startsWith("localhost")) continue;
                return name;
            }
        }
        return name;
    }

    protected String getLocalHostName() {
        InetAddress localhost;
        this.logger.info("Attempting to resolve serverName using InetAddress.getLocalHost()");
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.logger.warn("Failed to find InetAddress for InetAddress.getLocalHost()", (Throwable)e);
            return null;
        }
        return localhost.getHostName();
    }

    protected String getNetworkInterfaceName(String networkInterfaceName) {
        NetworkInterface networkInterface;
        if (networkInterfaceName == null) {
            return null;
        }
        this.logger.info("Attempting to resolve serverName using NetworkInterface named ({})", (Object)networkInterfaceName);
        try {
            networkInterface = NetworkInterface.getByName(networkInterfaceName);
        }
        catch (SocketException e) {
            this.logger.warn("Failed to get NetworkInterface for name (" + networkInterfaceName + ").", (Throwable)e);
            return null;
        }
        if (networkInterface == null) {
            this.logger.warn("No NetworkInterface could be found for name (" + networkInterfaceName + "). Available interface names: " + this.getNetworkInterfaceNames());
            return null;
        }
        Enumeration<InetAddress> inetAddressesEnum = networkInterface.getInetAddresses();
        if (!inetAddressesEnum.hasMoreElements()) {
            this.logger.warn("NetworkInterface (" + networkInterface.getName() + ") has no InetAddresses to get a name from.");
            return null;
        }
        InetAddress inetAddress = inetAddressesEnum.nextElement();
        if (inetAddressesEnum.hasMoreElements()) {
            this.logger.warn("NetworkInterface (" + networkInterface.getName() + ") has more than one InetAddress, the hostName of the first will be returned.");
        }
        return inetAddress.getHostName();
    }

    protected Set<String> getNetworkInterfaceNames() {
        Enumeration<NetworkInterface> networkInterfacesEnum;
        try {
            networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            this.logger.warn("Failed to get list of available NetworkInterfaces.", (Throwable)e);
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        while (networkInterfacesEnum.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfacesEnum.nextElement();
            names.add(networkInterface.getName());
        }
        return names;
    }
}

