/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.character.stream;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.MatchResult;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jasig.portal.character.stream.CharacterEventSource;
import org.jasig.portal.character.stream.events.CharacterEvent;

public abstract class BasePlaceholderEventSource
implements CharacterEventSource {
    public void generateCharacterEvents(HttpServletRequest servletRequest, XMLEventReader eventReader, StartElement event, Collection<CharacterEvent> eventBuffer) throws XMLStreamException {
        this.generateCharacterEvents(servletRequest, event, eventBuffer);
        this.readToEndElement(eventReader, event);
    }

    protected void generateCharacterEvents(HttpServletRequest servletRequest, StartElement event, Collection<CharacterEvent> eventBuffer) {
        throw new UnsupportedOperationException("Super class must implement this method");
    }

    public void generateCharacterEvents(HttpServletRequest servletRequest, MatchResult matchResult, Collection<CharacterEvent> eventBuffer) {
        throw new UnsupportedOperationException("Super class must implement this method");
    }

    protected final void readToEndElement(XMLEventReader eventReader, StartElement event) throws XMLStreamException {
        LinkedList<QName> elementStack = new LinkedList<QName>();
        elementStack.push(event.getName());
        while (!elementStack.isEmpty()) {
            EndElement endElement;
            QName lastStart;
            XMLEvent nextEvent = eventReader.nextEvent();
            if (nextEvent.isStartElement()) {
                StartElement startElement = nextEvent.asStartElement();
                elementStack.push(startElement.getName());
                continue;
            }
            if (!nextEvent.isEndElement() || (lastStart = (QName)elementStack.pop()).equals((endElement = nextEvent.asEndElement()).getName())) continue;
            throw new XMLStreamException("Invalid XML Structure, expected EndElement " + lastStart + " but found EndElment " + endElement.getName());
        }
    }
}

