/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.character.stream.events;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.jasig.portal.character.stream.events.CharacterDataEvent;
import org.jasig.portal.character.stream.events.CharacterEventTypes;
import org.springframework.util.Assert;

public final class CharacterDataEventImpl
implements CharacterDataEvent {
    private static final long serialVersionUID = 1L;
    public static final CharacterDataEvent EMPTY_CHARACTER_DATA = new CharacterDataEventImpl("");
    private static final LoadingCache<String, CharacterDataEvent> WEAK_EVENT_CACHE = CacheBuilder.newBuilder().weakValues().recordStats().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private final String data;
    private int hash = 0;

    public static CharacterDataEvent create(String data) {
        if (data.length() == 0) {
            return EMPTY_CHARACTER_DATA;
        }
        CharacterDataEvent event = (CharacterDataEvent)WEAK_EVENT_CACHE.getIfPresent((Object)data);
        if (event == null) {
            data = new String(data);
            event = (CharacterDataEvent)WEAK_EVENT_CACHE.getUnchecked((Object)data);
        }
        return event;
    }

    static Cache<String, CharacterDataEvent> getEventCache() {
        return WEAK_EVENT_CACHE;
    }

    private CharacterDataEventImpl(String data) {
        Assert.notNull((Object)data);
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public CharacterEventTypes getEventType() {
        return CharacterEventTypes.CHARACTER;
    }

    public String toString() {
        return "CharacterDataEvent [data=" + this.data + "]";
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = this.internalHashCode();
        }
        return h;
    }

    private int internalHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getEventType().hashCode();
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterDataEvent)) {
            return false;
        }
        CharacterDataEvent other = (CharacterDataEvent)obj;
        if (this.data == null ? other.getData() != null : !this.data.equals(other.getData())) {
            return false;
        }
        return !(this.getEventType() == null ? other.getEventType() != null : !this.getEventType().equals((Object)other.getEventType()));
    }
}

