/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.util.concurrent.atomic.AtomicLong;
import org.jasig.portal.concurrency.caching.CacheStatisticsMBean;

public final class CacheStatistics
implements CacheStatisticsMBean {
    private final AtomicLong hitCount = new AtomicLong();
    private final AtomicLong missCount = new AtomicLong();
    private final AtomicLong loadSuccessCount = new AtomicLong();
    private final AtomicLong loadExceptionCount = new AtomicLong();
    private final AtomicLong totalHitTime = new AtomicLong();
    private final AtomicLong totalLoadTime = new AtomicLong();
    private final AtomicLong totalExceptionTime = new AtomicLong();

    public final void recordHit(long time) {
        this.hitCount.incrementAndGet();
        this.totalHitTime.addAndGet(time);
    }

    public final void recordMissAndLoad(long time) {
        this.missCount.incrementAndGet();
        this.loadSuccessCount.incrementAndGet();
        this.totalLoadTime.addAndGet(time);
    }

    public final void recordMissAndException(long time) {
        this.missCount.incrementAndGet();
        this.loadExceptionCount.incrementAndGet();
        this.totalExceptionTime.addAndGet(time);
    }

    public long getRequestCount() {
        return this.hitCount.get() + this.missCount.get();
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public double getHitRate() {
        long requestCount = this.getRequestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount.get() / (double)requestCount;
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public double getMissRate() {
        long requestCount = this.getRequestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount.get() / (double)requestCount;
    }

    public long getLoadCount() {
        return this.loadSuccessCount.get() + this.loadExceptionCount.get();
    }

    public long getLoadSuccessCount() {
        return this.loadSuccessCount.get();
    }

    public long getLoadExceptionCount() {
        return this.loadExceptionCount.get();
    }

    public double getLoadExceptionRate() {
        long totalLoadCount = this.loadSuccessCount.get() + this.loadExceptionCount.get();
        return totalLoadCount == 0L ? 0.0 : (double)this.loadExceptionCount.get() / (double)totalLoadCount;
    }

    public long getTotalLoadTime() {
        return this.totalLoadTime.get();
    }

    public double getAverageLoadPenalty() {
        long loadCount = this.loadSuccessCount.get();
        return loadCount == 0L ? 0.0 : (double)this.totalLoadTime.get() / (double)loadCount;
    }

    public long getTotalHitTime() {
        return this.totalHitTime.get();
    }

    public double getAverageHitPenalty() {
        long hits = this.hitCount.get();
        return hits == 0L ? 0.0 : (double)this.totalHitTime.get() / (double)hits;
    }

    public long getTotalExceptionTime() {
        return this.totalExceptionTime.get();
    }

    public double getAverageExceptionPenalty() {
        long exceptions = this.loadExceptionCount.get();
        return exceptions == 0L ? 0.0 : (double)this.totalExceptionTime.get() / (double)exceptions;
    }
}

