/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;

public enum AggregationInterval {
    MINUTE(DateTimeFieldType.minuteOfHour(), true),
    FIVE_MINUTE(null, true),
    HOUR(DateTimeFieldType.hourOfDay(), true),
    DAY(DateTimeFieldType.dayOfMonth(), false),
    WEEK(DateTimeFieldType.weekOfWeekyear(), false),
    MONTH(DateTimeFieldType.monthOfYear(), false),
    CALENDAR_QUARTER(null, false),
    ACADEMIC_TERM(null, false),
    YEAR(DateTimeFieldType.year(), false);

    private final DateTimeFieldType dateTimeFieldType;
    private final boolean hasTimePart;

    private AggregationInterval(DateTimeFieldType dateTimeFieldType, boolean hasTimePart) {
        this.dateTimeFieldType = dateTimeFieldType;
        this.hasTimePart = hasTimePart;
    }

    public boolean isHasTimePart() {
        return this.hasTimePart;
    }

    public DateTimeFieldType getDateTimeFieldType() {
        return this.dateTimeFieldType;
    }

    public boolean isSupportsDetermination() {
        return this.dateTimeFieldType != null || this == FIVE_MINUTE;
    }

    public int determineIntervalsBetween(ReadableInstant start, ReadableInstant end) {
        double ratio;
        DateTimeFieldType dtft;
        if (!this.isSupportsDetermination()) {
            throw new IllegalArgumentException("Cannot compute intervals between for " + this + " please use " + AggregationIntervalHelper.class);
        }
        switch (1.$SwitchMap$org$jasig$portal$events$aggr$AggregationInterval[this.ordinal()]) {
            case 1: {
                dtft = MINUTE.getDateTimeFieldType();
                ratio = 5.0;
                break;
            }
            default: {
                dtft = this.dateTimeFieldType;
                ratio = 1.0;
            }
        }
        DurationFieldType durationType = dtft.getDurationType();
        Chronology chrono = DateTimeUtils.getInstantChronology((ReadableInstant)start);
        return (int)Math.round((double)durationType.getField(chrono).getDifference(end.getMillis(), start.getMillis()) / ratio);
    }

    public DateTime determineStart(DateTime instant) {
        if (this.dateTimeFieldType != null) {
            return instant.property(this.dateTimeFieldType).roundFloorCopy();
        }
        if (this == FIVE_MINUTE) {
            return instant.hourOfDay().roundFloorCopy().plusMinutes(instant.getMinuteOfHour() / 5 * 5);
        }
        throw new IllegalArgumentException("Cannot compute interval start time for " + this + " please use " + AggregationIntervalHelper.class);
    }

    public DateTime determineEnd(DateTime instant) {
        if (this.dateTimeFieldType != null) {
            DateTime start = instant.property(this.dateTimeFieldType).roundFloorCopy();
            return start.property(this.dateTimeFieldType).addToCopy(1);
        }
        if (this == FIVE_MINUTE) {
            DateTime start = instant.hourOfDay().roundFloorCopy().plusMinutes(instant.getMinuteOfHour() / 5 * 5);
            return start.plusMinutes(5);
        }
        throw new IllegalArgumentException("Cannot compute interval end time for " + this + " please use " + AggregationIntervalHelper.class);
    }
}

