/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public final class EventProcessingResult {
    private final int processed;
    private final DateTime start;
    private final DateTime end;
    private final boolean complete;
    private final double creationRate;

    protected EventProcessingResult(int processed, DateTime start, DateTime end, boolean complete) {
        this.processed = processed;
        this.start = start;
        this.end = end;
        this.complete = complete;
        this.creationRate = start == null || end == null ? 0.0 : (double)processed / (double)Math.abs(Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)end).getSeconds());
    }

    public double getCreationRate() {
        return this.creationRate;
    }

    public int getProcessed() {
        return this.processed;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

